/*
 * Copyright (c) 2015 Ruslan Bukin <br@bsdpad.com>
 * All rights reserved.
 *
 * This software was developed by the University of Cambridge Computer
 * Laboratory as part of the CTSRD Project, with support from the UK Higher
 * Education Innovation Fund (HEIF).
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met: redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer;
 * redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution;
 * neither the name of the copyright holders nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "arch/arm/freebsd/process.hh"

#include <sys/mman.h>
#include <sys/param.h>
#include <sys/syscall.h>
#include <sys/sysctl.h>
#include <sys/types.h>
#include <utime.h>

#include "arch/arm/freebsd/freebsd.hh"
#include "arch/arm/isa_traits.hh"
#include "base/trace.hh"
#include "cpu/thread_context.hh"
#include "kern/freebsd/freebsd.hh"
#include "sim/process.hh"
#include "sim/syscall_desc.hh"
#include "sim/syscall_emul.hh"
#include "sim/system.hh"

using namespace std;
using namespace ArmISA;

static SyscallReturn
issetugidFunc(SyscallDesc *desc, int callnum, Process *process,
              ThreadContext *tc)
{

    return 0;
}

static SyscallReturn
sysctlFunc(SyscallDesc *desc, int callnum, Process *process,
           ThreadContext *tc)
{
    int index = 0;
    uint64_t ret;

    Addr namep = process->getSyscallArg(tc, index);
    size_t namelen = process->getSyscallArg(tc, index);
    Addr oldp = process->getSyscallArg(tc, index);
    Addr oldlenp = process->getSyscallArg(tc, index);
    Addr newp = process->getSyscallArg(tc, index);
    size_t newlen = process->getSyscallArg(tc, index);

    BufferArg buf(namep, sizeof(size_t));
    BufferArg buf2(oldp, sizeof(size_t));
    BufferArg buf3(oldlenp, sizeof(size_t));
    BufferArg buf4(newp, sizeof(size_t));

    buf.copyIn(tc->getMemProxy());
    buf2.copyIn(tc->getMemProxy());
    buf3.copyIn(tc->getMemProxy());

    void *hnewp = NULL;
    if (newp) {
        buf4.copyIn(tc->getMemProxy());
        hnewp = (void *)buf4.bufferPtr();
    }

    uint32_t *hnamep = (uint32_t *)buf.bufferPtr();
    void *holdp = (void *)buf2.bufferPtr();
    size_t *holdlenp = (size_t *)buf3.bufferPtr();

    ret = sysctl((int *)hnamep, namelen, holdp, holdlenp, hnewp, newlen);

    buf.copyOut(tc->getMemProxy());
    buf2.copyOut(tc->getMemProxy());
    buf3.copyOut(tc->getMemProxy());
    if (newp)
        buf4.copyOut(tc->getMemProxy());

    return (ret);
}

static SyscallDesc syscallDescs32[] = {
    /*    0 */ SyscallDesc("unused#000", unimplementedFunc),
    /*    1 */ SyscallDesc("unused#001", unimplementedFunc),
    /*    2 */ SyscallDesc("unused#002", unimplementedFunc),
    /*    3 */ SyscallDesc("unused#003", unimplementedFunc),
    /*    4 */ SyscallDesc("unused#004", unimplementedFunc),
    /*    5 */ SyscallDesc("unused#005", unimplementedFunc),
    /*    6 */ SyscallDesc("unused#006", unimplementedFunc),
    /*    7 */ SyscallDesc("unused#007", unimplementedFunc),
    /*    8 */ SyscallDesc("unused#008", unimplementedFunc),
    /*    9 */ SyscallDesc("unused#009", unimplementedFunc),
    /*   10 */ SyscallDesc("unused#010", unimplementedFunc),
    /*   11 */ SyscallDesc("unused#011", unimplementedFunc),
    /*   12 */ SyscallDesc("unused#012", unimplementedFunc),
    /*   13 */ SyscallDesc("unused#013", unimplementedFunc),
    /*   14 */ SyscallDesc("unused#014", unimplementedFunc),
    /*   15 */ SyscallDesc("unused#015", unimplementedFunc),
    /*   16 */ SyscallDesc("unused#016", unimplementedFunc),
    /*   17 */ SyscallDesc("unused#017", unimplementedFunc),
    /*   18 */ SyscallDesc("unused#018", unimplementedFunc),
    /*   19 */ SyscallDesc("unused#019", unimplementedFunc),
    /*   20 */ SyscallDesc("unused#020", unimplementedFunc),
    /*   21 */ SyscallDesc("unused#021", unimplementedFunc),
    /*   22 */ SyscallDesc("unused#022", unimplementedFunc),
    /*   23 */ SyscallDesc("unused#023", unimplementedFunc),
    /*   24 */ SyscallDesc("unused#024", unimplementedFunc),
    /*   25 */ SyscallDesc("unused#025", unimplementedFunc),
    /*   26 */ SyscallDesc("unused#026", unimplementedFunc),
    /*   27 */ SyscallDesc("unused#027", unimplementedFunc),
    /*   28 */ SyscallDesc("unused#028", unimplementedFunc),
    /*   29 */ SyscallDesc("unused#029", unimplementedFunc),
    /*   30 */ SyscallDesc("unused#030", unimplementedFunc),
    /*   31 */ SyscallDesc("unused#031", unimplementedFunc),
    /*   32 */ SyscallDesc("unused#032", unimplementedFunc),
    /*   33 */ SyscallDesc("unused#033", unimplementedFunc),
    /*   34 */ SyscallDesc("unused#034", unimplementedFunc),
    /*   35 */ SyscallDesc("unused#035", unimplementedFunc),
    /*   36 */ SyscallDesc("unused#036", unimplementedFunc),
    /*   37 */ SyscallDesc("unused#037", unimplementedFunc),
    /*   38 */ SyscallDesc("unused#038", unimplementedFunc),
    /*   39 */ SyscallDesc("unused#039", unimplementedFunc),
    /*   40 */ SyscallDesc("unused#040", unimplementedFunc),
    /*   41 */ SyscallDesc("unused#041", unimplementedFunc),
    /*   42 */ SyscallDesc("unused#042", unimplementedFunc),
    /*   43 */ SyscallDesc("unused#043", unimplementedFunc),
    /*   44 */ SyscallDesc("unused#044", unimplementedFunc),
    /*   45 */ SyscallDesc("unused#045", unimplementedFunc),
    /*   46 */ SyscallDesc("unused#046", unimplementedFunc),
    /*   47 */ SyscallDesc("unused#047", unimplementedFunc),
    /*   48 */ SyscallDesc("unused#048", unimplementedFunc),
    /*   49 */ SyscallDesc("unused#049", unimplementedFunc),
    /*   50 */ SyscallDesc("unused#050", unimplementedFunc),
    /*   51 */ SyscallDesc("unused#051", unimplementedFunc),
    /*   52 */ SyscallDesc("unused#052", unimplementedFunc),
    /*   53 */ SyscallDesc("unused#053", unimplementedFunc),
    /*   54 */ SyscallDesc("unused#054", unimplementedFunc),
    /*   55 */ SyscallDesc("unused#055", unimplementedFunc),
    /*   56 */ SyscallDesc("unused#056", unimplementedFunc),
    /*   57 */ SyscallDesc("unused#057", unimplementedFunc),
    /*   58 */ SyscallDesc("unused#058", unimplementedFunc),
    /*   59 */ SyscallDesc("unused#059", unimplementedFunc),
    /*   60 */ SyscallDesc("unused#060", unimplementedFunc),
    /*   61 */ SyscallDesc("unused#061", unimplementedFunc),
    /*   62 */ SyscallDesc("unused#062", unimplementedFunc),
    /*   63 */ SyscallDesc("unused#063", unimplementedFunc),
    /*   64 */ SyscallDesc("unused#064", unimplementedFunc),
    /*   65 */ SyscallDesc("unused#065", unimplementedFunc),
    /*   66 */ SyscallDesc("unused#066", unimplementedFunc),
    /*   67 */ SyscallDesc("unused#067", unimplementedFunc),
    /*   68 */ SyscallDesc("unused#068", unimplementedFunc),
    /*   69 */ SyscallDesc("unused#069", unimplementedFunc),
    /*   70 */ SyscallDesc("unused#070", unimplementedFunc),
    /*   71 */ SyscallDesc("unused#071", unimplementedFunc),
    /*   72 */ SyscallDesc("unused#072", unimplementedFunc),
    /*   73 */ SyscallDesc("unused#073", unimplementedFunc),
    /*   74 */ SyscallDesc("unused#074", unimplementedFunc),
    /*   75 */ SyscallDesc("unused#075", unimplementedFunc),
    /*   76 */ SyscallDesc("unused#076", unimplementedFunc),
    /*   77 */ SyscallDesc("unused#077", unimplementedFunc),
    /*   78 */ SyscallDesc("unused#078", unimplementedFunc),
    /*   79 */ SyscallDesc("unused#079", unimplementedFunc),
    /*   80 */ SyscallDesc("unused#080", unimplementedFunc),
    /*   81 */ SyscallDesc("unused#081", unimplementedFunc),
    /*   82 */ SyscallDesc("unused#082", unimplementedFunc),
    /*   83 */ SyscallDesc("unused#083", unimplementedFunc),
    /*   84 */ SyscallDesc("unused#084", unimplementedFunc),
    /*   85 */ SyscallDesc("unused#085", unimplementedFunc),
    /*   86 */ SyscallDesc("unused#086", unimplementedFunc),
    /*   87 */ SyscallDesc("unused#087", unimplementedFunc),
    /*   88 */ SyscallDesc("unused#088", unimplementedFunc),
    /*   89 */ SyscallDesc("unused#089", unimplementedFunc),
    /*   90 */ SyscallDesc("unused#090", unimplementedFunc),
    /*   91 */ SyscallDesc("unused#091", unimplementedFunc),
    /*   92 */ SyscallDesc("unused#092", unimplementedFunc),
    /*   93 */ SyscallDesc("unused#093", unimplementedFunc),
    /*   94 */ SyscallDesc("unused#094", unimplementedFunc),
    /*   95 */ SyscallDesc("unused#095", unimplementedFunc),
    /*   96 */ SyscallDesc("unused#096", unimplementedFunc),
    /*   97 */ SyscallDesc("unused#097", unimplementedFunc),
    /*   98 */ SyscallDesc("unused#098", unimplementedFunc),
    /*   99 */ SyscallDesc("unused#099", unimplementedFunc),
    /*  100 */ SyscallDesc("unused#100", unimplementedFunc),
    /*  101 */ SyscallDesc("unused#101", unimplementedFunc),
    /*  102 */ SyscallDesc("unused#102", unimplementedFunc),
    /*  103 */ SyscallDesc("unused#103", unimplementedFunc),
    /*  104 */ SyscallDesc("unused#104", unimplementedFunc),
    /*  105 */ SyscallDesc("unused#105", unimplementedFunc),
    /*  106 */ SyscallDesc("unused#106", unimplementedFunc),
    /*  107 */ SyscallDesc("unused#107", unimplementedFunc),
    /*  108 */ SyscallDesc("unused#108", unimplementedFunc),
    /*  109 */ SyscallDesc("unused#109", unimplementedFunc),
    /*  110 */ SyscallDesc("unused#110", unimplementedFunc),
    /*  111 */ SyscallDesc("unused#111", unimplementedFunc),
    /*  112 */ SyscallDesc("unused#112", unimplementedFunc),
    /*  113 */ SyscallDesc("unused#113", unimplementedFunc),
    /*  114 */ SyscallDesc("unused#114", unimplementedFunc),
    /*  115 */ SyscallDesc("unused#115", unimplementedFunc),
    /*  116 */ SyscallDesc("unused#116", unimplementedFunc),
    /*  117 */ SyscallDesc("unused#117", unimplementedFunc),
    /*  118 */ SyscallDesc("unused#118", unimplementedFunc),
    /*  119 */ SyscallDesc("unused#119", unimplementedFunc),
    /*  120 */ SyscallDesc("unused#120", unimplementedFunc),
    /*  121 */ SyscallDesc("unused#121", unimplementedFunc),
    /*  122 */ SyscallDesc("unused#122", unimplementedFunc),
    /*  123 */ SyscallDesc("unused#123", unimplementedFunc),
    /*  124 */ SyscallDesc("unused#124", unimplementedFunc),
    /*  125 */ SyscallDesc("unused#125", unimplementedFunc),
    /*  126 */ SyscallDesc("unused#126", unimplementedFunc),
    /*  127 */ SyscallDesc("unused#127", unimplementedFunc),
    /*  128 */ SyscallDesc("unused#128", unimplementedFunc),
    /*  129 */ SyscallDesc("unused#129", unimplementedFunc),
    /*  130 */ SyscallDesc("unused#130", unimplementedFunc),
    /*  131 */ SyscallDesc("unused#131", unimplementedFunc),
    /*  132 */ SyscallDesc("unused#132", unimplementedFunc),
    /*  133 */ SyscallDesc("unused#133", unimplementedFunc),
    /*  134 */ SyscallDesc("unused#134", unimplementedFunc),
    /*  135 */ SyscallDesc("unused#135", unimplementedFunc),
    /*  136 */ SyscallDesc("unused#136", unimplementedFunc),
    /*  137 */ SyscallDesc("unused#137", unimplementedFunc),
    /*  138 */ SyscallDesc("unused#138", unimplementedFunc),
    /*  139 */ SyscallDesc("unused#139", unimplementedFunc),
    /*  140 */ SyscallDesc("unused#140", unimplementedFunc),
    /*  141 */ SyscallDesc("unused#141", unimplementedFunc),
    /*  142 */ SyscallDesc("unused#142", unimplementedFunc),
    /*  143 */ SyscallDesc("unused#143", unimplementedFunc),
    /*  144 */ SyscallDesc("unused#144", unimplementedFunc),
    /*  145 */ SyscallDesc("unused#145", unimplementedFunc),
    /*  146 */ SyscallDesc("unused#146", unimplementedFunc),
    /*  147 */ SyscallDesc("unused#147", unimplementedFunc),
    /*  148 */ SyscallDesc("unused#148", unimplementedFunc),
    /*  149 */ SyscallDesc("unused#149", unimplementedFunc),
    /*  150 */ SyscallDesc("unused#150", unimplementedFunc),
    /*  151 */ SyscallDesc("unused#151", unimplementedFunc),
    /*  152 */ SyscallDesc("unused#152", unimplementedFunc),
    /*  153 */ SyscallDesc("unused#153", unimplementedFunc),
    /*  154 */ SyscallDesc("unused#154", unimplementedFunc),
    /*  155 */ SyscallDesc("unused#155", unimplementedFunc),
    /*  156 */ SyscallDesc("unused#156", unimplementedFunc),
    /*  157 */ SyscallDesc("unused#157", unimplementedFunc),
    /*  158 */ SyscallDesc("unused#158", unimplementedFunc),
    /*  159 */ SyscallDesc("unused#159", unimplementedFunc),
    /*  160 */ SyscallDesc("unused#160", unimplementedFunc),
    /*  161 */ SyscallDesc("unused#161", unimplementedFunc),
    /*  162 */ SyscallDesc("unused#162", unimplementedFunc),
    /*  163 */ SyscallDesc("unused#163", unimplementedFunc),
    /*  164 */ SyscallDesc("unused#164", unimplementedFunc),
    /*  165 */ SyscallDesc("unused#165", unimplementedFunc),
    /*  166 */ SyscallDesc("unused#166", unimplementedFunc),
    /*  167 */ SyscallDesc("unused#167", unimplementedFunc),
    /*  168 */ SyscallDesc("unused#168", unimplementedFunc),
    /*  169 */ SyscallDesc("unused#169", unimplementedFunc),
    /*  170 */ SyscallDesc("unused#170", unimplementedFunc),
    /*  171 */ SyscallDesc("unused#171", unimplementedFunc),
    /*  172 */ SyscallDesc("unused#172", unimplementedFunc),
    /*  173 */ SyscallDesc("unused#173", unimplementedFunc),
    /*  174 */ SyscallDesc("unused#174", unimplementedFunc),
    /*  175 */ SyscallDesc("unused#175", unimplementedFunc),
    /*  176 */ SyscallDesc("unused#176", unimplementedFunc),
    /*  177 */ SyscallDesc("unused#177", unimplementedFunc),
    /*  178 */ SyscallDesc("unused#178", unimplementedFunc),
    /*  179 */ SyscallDesc("unused#179", unimplementedFunc),
    /*  180 */ SyscallDesc("unused#180", unimplementedFunc),
    /*  181 */ SyscallDesc("unused#181", unimplementedFunc),
    /*  182 */ SyscallDesc("unused#182", unimplementedFunc),
    /*  183 */ SyscallDesc("unused#183", unimplementedFunc),
    /*  184 */ SyscallDesc("unused#184", unimplementedFunc),
    /*  185 */ SyscallDesc("unused#185", unimplementedFunc),
    /*  186 */ SyscallDesc("unused#186", unimplementedFunc),
    /*  187 */ SyscallDesc("unused#187", unimplementedFunc),
    /*  188 */ SyscallDesc("unused#188", unimplementedFunc),
    /*  189 */ SyscallDesc("unused#189", unimplementedFunc),
    /*  190 */ SyscallDesc("unused#190", unimplementedFunc),
    /*  191 */ SyscallDesc("unused#191", unimplementedFunc),
    /*  192 */ SyscallDesc("unused#192", unimplementedFunc),
    /*  193 */ SyscallDesc("unused#193", unimplementedFunc),
    /*  194 */ SyscallDesc("unused#194", unimplementedFunc),
    /*  195 */ SyscallDesc("unused#195", unimplementedFunc),
    /*  196 */ SyscallDesc("unused#196", unimplementedFunc),
    /*  197 */ SyscallDesc("unused#197", unimplementedFunc),
    /*  198 */ SyscallDesc("unused#198", unimplementedFunc),
    /*  199 */ SyscallDesc("unused#199", unimplementedFunc),
    /*  200 */ SyscallDesc("unused#200", unimplementedFunc),
    /*  201 */ SyscallDesc("unused#201", unimplementedFunc),
    /*  202 */ SyscallDesc("unused#202", unimplementedFunc),
    /*  203 */ SyscallDesc("unused#203", unimplementedFunc),
    /*  204 */ SyscallDesc("unused#204", unimplementedFunc),
    /*  205 */ SyscallDesc("unused#205", unimplementedFunc),
    /*  206 */ SyscallDesc("unused#206", unimplementedFunc),
    /*  207 */ SyscallDesc("unused#207", unimplementedFunc),
    /*  208 */ SyscallDesc("unused#208", unimplementedFunc),
    /*  209 */ SyscallDesc("unused#209", unimplementedFunc),
    /*  210 */ SyscallDesc("unused#210", unimplementedFunc),
    /*  211 */ SyscallDesc("unused#211", unimplementedFunc),
    /*  212 */ SyscallDesc("unused#212", unimplementedFunc),
    /*  213 */ SyscallDesc("unused#213", unimplementedFunc),
    /*  214 */ SyscallDesc("unused#214", unimplementedFunc),
    /*  215 */ SyscallDesc("unused#215", unimplementedFunc),
    /*  216 */ SyscallDesc("unused#216", unimplementedFunc),
    /*  217 */ SyscallDesc("unused#217", unimplementedFunc),
    /*  218 */ SyscallDesc("unused#218", unimplementedFunc),
    /*  219 */ SyscallDesc("unused#219", unimplementedFunc),
    /*  220 */ SyscallDesc("unused#220", unimplementedFunc),
    /*  221 */ SyscallDesc("unused#221", unimplementedFunc),
    /*  222 */ SyscallDesc("unused#222", unimplementedFunc),
    /*  223 */ SyscallDesc("unused#223", unimplementedFunc),
    /*  224 */ SyscallDesc("unused#224", unimplementedFunc),
    /*  225 */ SyscallDesc("unused#225", unimplementedFunc),
    /*  226 */ SyscallDesc("unused#226", unimplementedFunc),
    /*  227 */ SyscallDesc("unused#227", unimplementedFunc),
    /*  228 */ SyscallDesc("unused#228", unimplementedFunc),
    /*  229 */ SyscallDesc("unused#229", unimplementedFunc),
    /*  230 */ SyscallDesc("unused#230", unimplementedFunc),
    /*  231 */ SyscallDesc("unused#231", unimplementedFunc),
    /*  232 */ SyscallDesc("unused#232", unimplementedFunc),
    /*  233 */ SyscallDesc("unused#233", unimplementedFunc),
    /*  234 */ SyscallDesc("unused#234", unimplementedFunc),
    /*  235 */ SyscallDesc("unused#235", unimplementedFunc),
    /*  236 */ SyscallDesc("unused#236", unimplementedFunc),
    /*  237 */ SyscallDesc("unused#237", unimplementedFunc),
    /*  238 */ SyscallDesc("unused#238", unimplementedFunc),
    /*  239 */ SyscallDesc("unused#239", unimplementedFunc),
    /*  240 */ SyscallDesc("unused#240", unimplementedFunc),
    /*  241 */ SyscallDesc("unused#241", unimplementedFunc),
    /*  242 */ SyscallDesc("unused#242", unimplementedFunc),
    /*  243 */ SyscallDesc("unused#243", unimplementedFunc),
    /*  244 */ SyscallDesc("unused#244", unimplementedFunc),
    /*  245 */ SyscallDesc("unused#245", unimplementedFunc),
    /*  246 */ SyscallDesc("unused#246", unimplementedFunc),
    /*  247 */ SyscallDesc("unused#247", unimplementedFunc),
    /*  248 */ SyscallDesc("unused#248", unimplementedFunc),
    /*  249 */ SyscallDesc("unused#249", unimplementedFunc),
    /*  250 */ SyscallDesc("unused#250", unimplementedFunc),
    /*  251 */ SyscallDesc("unused#251", unimplementedFunc),
    /*  252 */ SyscallDesc("unused#252", unimplementedFunc),
    /*  253 */ SyscallDesc("unused#253", unimplementedFunc),
    /*  254 */ SyscallDesc("unused#254", unimplementedFunc),
    /*  255 */ SyscallDesc("unused#255", unimplementedFunc),
    /*  256 */ SyscallDesc("unused#256", unimplementedFunc),
    /*  257 */ SyscallDesc("unused#257", unimplementedFunc),
    /*  258 */ SyscallDesc("unused#258", unimplementedFunc),
    /*  259 */ SyscallDesc("unused#259", unimplementedFunc),
    /*  260 */ SyscallDesc("unused#260", unimplementedFunc),
    /*  261 */ SyscallDesc("unused#261", unimplementedFunc),
    /*  262 */ SyscallDesc("unused#262", unimplementedFunc),
    /*  263 */ SyscallDesc("unused#263", unimplementedFunc),
    /*  264 */ SyscallDesc("unused#264", unimplementedFunc),
    /*  265 */ SyscallDesc("unused#265", unimplementedFunc),
    /*  266 */ SyscallDesc("unused#266", unimplementedFunc),
    /*  267 */ SyscallDesc("unused#267", unimplementedFunc),
    /*  268 */ SyscallDesc("unused#268", unimplementedFunc),
    /*  269 */ SyscallDesc("unused#269", unimplementedFunc),
    /*  270 */ SyscallDesc("unused#270", unimplementedFunc),
    /*  271 */ SyscallDesc("unused#271", unimplementedFunc),
    /*  272 */ SyscallDesc("unused#272", unimplementedFunc),
    /*  273 */ SyscallDesc("unused#273", unimplementedFunc),
    /*  274 */ SyscallDesc("unused#274", unimplementedFunc),
    /*  275 */ SyscallDesc("unused#275", unimplementedFunc),
    /*  276 */ SyscallDesc("unused#276", unimplementedFunc),
    /*  277 */ SyscallDesc("unused#277", unimplementedFunc),
    /*  278 */ SyscallDesc("unused#278", unimplementedFunc),
    /*  279 */ SyscallDesc("unused#279", unimplementedFunc),
    /*  280 */ SyscallDesc("unused#280", unimplementedFunc),
    /*  281 */ SyscallDesc("unused#281", unimplementedFunc),
    /*  282 */ SyscallDesc("unused#282", unimplementedFunc),
    /*  283 */ SyscallDesc("unused#283", unimplementedFunc),
    /*  284 */ SyscallDesc("unused#284", unimplementedFunc),
    /*  285 */ SyscallDesc("unused#285", unimplementedFunc),
    /*  286 */ SyscallDesc("unused#286", unimplementedFunc),
    /*  287 */ SyscallDesc("unused#287", unimplementedFunc),
    /*  288 */ SyscallDesc("unused#288", unimplementedFunc),
    /*  289 */ SyscallDesc("unused#289", unimplementedFunc),
    /*  290 */ SyscallDesc("unused#290", unimplementedFunc),
    /*  291 */ SyscallDesc("unused#291", unimplementedFunc),
    /*  292 */ SyscallDesc("unused#292", unimplementedFunc),
    /*  293 */ SyscallDesc("unused#293", unimplementedFunc),
    /*  294 */ SyscallDesc("unused#294", unimplementedFunc),
    /*  295 */ SyscallDesc("unused#295", unimplementedFunc),
    /*  296 */ SyscallDesc("unused#296", unimplementedFunc),
    /*  297 */ SyscallDesc("unused#297", unimplementedFunc),
    /*  298 */ SyscallDesc("unused#298", unimplementedFunc),
    /*  299 */ SyscallDesc("unused#299", unimplementedFunc),
    /*  300 */ SyscallDesc("unused#300", unimplementedFunc),
    /*  301 */ SyscallDesc("unused#301", unimplementedFunc),
    /*  302 */ SyscallDesc("unused#302", unimplementedFunc),
    /*  303 */ SyscallDesc("unused#303", unimplementedFunc),
    /*  304 */ SyscallDesc("unused#304", unimplementedFunc),
    /*  305 */ SyscallDesc("unused#305", unimplementedFunc),
    /*  306 */ SyscallDesc("unused#306", unimplementedFunc),
    /*  307 */ SyscallDesc("unused#307", unimplementedFunc),
    /*  308 */ SyscallDesc("unused#308", unimplementedFunc),
    /*  309 */ SyscallDesc("unused#309", unimplementedFunc),
    /*  310 */ SyscallDesc("unused#310", unimplementedFunc),
    /*  311 */ SyscallDesc("unused#311", unimplementedFunc),
    /*  312 */ SyscallDesc("unused#312", unimplementedFunc),
    /*  313 */ SyscallDesc("unused#313", unimplementedFunc),
    /*  314 */ SyscallDesc("unused#314", unimplementedFunc),
    /*  315 */ SyscallDesc("unused#315", unimplementedFunc),
    /*  316 */ SyscallDesc("unused#316", unimplementedFunc),
    /*  317 */ SyscallDesc("unused#317", unimplementedFunc),
    /*  318 */ SyscallDesc("unused#318", unimplementedFunc),
    /*  319 */ SyscallDesc("unused#319", unimplementedFunc),
    /*  320 */ SyscallDesc("unused#320", unimplementedFunc),
    /*  321 */ SyscallDesc("unused#321", unimplementedFunc),
    /*  322 */ SyscallDesc("unused#322", unimplementedFunc),
    /*  323 */ SyscallDesc("unused#323", unimplementedFunc),
    /*  324 */ SyscallDesc("unused#324", unimplementedFunc),
    /*  325 */ SyscallDesc("unused#325", unimplementedFunc),
    /*  326 */ SyscallDesc("unused#326", unimplementedFunc),
    /*  327 */ SyscallDesc("unused#327", unimplementedFunc),
    /*  328 */ SyscallDesc("unused#328", unimplementedFunc),
    /*  329 */ SyscallDesc("unused#329", unimplementedFunc),
    /*  330 */ SyscallDesc("unused#330", unimplementedFunc),
    /*  331 */ SyscallDesc("unused#331", unimplementedFunc),
    /*  332 */ SyscallDesc("unused#332", unimplementedFunc),
    /*  333 */ SyscallDesc("unused#333", unimplementedFunc),
    /*  334 */ SyscallDesc("unused#334", unimplementedFunc),
    /*  335 */ SyscallDesc("unused#335", unimplementedFunc),
    /*  336 */ SyscallDesc("unused#336", unimplementedFunc),
    /*  337 */ SyscallDesc("unused#337", unimplementedFunc),
    /*  338 */ SyscallDesc("unused#338", unimplementedFunc),
    /*  339 */ SyscallDesc("unused#339", unimplementedFunc),
    /*  340 */ SyscallDesc("unused#340", unimplementedFunc),
    /*  341 */ SyscallDesc("unused#341", unimplementedFunc),
    /*  342 */ SyscallDesc("unused#342", unimplementedFunc),
    /*  343 */ SyscallDesc("unused#343", unimplementedFunc),
    /*  344 */ SyscallDesc("unused#344", unimplementedFunc),
    /*  345 */ SyscallDesc("unused#345", unimplementedFunc),
    /*  346 */ SyscallDesc("unused#346", unimplementedFunc),
    /*  347 */ SyscallDesc("unused#347", unimplementedFunc),
    /*  348 */ SyscallDesc("unused#348", unimplementedFunc),
    /*  349 */ SyscallDesc("unused#349", unimplementedFunc),
    /*  350 */ SyscallDesc("unused#350", unimplementedFunc),
    /*  351 */ SyscallDesc("unused#351", unimplementedFunc),
    /*  352 */ SyscallDesc("unused#352", unimplementedFunc),
    /*  353 */ SyscallDesc("unused#353", unimplementedFunc),
    /*  354 */ SyscallDesc("unused#354", unimplementedFunc),
    /*  355 */ SyscallDesc("unused#355", unimplementedFunc),
    /*  356 */ SyscallDesc("unused#356", unimplementedFunc),
    /*  357 */ SyscallDesc("unused#357", unimplementedFunc),
    /*  358 */ SyscallDesc("unused#358", unimplementedFunc),
    /*  359 */ SyscallDesc("unused#359", unimplementedFunc),
    /*  360 */ SyscallDesc("unused#360", unimplementedFunc),
    /*  361 */ SyscallDesc("unused#361", unimplementedFunc),
    /*  362 */ SyscallDesc("unused#362", unimplementedFunc),
    /*  363 */ SyscallDesc("unused#363", unimplementedFunc),
    /*  364 */ SyscallDesc("unused#364", unimplementedFunc),
    /*  365 */ SyscallDesc("unused#365", unimplementedFunc),
    /*  366 */ SyscallDesc("unused#366", unimplementedFunc),
    /*  367 */ SyscallDesc("unused#367", unimplementedFunc),
    /*  368 */ SyscallDesc("unused#368", unimplementedFunc),
    /*  369 */ SyscallDesc("unused#369", unimplementedFunc),
    /*  370 */ SyscallDesc("unused#370", unimplementedFunc),
    /*  371 */ SyscallDesc("unused#371", unimplementedFunc),
    /*  372 */ SyscallDesc("unused#372", unimplementedFunc),
    /*  373 */ SyscallDesc("unused#373", unimplementedFunc),
    /*  374 */ SyscallDesc("unused#374", unimplementedFunc),
    /*  375 */ SyscallDesc("unused#375", unimplementedFunc),
    /*  376 */ SyscallDesc("unused#376", unimplementedFunc),
    /*  377 */ SyscallDesc("unused#377", unimplementedFunc),
    /*  378 */ SyscallDesc("unused#378", unimplementedFunc),
    /*  379 */ SyscallDesc("unused#379", unimplementedFunc),
    /*  380 */ SyscallDesc("unused#380", unimplementedFunc),
    /*  381 */ SyscallDesc("unused#381", unimplementedFunc),
    /*  382 */ SyscallDesc("unused#382", unimplementedFunc),
    /*  383 */ SyscallDesc("unused#383", unimplementedFunc),
    /*  384 */ SyscallDesc("unused#384", unimplementedFunc),
    /*  385 */ SyscallDesc("unused#385", unimplementedFunc),
    /*  386 */ SyscallDesc("unused#386", unimplementedFunc),
    /*  387 */ SyscallDesc("unused#387", unimplementedFunc),
    /*  388 */ SyscallDesc("unused#388", unimplementedFunc),
    /*  389 */ SyscallDesc("unused#389", unimplementedFunc),
    /*  390 */ SyscallDesc("unused#390", unimplementedFunc),
    /*  391 */ SyscallDesc("unused#391", unimplementedFunc),
    /*  392 */ SyscallDesc("unused#392", unimplementedFunc),
    /*  393 */ SyscallDesc("unused#393", unimplementedFunc),
    /*  394 */ SyscallDesc("unused#394", unimplementedFunc),
    /*  395 */ SyscallDesc("unused#395", unimplementedFunc),
    /*  396 */ SyscallDesc("unused#396", unimplementedFunc),
    /*  397 */ SyscallDesc("unused#397", unimplementedFunc),
    /*  398 */ SyscallDesc("unused#398", unimplementedFunc),
    /*  399 */ SyscallDesc("unused#399", unimplementedFunc),
    /*  400 */ SyscallDesc("unused#400", unimplementedFunc),
    /*  401 */ SyscallDesc("unused#401", unimplementedFunc),
    /*  402 */ SyscallDesc("unused#402", unimplementedFunc),
    /*  403 */ SyscallDesc("unused#403", unimplementedFunc),
    /*  404 */ SyscallDesc("unused#404", unimplementedFunc),
    /*  405 */ SyscallDesc("unused#405", unimplementedFunc),
    /*  406 */ SyscallDesc("unused#406", unimplementedFunc),
    /*  407 */ SyscallDesc("unused#407", unimplementedFunc),
    /*  408 */ SyscallDesc("unused#408", unimplementedFunc),
    /*  409 */ SyscallDesc("unused#409", unimplementedFunc),
    /*  410 */ SyscallDesc("unused#410", unimplementedFunc),
    /*  411 */ SyscallDesc("unused#411", unimplementedFunc),
    /*  412 */ SyscallDesc("unused#412", unimplementedFunc),
    /*  413 */ SyscallDesc("unused#413", unimplementedFunc),
    /*  414 */ SyscallDesc("unused#414", unimplementedFunc),
    /*  415 */ SyscallDesc("unused#415", unimplementedFunc),
    /*  416 */ SyscallDesc("unused#416", unimplementedFunc),
    /*  417 */ SyscallDesc("unused#417", unimplementedFunc),
    /*  418 */ SyscallDesc("unused#418", unimplementedFunc),
    /*  419 */ SyscallDesc("unused#419", unimplementedFunc),
    /*  420 */ SyscallDesc("unused#420", unimplementedFunc),
    /*  421 */ SyscallDesc("unused#421", unimplementedFunc),
    /*  422 */ SyscallDesc("unused#422", unimplementedFunc),
    /*  423 */ SyscallDesc("unused#423", unimplementedFunc),
    /*  424 */ SyscallDesc("unused#424", unimplementedFunc),
    /*  425 */ SyscallDesc("unused#425", unimplementedFunc),
    /*  426 */ SyscallDesc("unused#426", unimplementedFunc),
    /*  427 */ SyscallDesc("unused#427", unimplementedFunc),
    /*  428 */ SyscallDesc("unused#428", unimplementedFunc),
    /*  429 */ SyscallDesc("unused#429", unimplementedFunc),
    /*  430 */ SyscallDesc("unused#430", unimplementedFunc),
    /*  431 */ SyscallDesc("unused#431", unimplementedFunc),
    /*  432 */ SyscallDesc("unused#432", unimplementedFunc),
    /*  433 */ SyscallDesc("unused#433", unimplementedFunc),
    /*  434 */ SyscallDesc("unused#434", unimplementedFunc),
    /*  435 */ SyscallDesc("unused#435", unimplementedFunc),
    /*  436 */ SyscallDesc("unused#436", unimplementedFunc),
    /*  437 */ SyscallDesc("unused#437", unimplementedFunc),
    /*  438 */ SyscallDesc("unused#438", unimplementedFunc),
    /*  439 */ SyscallDesc("unused#439", unimplementedFunc),
    /*  440 */ SyscallDesc("unused#440", unimplementedFunc),
    /*  441 */ SyscallDesc("unused#441", unimplementedFunc),
    /*  442 */ SyscallDesc("unused#442", unimplementedFunc),
    /*  443 */ SyscallDesc("unused#443", unimplementedFunc),
    /*  444 */ SyscallDesc("unused#444", unimplementedFunc),
    /*  445 */ SyscallDesc("unused#445", unimplementedFunc),
    /*  446 */ SyscallDesc("unused#446", unimplementedFunc),
    /*  447 */ SyscallDesc("unused#447", unimplementedFunc),
    /*  448 */ SyscallDesc("unused#448", unimplementedFunc),
    /*  449 */ SyscallDesc("unused#449", unimplementedFunc),
    /*  450 */ SyscallDesc("unused#450", unimplementedFunc),
    /*  451 */ SyscallDesc("unused#451", unimplementedFunc),
    /*  452 */ SyscallDesc("unused#452", unimplementedFunc),
    /*  453 */ SyscallDesc("unused#453", unimplementedFunc),
    /*  454 */ SyscallDesc("unused#454", unimplementedFunc),
    /*  455 */ SyscallDesc("unused#455", unimplementedFunc),
    /*  456 */ SyscallDesc("unused#456", unimplementedFunc),
    /*  457 */ SyscallDesc("unused#457", unimplementedFunc),
    /*  458 */ SyscallDesc("unused#458", unimplementedFunc),
    /*  459 */ SyscallDesc("unused#459", unimplementedFunc),
    /*  460 */ SyscallDesc("unused#460", unimplementedFunc),
    /*  461 */ SyscallDesc("unused#461", unimplementedFunc),
    /*  462 */ SyscallDesc("unused#462", unimplementedFunc),
    /*  463 */ SyscallDesc("unused#463", unimplementedFunc),
    /*  464 */ SyscallDesc("unused#464", unimplementedFunc),
    /*  465 */ SyscallDesc("unused#465", unimplementedFunc),
    /*  466 */ SyscallDesc("unused#466", unimplementedFunc),
    /*  467 */ SyscallDesc("unused#467", unimplementedFunc),
    /*  468 */ SyscallDesc("unused#468", unimplementedFunc),
    /*  469 */ SyscallDesc("unused#469", unimplementedFunc),
    /*  470 */ SyscallDesc("unused#470", unimplementedFunc),
    /*  471 */ SyscallDesc("unused#471", unimplementedFunc),
    /*  472 */ SyscallDesc("unused#472", unimplementedFunc),
    /*  473 */ SyscallDesc("unused#473", unimplementedFunc),
    /*  474 */ SyscallDesc("unused#474", unimplementedFunc),
    /*  475 */ SyscallDesc("unused#475", unimplementedFunc),
    /*  476 */ SyscallDesc("unused#476", unimplementedFunc),
    /*  477 */ SyscallDesc("unused#477", unimplementedFunc),
    /*  478 */ SyscallDesc("unused#478", unimplementedFunc),
    /*  479 */ SyscallDesc("unused#479", unimplementedFunc),
    /*  480 */ SyscallDesc("unused#480", unimplementedFunc),
    /*  481 */ SyscallDesc("unused#481", unimplementedFunc),
    /*  482 */ SyscallDesc("unused#482", unimplementedFunc),
    /*  483 */ SyscallDesc("unused#483", unimplementedFunc),
    /*  484 */ SyscallDesc("unused#484", unimplementedFunc),
    /*  485 */ SyscallDesc("unused#485", unimplementedFunc),
    /*  486 */ SyscallDesc("unused#486", unimplementedFunc),
    /*  487 */ SyscallDesc("unused#487", unimplementedFunc),
    /*  488 */ SyscallDesc("unused#488", unimplementedFunc),
    /*  489 */ SyscallDesc("unused#489", unimplementedFunc),
    /*  490 */ SyscallDesc("unused#490", unimplementedFunc),
    /*  491 */ SyscallDesc("unused#491", unimplementedFunc),
    /*  492 */ SyscallDesc("unused#492", unimplementedFunc),
    /*  493 */ SyscallDesc("unused#493", unimplementedFunc),
    /*  494 */ SyscallDesc("unused#494", unimplementedFunc),
    /*  495 */ SyscallDesc("unused#495", unimplementedFunc),
    /*  496 */ SyscallDesc("unused#496", unimplementedFunc),
    /*  497 */ SyscallDesc("unused#497", unimplementedFunc),
    /*  498 */ SyscallDesc("unused#498", unimplementedFunc),
    /*  499 */ SyscallDesc("unused#499", unimplementedFunc),
    /*  500 */ SyscallDesc("unused#500", unimplementedFunc),
    /*  501 */ SyscallDesc("unused#501", unimplementedFunc),
    /*  502 */ SyscallDesc("unused#502", unimplementedFunc),
    /*  503 */ SyscallDesc("unused#503", unimplementedFunc),
    /*  504 */ SyscallDesc("unused#504", unimplementedFunc),
    /*  505 */ SyscallDesc("unused#505", unimplementedFunc),
    /*  506 */ SyscallDesc("unused#506", unimplementedFunc),
    /*  507 */ SyscallDesc("unused#507", unimplementedFunc),
    /*  508 */ SyscallDesc("unused#508", unimplementedFunc),
    /*  509 */ SyscallDesc("unused#509", unimplementedFunc),
    /*  510 */ SyscallDesc("unused#510", unimplementedFunc),
    /*  511 */ SyscallDesc("unused#511", unimplementedFunc),
    /*  512 */ SyscallDesc("unused#512", unimplementedFunc),
    /*  513 */ SyscallDesc("unused#513", unimplementedFunc),
    /*  514 */ SyscallDesc("unused#514", unimplementedFunc),
    /*  515 */ SyscallDesc("unused#515", unimplementedFunc),
    /*  516 */ SyscallDesc("unused#516", unimplementedFunc),
    /*  517 */ SyscallDesc("unused#517", unimplementedFunc),
    /*  518 */ SyscallDesc("unused#518", unimplementedFunc),
    /*  519 */ SyscallDesc("unused#519", unimplementedFunc),
    /*  520 */ SyscallDesc("unused#520", unimplementedFunc),
    /*  521 */ SyscallDesc("unused#521", unimplementedFunc),
    /*  522 */ SyscallDesc("unused#522", unimplementedFunc),
    /*  523 */ SyscallDesc("unused#523", unimplementedFunc),
    /*  524 */ SyscallDesc("unused#524", unimplementedFunc),
    /*  525 */ SyscallDesc("unused#525", unimplementedFunc),
    /*  526 */ SyscallDesc("unused#526", unimplementedFunc),
    /*  527 */ SyscallDesc("unused#527", unimplementedFunc),
    /*  528 */ SyscallDesc("unused#528", unimplementedFunc),
    /*  529 */ SyscallDesc("unused#529", unimplementedFunc),
    /*  530 */ SyscallDesc("unused#530", unimplementedFunc),
    /*  531 */ SyscallDesc("unused#531", unimplementedFunc),
    /*  532 */ SyscallDesc("unused#532", unimplementedFunc),
    /*  533 */ SyscallDesc("unused#533", unimplementedFunc),
    /*  534 */ SyscallDesc("unused#534", unimplementedFunc),
    /*  535 */ SyscallDesc("unused#535", unimplementedFunc),
    /*  536 */ SyscallDesc("unused#536", unimplementedFunc),
    /*  537 */ SyscallDesc("unused#537", unimplementedFunc),
    /*  538 */ SyscallDesc("unused#538", unimplementedFunc),
    /*  539 */ SyscallDesc("unused#539", unimplementedFunc),
    /*  540 */ SyscallDesc("unused#540", unimplementedFunc),
    /*  541 */ SyscallDesc("unused#541", unimplementedFunc),
    /*  542 */ SyscallDesc("unused#542", unimplementedFunc),
    /*  543 */ SyscallDesc("unused#543", unimplementedFunc),
    /*  544 */ SyscallDesc("unused#544", unimplementedFunc),
    /*  545 */ SyscallDesc("unused#545", unimplementedFunc),
    /*  546 */ SyscallDesc("unused#546", unimplementedFunc),
    /*  547 */ SyscallDesc("unused#547", unimplementedFunc),
};

static SyscallDesc syscallDescs64[] = {
    /*    0 */ SyscallDesc("unused#000", unimplementedFunc),
    /*    1 */ SyscallDesc("exit", exitFunc),
    /*    2 */ SyscallDesc("unused#002", unimplementedFunc),
    /*    3 */ SyscallDesc("read", readFunc),
    /*    4 */ SyscallDesc("write", writeFunc),
    /*    5 */ SyscallDesc("unused#005", unimplementedFunc),
    /*    6 */ SyscallDesc("unused#006", unimplementedFunc),
    /*    7 */ SyscallDesc("unused#007", unimplementedFunc),
    /*    8 */ SyscallDesc("unused#008", unimplementedFunc),
    /*    9 */ SyscallDesc("unused#009", unimplementedFunc),
    /*   10 */ SyscallDesc("unused#010", unimplementedFunc),
    /*   11 */ SyscallDesc("unused#011", unimplementedFunc),
    /*   12 */ SyscallDesc("unused#012", unimplementedFunc),
    /*   13 */ SyscallDesc("unused#013", unimplementedFunc),
    /*   14 */ SyscallDesc("unused#014", unimplementedFunc),
    /*   15 */ SyscallDesc("unused#015", unimplementedFunc),
    /*   16 */ SyscallDesc("unused#016", unimplementedFunc),
    /*   17 */ SyscallDesc("obreak", brkFunc),
    /*   18 */ SyscallDesc("unused#018", unimplementedFunc),
    /*   19 */ SyscallDesc("unused#019", unimplementedFunc),
    /*   20 */ SyscallDesc("unused#020", unimplementedFunc),
    /*   21 */ SyscallDesc("unused#021", unimplementedFunc),
    /*   22 */ SyscallDesc("unused#022", unimplementedFunc),
    /*   23 */ SyscallDesc("unused#023", unimplementedFunc),
    /*   24 */ SyscallDesc("unused#024", unimplementedFunc),
    /*   25 */ SyscallDesc("unused#025", unimplementedFunc),
    /*   26 */ SyscallDesc("unused#026", unimplementedFunc),
    /*   27 */ SyscallDesc("unused#027", unimplementedFunc),
    /*   28 */ SyscallDesc("unused#028", unimplementedFunc),
    /*   29 */ SyscallDesc("unused#029", unimplementedFunc),
    /*   30 */ SyscallDesc("unused#030", unimplementedFunc),
    /*   31 */ SyscallDesc("unused#031", unimplementedFunc),
    /*   32 */ SyscallDesc("unused#032", unimplementedFunc),
    /*   33 */ SyscallDesc("unused#033", unimplementedFunc),
    /*   34 */ SyscallDesc("unused#034", unimplementedFunc),
    /*   35 */ SyscallDesc("unused#035", unimplementedFunc),
    /*   36 */ SyscallDesc("unused#036", unimplementedFunc),
    /*   37 */ SyscallDesc("unused#037", unimplementedFunc),
    /*   38 */ SyscallDesc("unused#038", unimplementedFunc),
    /*   39 */ SyscallDesc("unused#039", unimplementedFunc),
    /*   40 */ SyscallDesc("unused#040", unimplementedFunc),
    /*   41 */ SyscallDesc("unused#041", unimplementedFunc),
    /*   42 */ SyscallDesc("unused#042", unimplementedFunc),
    /*   43 */ SyscallDesc("unused#043", unimplementedFunc),
    /*   44 */ SyscallDesc("unused#044", unimplementedFunc),
    /*   45 */ SyscallDesc("unused#045", unimplementedFunc),
    /*   46 */ SyscallDesc("unused#046", unimplementedFunc),
    /*   47 */ SyscallDesc("unused#047", unimplementedFunc),
    /*   48 */ SyscallDesc("unused#048", unimplementedFunc),
    /*   49 */ SyscallDesc("unused#049", unimplementedFunc),
    /*   50 */ SyscallDesc("unused#050", unimplementedFunc),
    /*   51 */ SyscallDesc("unused#051", unimplementedFunc),
    /*   52 */ SyscallDesc("unused#052", unimplementedFunc),
    /*   53 */ SyscallDesc("unused#053", unimplementedFunc),
    /*   54 */ SyscallDesc("ioctl", ioctlFunc<ArmFreebsd64>),
    /*   55 */ SyscallDesc("unused#055", unimplementedFunc),
    /*   56 */ SyscallDesc("unused#056", unimplementedFunc),
    /*   57 */ SyscallDesc("unused#057", unimplementedFunc),
    /*   58 */ SyscallDesc("readlink", readlinkFunc),
    /*   59 */ SyscallDesc("unused#059", unimplementedFunc),
    /*   60 */ SyscallDesc("unused#060", unimplementedFunc),
    /*   61 */ SyscallDesc("unused#061", unimplementedFunc),
    /*   62 */ SyscallDesc("unused#062", unimplementedFunc),
    /*   63 */ SyscallDesc("unused#063", unimplementedFunc),
    /*   64 */ SyscallDesc("unused#064", unimplementedFunc),
    /*   65 */ SyscallDesc("unused#065", unimplementedFunc),
    /*   66 */ SyscallDesc("unused#066", unimplementedFunc),
    /*   67 */ SyscallDesc("unused#067", unimplementedFunc),
    /*   68 */ SyscallDesc("unused#068", unimplementedFunc),
    /*   69 */ SyscallDesc("unused#069", unimplementedFunc),
    /*   70 */ SyscallDesc("unused#070", unimplementedFunc),
    /*   71 */ SyscallDesc("unused#071", unimplementedFunc),
    /*   72 */ SyscallDesc("unused#072", unimplementedFunc),
    /*   73 */ SyscallDesc("unused#073", unimplementedFunc),
    /*   74 */ SyscallDesc("unused#074", unimplementedFunc),
    /*   75 */ SyscallDesc("unused#075", unimplementedFunc),
    /*   76 */ SyscallDesc("unused#076", unimplementedFunc),
    /*   77 */ SyscallDesc("unused#077", unimplementedFunc),
    /*   78 */ SyscallDesc("unused#078", unimplementedFunc),
    /*   79 */ SyscallDesc("unused#079", unimplementedFunc),
    /*   80 */ SyscallDesc("unused#080", unimplementedFunc),
    /*   81 */ SyscallDesc("unused#081", unimplementedFunc),
    /*   82 */ SyscallDesc("unused#082", unimplementedFunc),
    /*   83 */ SyscallDesc("unused#083", unimplementedFunc),
    /*   84 */ SyscallDesc("unused#084", unimplementedFunc),
    /*   85 */ SyscallDesc("unused#085", unimplementedFunc),
    /*   86 */ SyscallDesc("unused#086", unimplementedFunc),
    /*   87 */ SyscallDesc("unused#087", unimplementedFunc),
    /*   88 */ SyscallDesc("unused#088", unimplementedFunc),
    /*   89 */ SyscallDesc("unused#089", unimplementedFunc),
    /*   90 */ SyscallDesc("unused#090", unimplementedFunc),
    /*   91 */ SyscallDesc("unused#091", unimplementedFunc),
    /*   92 */ SyscallDesc("unused#092", unimplementedFunc),
    /*   93 */ SyscallDesc("unused#093", unimplementedFunc),
    /*   94 */ SyscallDesc("unused#094", unimplementedFunc),
    /*   95 */ SyscallDesc("unused#095", unimplementedFunc),
    /*   96 */ SyscallDesc("unused#096", unimplementedFunc),
    /*   97 */ SyscallDesc("unused#097", unimplementedFunc),
    /*   98 */ SyscallDesc("unused#098", unimplementedFunc),
    /*   99 */ SyscallDesc("unused#099", unimplementedFunc),
    /*  100 */ SyscallDesc("unused#100", unimplementedFunc),
    /*  101 */ SyscallDesc("unused#101", unimplementedFunc),
    /*  102 */ SyscallDesc("unused#102", unimplementedFunc),
    /*  103 */ SyscallDesc("unused#103", unimplementedFunc),
    /*  104 */ SyscallDesc("unused#104", unimplementedFunc),
    /*  105 */ SyscallDesc("unused#105", unimplementedFunc),
    /*  106 */ SyscallDesc("unused#106", unimplementedFunc),
    /*  107 */ SyscallDesc("unused#107", unimplementedFunc),
    /*  108 */ SyscallDesc("unused#108", unimplementedFunc),
    /*  109 */ SyscallDesc("unused#109", unimplementedFunc),
    /*  110 */ SyscallDesc("unused#110", unimplementedFunc),
    /*  111 */ SyscallDesc("unused#111", unimplementedFunc),
    /*  112 */ SyscallDesc("unused#112", unimplementedFunc),
    /*  113 */ SyscallDesc("unused#113", unimplementedFunc),
    /*  114 */ SyscallDesc("unused#114", unimplementedFunc),
    /*  115 */ SyscallDesc("unused#115", unimplementedFunc),
    /*  116 */ SyscallDesc("unused#116", unimplementedFunc),
    /*  117 */ SyscallDesc("getrusage", getrusageFunc<ArmFreebsd64>),
    /*  118 */ SyscallDesc("unused#118", unimplementedFunc),
    /*  119 */ SyscallDesc("unused#119", unimplementedFunc),
    /*  120 */ SyscallDesc("unused#120", unimplementedFunc),
    /*  121 */ SyscallDesc("unused#121", unimplementedFunc),
    /*  122 */ SyscallDesc("unused#122", unimplementedFunc),
    /*  123 */ SyscallDesc("unused#123", unimplementedFunc),
    /*  124 */ SyscallDesc("unused#124", unimplementedFunc),
    /*  125 */ SyscallDesc("unused#125", unimplementedFunc),
    /*  126 */ SyscallDesc("unused#126", unimplementedFunc),
    /*  127 */ SyscallDesc("unused#127", unimplementedFunc),
    /*  128 */ SyscallDesc("unused#128", unimplementedFunc),
    /*  129 */ SyscallDesc("unused#129", unimplementedFunc),
    /*  130 */ SyscallDesc("unused#130", unimplementedFunc),
    /*  131 */ SyscallDesc("unused#131", unimplementedFunc),
    /*  132 */ SyscallDesc("unused#132", unimplementedFunc),
    /*  133 */ SyscallDesc("unused#133", unimplementedFunc),
    /*  134 */ SyscallDesc("unused#134", unimplementedFunc),
    /*  135 */ SyscallDesc("unused#135", unimplementedFunc),
    /*  136 */ SyscallDesc("unused#136", unimplementedFunc),
    /*  137 */ SyscallDesc("unused#137", unimplementedFunc),
    /*  138 */ SyscallDesc("unused#138", unimplementedFunc),
    /*  139 */ SyscallDesc("unused#139", unimplementedFunc),
    /*  140 */ SyscallDesc("unused#140", unimplementedFunc),
    /*  141 */ SyscallDesc("unused#141", unimplementedFunc),
    /*  142 */ SyscallDesc("unused#142", unimplementedFunc),
    /*  143 */ SyscallDesc("unused#143", unimplementedFunc),
    /*  144 */ SyscallDesc("unused#144", unimplementedFunc),
    /*  145 */ SyscallDesc("unused#145", unimplementedFunc),
    /*  146 */ SyscallDesc("unused#146", unimplementedFunc),
    /*  147 */ SyscallDesc("unused#147", unimplementedFunc),
    /*  148 */ SyscallDesc("unused#148", unimplementedFunc),
    /*  149 */ SyscallDesc("unused#149", unimplementedFunc),
    /*  150 */ SyscallDesc("unused#150", unimplementedFunc),
    /*  151 */ SyscallDesc("unused#151", unimplementedFunc),
    /*  152 */ SyscallDesc("unused#152", unimplementedFunc),
    /*  153 */ SyscallDesc("unused#153", unimplementedFunc),
    /*  154 */ SyscallDesc("unused#154", unimplementedFunc),
    /*  155 */ SyscallDesc("unused#155", unimplementedFunc),
    /*  156 */ SyscallDesc("unused#156", unimplementedFunc),
    /*  157 */ SyscallDesc("unused#157", unimplementedFunc),
    /*  158 */ SyscallDesc("unused#158", unimplementedFunc),
    /*  159 */ SyscallDesc("unused#159", unimplementedFunc),
    /*  160 */ SyscallDesc("unused#160", unimplementedFunc),
    /*  161 */ SyscallDesc("unused#161", unimplementedFunc),
    /*  162 */ SyscallDesc("unused#162", unimplementedFunc),
    /*  163 */ SyscallDesc("unused#163", unimplementedFunc),
    /*  164 */ SyscallDesc("unused#164", unimplementedFunc),
    /*  165 */ SyscallDesc("unused#165", unimplementedFunc),
    /*  166 */ SyscallDesc("unused#166", unimplementedFunc),
    /*  167 */ SyscallDesc("unused#167", unimplementedFunc),
    /*  168 */ SyscallDesc("unused#168", unimplementedFunc),
    /*  169 */ SyscallDesc("unused#169", unimplementedFunc),
    /*  170 */ SyscallDesc("unused#170", unimplementedFunc),
    /*  171 */ SyscallDesc("unused#171", unimplementedFunc),
    /*  172 */ SyscallDesc("unused#172", unimplementedFunc),
    /*  173 */ SyscallDesc("unused#173", unimplementedFunc),
    /*  174 */ SyscallDesc("unused#174", unimplementedFunc),
    /*  175 */ SyscallDesc("unused#175", unimplementedFunc),
    /*  176 */ SyscallDesc("unused#176", unimplementedFunc),
    /*  177 */ SyscallDesc("unused#177", unimplementedFunc),
    /*  178 */ SyscallDesc("unused#178", unimplementedFunc),
    /*  179 */ SyscallDesc("unused#179", unimplementedFunc),
    /*  180 */ SyscallDesc("unused#180", unimplementedFunc),
    /*  181 */ SyscallDesc("unused#181", unimplementedFunc),
    /*  182 */ SyscallDesc("unused#182", unimplementedFunc),
    /*  183 */ SyscallDesc("unused#183", unimplementedFunc),
    /*  184 */ SyscallDesc("unused#184", unimplementedFunc),
    /*  185 */ SyscallDesc("unused#185", unimplementedFunc),
    /*  186 */ SyscallDesc("unused#186", unimplementedFunc),
    /*  187 */ SyscallDesc("unused#187", unimplementedFunc),
    /*  188 */ SyscallDesc("unused#188", unimplementedFunc),
    /*  189 */ SyscallDesc("fstat", fstatFunc<ArmFreebsd64>),
    /*  190 */ SyscallDesc("unused#190", unimplementedFunc),
    /*  191 */ SyscallDesc("unused#191", unimplementedFunc),
    /*  192 */ SyscallDesc("unused#192", unimplementedFunc),
    /*  193 */ SyscallDesc("unused#193", unimplementedFunc),
    /*  194 */ SyscallDesc("unused#194", unimplementedFunc),
    /*  195 */ SyscallDesc("unused#195", unimplementedFunc),
    /*  196 */ SyscallDesc("unused#196", unimplementedFunc),
    /*  197 */ SyscallDesc("unused#197", unimplementedFunc),
    /*  198 */ SyscallDesc("unused#198", unimplementedFunc),
    /*  199 */ SyscallDesc("unused#199", unimplementedFunc),
    /*  200 */ SyscallDesc("unused#200", unimplementedFunc),
    /*  201 */ SyscallDesc("unused#201", unimplementedFunc),
    /*  202 */ SyscallDesc("sysctl", sysctlFunc),
    /*  203 */ SyscallDesc("unused#203", unimplementedFunc),
    /*  204 */ SyscallDesc("unused#204", unimplementedFunc),
    /*  205 */ SyscallDesc("unused#205", unimplementedFunc),
    /*  206 */ SyscallDesc("unused#206", unimplementedFunc),
    /*  207 */ SyscallDesc("unused#207", unimplementedFunc),
    /*  208 */ SyscallDesc("unused#208", unimplementedFunc),
    /*  209 */ SyscallDesc("unused#209", unimplementedFunc),
    /*  210 */ SyscallDesc("unused#210", unimplementedFunc),
    /*  211 */ SyscallDesc("unused#211", unimplementedFunc),
    /*  212 */ SyscallDesc("unused#212", unimplementedFunc),
    /*  213 */ SyscallDesc("unused#213", unimplementedFunc),
    /*  214 */ SyscallDesc("unused#214", unimplementedFunc),
    /*  215 */ SyscallDesc("unused#215", unimplementedFunc),
    /*  216 */ SyscallDesc("unused#216", unimplementedFunc),
    /*  217 */ SyscallDesc("unused#217", unimplementedFunc),
    /*  218 */ SyscallDesc("unused#218", unimplementedFunc),
    /*  219 */ SyscallDesc("unused#219", unimplementedFunc),
    /*  220 */ SyscallDesc("unused#220", unimplementedFunc),
    /*  221 */ SyscallDesc("unused#221", unimplementedFunc),
    /*  222 */ SyscallDesc("unused#222", unimplementedFunc),
    /*  223 */ SyscallDesc("unused#223", unimplementedFunc),
    /*  224 */ SyscallDesc("unused#224", unimplementedFunc),
    /*  225 */ SyscallDesc("unused#225", unimplementedFunc),
    /*  226 */ SyscallDesc("unused#226", unimplementedFunc),
    /*  227 */ SyscallDesc("unused#227", unimplementedFunc),
    /*  228 */ SyscallDesc("unused#228", unimplementedFunc),
    /*  229 */ SyscallDesc("unused#229", unimplementedFunc),
    /*  230 */ SyscallDesc("unused#230", unimplementedFunc),
    /*  231 */ SyscallDesc("unused#231", unimplementedFunc),
    /*  232 */ SyscallDesc("unused#232", unimplementedFunc),
    /*  233 */ SyscallDesc("unused#233", unimplementedFunc),
    /*  234 */ SyscallDesc("unused#234", unimplementedFunc),
    /*  235 */ SyscallDesc("unused#235", unimplementedFunc),
    /*  236 */ SyscallDesc("unused#236", unimplementedFunc),
    /*  237 */ SyscallDesc("unused#237", unimplementedFunc),
    /*  238 */ SyscallDesc("unused#238", unimplementedFunc),
    /*  239 */ SyscallDesc("unused#239", unimplementedFunc),
    /*  240 */ SyscallDesc("unused#240", unimplementedFunc),
    /*  241 */ SyscallDesc("unused#241", unimplementedFunc),
    /*  242 */ SyscallDesc("unused#242", unimplementedFunc),
    /*  243 */ SyscallDesc("unused#243", unimplementedFunc),
    /*  244 */ SyscallDesc("unused#244", unimplementedFunc),
    /*  245 */ SyscallDesc("unused#245", unimplementedFunc),
    /*  246 */ SyscallDesc("unused#246", unimplementedFunc),
    /*  247 */ SyscallDesc("unused#247", unimplementedFunc),
    /*  248 */ SyscallDesc("unused#248", unimplementedFunc),
    /*  249 */ SyscallDesc("unused#249", unimplementedFunc),
    /*  250 */ SyscallDesc("unused#250", unimplementedFunc),
    /*  251 */ SyscallDesc("unused#251", unimplementedFunc),
    /*  252 */ SyscallDesc("unused#252", unimplementedFunc),
    /*  253 */ SyscallDesc("issetugid", issetugidFunc),
    /*  254 */ SyscallDesc("unused#254", unimplementedFunc),
    /*  255 */ SyscallDesc("unused#255", unimplementedFunc),
    /*  256 */ SyscallDesc("unused#256", unimplementedFunc),
    /*  257 */ SyscallDesc("unused#257", unimplementedFunc),
    /*  258 */ SyscallDesc("unused#258", unimplementedFunc),
    /*  259 */ SyscallDesc("unused#259", unimplementedFunc),
    /*  260 */ SyscallDesc("unused#260", unimplementedFunc),
    /*  261 */ SyscallDesc("unused#261", unimplementedFunc),
    /*  262 */ SyscallDesc("unused#262", unimplementedFunc),
    /*  263 */ SyscallDesc("unused#263", unimplementedFunc),
    /*  264 */ SyscallDesc("unused#264", unimplementedFunc),
    /*  265 */ SyscallDesc("unused#265", unimplementedFunc),
    /*  266 */ SyscallDesc("unused#266", unimplementedFunc),
    /*  267 */ SyscallDesc("unused#267", unimplementedFunc),
    /*  268 */ SyscallDesc("unused#268", unimplementedFunc),
    /*  269 */ SyscallDesc("unused#269", unimplementedFunc),
    /*  270 */ SyscallDesc("unused#270", unimplementedFunc),
    /*  271 */ SyscallDesc("unused#271", unimplementedFunc),
    /*  272 */ SyscallDesc("unused#272", unimplementedFunc),
    /*  273 */ SyscallDesc("unused#273", unimplementedFunc),
    /*  274 */ SyscallDesc("unused#274", unimplementedFunc),
    /*  275 */ SyscallDesc("unused#275", unimplementedFunc),
    /*  276 */ SyscallDesc("unused#276", unimplementedFunc),
    /*  277 */ SyscallDesc("unused#277", unimplementedFunc),
    /*  278 */ SyscallDesc("unused#278", unimplementedFunc),
    /*  279 */ SyscallDesc("unused#279", unimplementedFunc),
    /*  280 */ SyscallDesc("unused#280", unimplementedFunc),
    /*  281 */ SyscallDesc("unused#281", unimplementedFunc),
    /*  282 */ SyscallDesc("unused#282", unimplementedFunc),
    /*  283 */ SyscallDesc("unused#283", unimplementedFunc),
    /*  284 */ SyscallDesc("unused#284", unimplementedFunc),
    /*  285 */ SyscallDesc("unused#285", unimplementedFunc),
    /*  286 */ SyscallDesc("unused#286", unimplementedFunc),
    /*  287 */ SyscallDesc("unused#287", unimplementedFunc),
    /*  288 */ SyscallDesc("unused#288", unimplementedFunc),
    /*  289 */ SyscallDesc("unused#289", unimplementedFunc),
    /*  290 */ SyscallDesc("unused#290", unimplementedFunc),
    /*  291 */ SyscallDesc("unused#291", unimplementedFunc),
    /*  292 */ SyscallDesc("unused#292", unimplementedFunc),
    /*  293 */ SyscallDesc("unused#293", unimplementedFunc),
    /*  294 */ SyscallDesc("unused#294", unimplementedFunc),
    /*  295 */ SyscallDesc("unused#295", unimplementedFunc),
    /*  296 */ SyscallDesc("unused#296", unimplementedFunc),
    /*  297 */ SyscallDesc("unused#297", unimplementedFunc),
    /*  298 */ SyscallDesc("unused#298", unimplementedFunc),
    /*  299 */ SyscallDesc("unused#299", unimplementedFunc),
    /*  300 */ SyscallDesc("unused#300", unimplementedFunc),
    /*  301 */ SyscallDesc("unused#301", unimplementedFunc),
    /*  302 */ SyscallDesc("unused#302", unimplementedFunc),
    /*  303 */ SyscallDesc("unused#303", unimplementedFunc),
    /*  304 */ SyscallDesc("unused#304", unimplementedFunc),
    /*  305 */ SyscallDesc("unused#305", unimplementedFunc),
    /*  306 */ SyscallDesc("unused#306", unimplementedFunc),
    /*  307 */ SyscallDesc("unused#307", unimplementedFunc),
    /*  308 */ SyscallDesc("unused#308", unimplementedFunc),
    /*  309 */ SyscallDesc("unused#309", unimplementedFunc),
    /*  310 */ SyscallDesc("unused#310", unimplementedFunc),
    /*  311 */ SyscallDesc("unused#311", unimplementedFunc),
    /*  312 */ SyscallDesc("unused#312", unimplementedFunc),
    /*  313 */ SyscallDesc("unused#313", unimplementedFunc),
    /*  314 */ SyscallDesc("unused#314", unimplementedFunc),
    /*  315 */ SyscallDesc("unused#315", unimplementedFunc),
    /*  316 */ SyscallDesc("unused#316", unimplementedFunc),
    /*  317 */ SyscallDesc("unused#317", unimplementedFunc),
    /*  318 */ SyscallDesc("unused#318", unimplementedFunc),
    /*  319 */ SyscallDesc("unused#319", unimplementedFunc),
    /*  320 */ SyscallDesc("unused#320", unimplementedFunc),
    /*  321 */ SyscallDesc("unused#321", unimplementedFunc),
    /*  322 */ SyscallDesc("unused#322", unimplementedFunc),
    /*  323 */ SyscallDesc("unused#323", unimplementedFunc),
    /*  324 */ SyscallDesc("unused#324", unimplementedFunc),
    /*  325 */ SyscallDesc("unused#325", unimplementedFunc),
    /*  326 */ SyscallDesc("unused#326", unimplementedFunc),
    /*  327 */ SyscallDesc("unused#327", unimplementedFunc),
    /*  328 */ SyscallDesc("unused#328", unimplementedFunc),
    /*  329 */ SyscallDesc("unused#329", unimplementedFunc),
    /*  330 */ SyscallDesc("unused#330", unimplementedFunc),
    /*  331 */ SyscallDesc("unused#331", unimplementedFunc),
    /*  332 */ SyscallDesc("unused#332", unimplementedFunc),
    /*  333 */ SyscallDesc("unused#333", unimplementedFunc),
    /*  334 */ SyscallDesc("unused#334", unimplementedFunc),
    /*  335 */ SyscallDesc("unused#335", unimplementedFunc),
    /*  336 */ SyscallDesc("unused#336", unimplementedFunc),
    /*  337 */ SyscallDesc("unused#337", unimplementedFunc),
    /*  338 */ SyscallDesc("unused#338", unimplementedFunc),
    /*  339 */ SyscallDesc("unused#339", unimplementedFunc),
    /*  340 */ SyscallDesc("unused#340", unimplementedFunc),
    /*  341 */ SyscallDesc("unused#341", unimplementedFunc),
    /*  342 */ SyscallDesc("unused#342", unimplementedFunc),
    /*  343 */ SyscallDesc("unused#343", unimplementedFunc),
    /*  344 */ SyscallDesc("unused#344", unimplementedFunc),
    /*  345 */ SyscallDesc("unused#345", unimplementedFunc),
    /*  346 */ SyscallDesc("unused#346", unimplementedFunc),
    /*  347 */ SyscallDesc("unused#347", unimplementedFunc),
    /*  348 */ SyscallDesc("unused#348", unimplementedFunc),
    /*  349 */ SyscallDesc("unused#349", unimplementedFunc),
    /*  350 */ SyscallDesc("unused#350", unimplementedFunc),
    /*  351 */ SyscallDesc("unused#351", unimplementedFunc),
    /*  352 */ SyscallDesc("unused#352", unimplementedFunc),
    /*  353 */ SyscallDesc("unused#353", unimplementedFunc),
    /*  354 */ SyscallDesc("unused#354", unimplementedFunc),
    /*  355 */ SyscallDesc("unused#355", unimplementedFunc),
    /*  356 */ SyscallDesc("unused#356", unimplementedFunc),
    /*  357 */ SyscallDesc("unused#357", unimplementedFunc),
    /*  358 */ SyscallDesc("unused#358", unimplementedFunc),
    /*  359 */ SyscallDesc("unused#359", unimplementedFunc),
    /*  360 */ SyscallDesc("unused#360", unimplementedFunc),
    /*  361 */ SyscallDesc("unused#361", unimplementedFunc),
    /*  362 */ SyscallDesc("unused#362", unimplementedFunc),
    /*  363 */ SyscallDesc("unused#363", unimplementedFunc),
    /*  364 */ SyscallDesc("unused#364", unimplementedFunc),
    /*  365 */ SyscallDesc("unused#365", unimplementedFunc),
    /*  366 */ SyscallDesc("unused#366", unimplementedFunc),
    /*  367 */ SyscallDesc("unused#367", unimplementedFunc),
    /*  368 */ SyscallDesc("unused#368", unimplementedFunc),
    /*  369 */ SyscallDesc("unused#369", unimplementedFunc),
    /*  370 */ SyscallDesc("unused#370", unimplementedFunc),
    /*  371 */ SyscallDesc("unused#371", unimplementedFunc),
    /*  372 */ SyscallDesc("unused#372", unimplementedFunc),
    /*  373 */ SyscallDesc("unused#373", unimplementedFunc),
    /*  374 */ SyscallDesc("unused#374", unimplementedFunc),
    /*  375 */ SyscallDesc("unused#375", unimplementedFunc),
    /*  376 */ SyscallDesc("unused#376", unimplementedFunc),
    /*  377 */ SyscallDesc("unused#377", unimplementedFunc),
    /*  378 */ SyscallDesc("unused#378", unimplementedFunc),
    /*  379 */ SyscallDesc("unused#379", unimplementedFunc),
    /*  380 */ SyscallDesc("unused#380", unimplementedFunc),
    /*  381 */ SyscallDesc("unused#381", unimplementedFunc),
    /*  382 */ SyscallDesc("unused#382", unimplementedFunc),
    /*  383 */ SyscallDesc("unused#383", unimplementedFunc),
    /*  384 */ SyscallDesc("unused#384", unimplementedFunc),
    /*  385 */ SyscallDesc("unused#385", unimplementedFunc),
    /*  386 */ SyscallDesc("unused#386", unimplementedFunc),
    /*  387 */ SyscallDesc("unused#387", unimplementedFunc),
    /*  388 */ SyscallDesc("unused#388", unimplementedFunc),
    /*  389 */ SyscallDesc("unused#389", unimplementedFunc),
    /*  390 */ SyscallDesc("unused#390", unimplementedFunc),
    /*  391 */ SyscallDesc("unused#391", unimplementedFunc),
    /*  392 */ SyscallDesc("unused#392", unimplementedFunc),
    /*  393 */ SyscallDesc("unused#393", unimplementedFunc),
    /*  394 */ SyscallDesc("unused#394", unimplementedFunc),
    /*  395 */ SyscallDesc("unused#395", unimplementedFunc),
    /*  396 */ SyscallDesc("unused#396", unimplementedFunc),
    /*  397 */ SyscallDesc("unused#397", unimplementedFunc),
    /*  398 */ SyscallDesc("unused#398", unimplementedFunc),
    /*  399 */ SyscallDesc("unused#399", unimplementedFunc),
    /*  400 */ SyscallDesc("unused#400", unimplementedFunc),
    /*  401 */ SyscallDesc("unused#401", unimplementedFunc),
    /*  402 */ SyscallDesc("unused#402", unimplementedFunc),
    /*  403 */ SyscallDesc("unused#403", unimplementedFunc),
    /*  404 */ SyscallDesc("unused#404", unimplementedFunc),
    /*  405 */ SyscallDesc("unused#405", unimplementedFunc),
    /*  406 */ SyscallDesc("unused#406", unimplementedFunc),
    /*  407 */ SyscallDesc("unused#407", unimplementedFunc),
    /*  408 */ SyscallDesc("unused#408", unimplementedFunc),
    /*  409 */ SyscallDesc("unused#409", unimplementedFunc),
    /*  410 */ SyscallDesc("unused#410", unimplementedFunc),
    /*  411 */ SyscallDesc("unused#411", unimplementedFunc),
    /*  412 */ SyscallDesc("unused#412", unimplementedFunc),
    /*  413 */ SyscallDesc("unused#413", unimplementedFunc),
    /*  414 */ SyscallDesc("unused#414", unimplementedFunc),
    /*  415 */ SyscallDesc("unused#415", unimplementedFunc),
    /*  416 */ SyscallDesc("unused#416", unimplementedFunc),
    /*  417 */ SyscallDesc("unused#417", unimplementedFunc),
    /*  418 */ SyscallDesc("unused#418", unimplementedFunc),
    /*  419 */ SyscallDesc("unused#419", unimplementedFunc),
    /*  420 */ SyscallDesc("unused#420", unimplementedFunc),
    /*  421 */ SyscallDesc("unused#421", unimplementedFunc),
    /*  422 */ SyscallDesc("unused#422", unimplementedFunc),
    /*  423 */ SyscallDesc("unused#423", unimplementedFunc),
    /*  424 */ SyscallDesc("unused#424", unimplementedFunc),
    /*  425 */ SyscallDesc("unused#425", unimplementedFunc),
    /*  426 */ SyscallDesc("unused#426", unimplementedFunc),
    /*  427 */ SyscallDesc("unused#427", unimplementedFunc),
    /*  428 */ SyscallDesc("unused#428", unimplementedFunc),
    /*  429 */ SyscallDesc("unused#429", unimplementedFunc),
    /*  430 */ SyscallDesc("unused#430", unimplementedFunc),
    /*  431 */ SyscallDesc("unused#431", unimplementedFunc),
    /*  432 */ SyscallDesc("unused#432", unimplementedFunc),
    /*  433 */ SyscallDesc("unused#433", unimplementedFunc),
    /*  434 */ SyscallDesc("unused#434", unimplementedFunc),
    /*  435 */ SyscallDesc("unused#435", unimplementedFunc),
    /*  436 */ SyscallDesc("unused#436", unimplementedFunc),
    /*  437 */ SyscallDesc("unused#437", unimplementedFunc),
    /*  438 */ SyscallDesc("unused#438", unimplementedFunc),
    /*  439 */ SyscallDesc("unused#439", unimplementedFunc),
    /*  440 */ SyscallDesc("unused#440", unimplementedFunc),
    /*  441 */ SyscallDesc("unused#441", unimplementedFunc),
    /*  442 */ SyscallDesc("unused#442", unimplementedFunc),
    /*  443 */ SyscallDesc("unused#443", unimplementedFunc),
    /*  444 */ SyscallDesc("unused#444", unimplementedFunc),
    /*  445 */ SyscallDesc("unused#445", unimplementedFunc),
    /*  446 */ SyscallDesc("unused#446", unimplementedFunc),
    /*  447 */ SyscallDesc("unused#447", unimplementedFunc),
    /*  448 */ SyscallDesc("unused#448", unimplementedFunc),
    /*  449 */ SyscallDesc("unused#449", unimplementedFunc),
    /*  450 */ SyscallDesc("unused#450", unimplementedFunc),
    /*  451 */ SyscallDesc("unused#451", unimplementedFunc),
    /*  452 */ SyscallDesc("unused#452", unimplementedFunc),
    /*  453 */ SyscallDesc("unused#453", unimplementedFunc),
    /*  454 */ SyscallDesc("unused#454", unimplementedFunc),
    /*  455 */ SyscallDesc("unused#455", unimplementedFunc),
    /*  456 */ SyscallDesc("unused#456", unimplementedFunc),
    /*  457 */ SyscallDesc("unused#457", unimplementedFunc),
    /*  458 */ SyscallDesc("unused#458", unimplementedFunc),
    /*  459 */ SyscallDesc("unused#459", unimplementedFunc),
    /*  460 */ SyscallDesc("unused#460", unimplementedFunc),
    /*  461 */ SyscallDesc("unused#461", unimplementedFunc),
    /*  462 */ SyscallDesc("unused#462", unimplementedFunc),
    /*  463 */ SyscallDesc("unused#463", unimplementedFunc),
    /*  464 */ SyscallDesc("unused#464", unimplementedFunc),
    /*  465 */ SyscallDesc("unused#465", unimplementedFunc),
    /*  466 */ SyscallDesc("unused#466", unimplementedFunc),
    /*  467 */ SyscallDesc("unused#467", unimplementedFunc),
    /*  468 */ SyscallDesc("unused#468", unimplementedFunc),
    /*  469 */ SyscallDesc("unused#469", unimplementedFunc),
    /*  470 */ SyscallDesc("unused#470", unimplementedFunc),
    /*  471 */ SyscallDesc("unused#471", unimplementedFunc),
    /*  472 */ SyscallDesc("unused#472", unimplementedFunc),
    /*  473 */ SyscallDesc("unused#473", unimplementedFunc),
    /*  474 */ SyscallDesc("unused#474", unimplementedFunc),
    /*  475 */ SyscallDesc("unused#475", unimplementedFunc),
    /*  476 */ SyscallDesc("unused#476", unimplementedFunc),
    /*  477 */ SyscallDesc("mmap", mmapFunc<ArmFreebsd64>),
    /*  478 */ SyscallDesc("unused#478", unimplementedFunc),
    /*  479 */ SyscallDesc("unused#479", unimplementedFunc),
    /*  480 */ SyscallDesc("unused#480", unimplementedFunc),
    /*  481 */ SyscallDesc("unused#481", unimplementedFunc),
    /*  482 */ SyscallDesc("unused#482", unimplementedFunc),
    /*  483 */ SyscallDesc("unused#483", unimplementedFunc),
    /*  484 */ SyscallDesc("unused#484", unimplementedFunc),
    /*  485 */ SyscallDesc("unused#485", unimplementedFunc),
    /*  486 */ SyscallDesc("unused#486", unimplementedFunc),
    /*  487 */ SyscallDesc("unused#487", unimplementedFunc),
    /*  488 */ SyscallDesc("unused#488", unimplementedFunc),
    /*  489 */ SyscallDesc("unused#489", unimplementedFunc),
    /*  490 */ SyscallDesc("unused#490", unimplementedFunc),
    /*  491 */ SyscallDesc("unused#491", unimplementedFunc),
    /*  492 */ SyscallDesc("unused#492", unimplementedFunc),
    /*  493 */ SyscallDesc("unused#493", unimplementedFunc),
    /*  494 */ SyscallDesc("unused#494", unimplementedFunc),
    /*  495 */ SyscallDesc("unused#495", unimplementedFunc),
    /*  496 */ SyscallDesc("unused#496", unimplementedFunc),
    /*  497 */ SyscallDesc("unused#497", unimplementedFunc),
    /*  498 */ SyscallDesc("unused#498", unimplementedFunc),
    /*  499 */ SyscallDesc("unused#499", unimplementedFunc),
    /*  500 */ SyscallDesc("unused#500", unimplementedFunc),
    /*  501 */ SyscallDesc("unused#501", unimplementedFunc),
    /*  502 */ SyscallDesc("unused#502", unimplementedFunc),
    /*  503 */ SyscallDesc("unused#503", unimplementedFunc),
    /*  504 */ SyscallDesc("unused#504", unimplementedFunc),
    /*  505 */ SyscallDesc("unused#505", unimplementedFunc),
    /*  506 */ SyscallDesc("unused#506", unimplementedFunc),
    /*  507 */ SyscallDesc("unused#507", unimplementedFunc),
    /*  508 */ SyscallDesc("unused#508", unimplementedFunc),
    /*  509 */ SyscallDesc("unused#509", unimplementedFunc),
    /*  510 */ SyscallDesc("unused#510", unimplementedFunc),
    /*  511 */ SyscallDesc("unused#511", unimplementedFunc),
    /*  512 */ SyscallDesc("unused#512", unimplementedFunc),
    /*  513 */ SyscallDesc("unused#513", unimplementedFunc),
    /*  514 */ SyscallDesc("unused#514", unimplementedFunc),
    /*  515 */ SyscallDesc("unused#515", unimplementedFunc),
    /*  516 */ SyscallDesc("unused#516", unimplementedFunc),
    /*  517 */ SyscallDesc("unused#517", unimplementedFunc),
    /*  518 */ SyscallDesc("unused#518", unimplementedFunc),
    /*  519 */ SyscallDesc("unused#519", unimplementedFunc),
    /*  520 */ SyscallDesc("unused#520", unimplementedFunc),
    /*  521 */ SyscallDesc("unused#521", unimplementedFunc),
    /*  522 */ SyscallDesc("unused#522", unimplementedFunc),
    /*  523 */ SyscallDesc("unused#523", unimplementedFunc),
    /*  524 */ SyscallDesc("unused#524", unimplementedFunc),
    /*  525 */ SyscallDesc("unused#525", unimplementedFunc),
    /*  526 */ SyscallDesc("unused#526", unimplementedFunc),
    /*  527 */ SyscallDesc("unused#527", unimplementedFunc),
    /*  528 */ SyscallDesc("unused#528", unimplementedFunc),
    /*  529 */ SyscallDesc("unused#529", unimplementedFunc),
    /*  530 */ SyscallDesc("unused#530", unimplementedFunc),
    /*  531 */ SyscallDesc("unused#531", unimplementedFunc),
    /*  532 */ SyscallDesc("unused#532", unimplementedFunc),
    /*  533 */ SyscallDesc("unused#533", unimplementedFunc),
    /*  534 */ SyscallDesc("unused#534", unimplementedFunc),
    /*  535 */ SyscallDesc("unused#535", unimplementedFunc),
    /*  536 */ SyscallDesc("unused#536", unimplementedFunc),
    /*  537 */ SyscallDesc("unused#537", unimplementedFunc),
    /*  538 */ SyscallDesc("unused#538", unimplementedFunc),
    /*  539 */ SyscallDesc("unused#539", unimplementedFunc),
    /*  540 */ SyscallDesc("unused#540", unimplementedFunc),
    /*  541 */ SyscallDesc("unused#541", unimplementedFunc),
    /*  542 */ SyscallDesc("unused#542", unimplementedFunc),
    /*  543 */ SyscallDesc("unused#543", unimplementedFunc),
    /*  544 */ SyscallDesc("unused#544", unimplementedFunc),
    /*  545 */ SyscallDesc("unused#545", unimplementedFunc),
    /*  546 */ SyscallDesc("unused#546", unimplementedFunc),
    /*  547 */ SyscallDesc("unused#547", unimplementedFunc),
};

ArmFreebsdProcess32::ArmFreebsdProcess32(ProcessParams * params,
        ObjectFile *objFile, ObjectFile::Arch _arch)
    : ArmProcess32(params, objFile, _arch)
{
    SyscallTable table;

    table.descs = syscallDescs32;
    table.size = sizeof(syscallDescs32) / sizeof(SyscallDesc);
    table.base = 0;
    syscallTables.push_back(table);
}

ArmFreebsdProcess64::ArmFreebsdProcess64(ProcessParams * params,
        ObjectFile *objFile, ObjectFile::Arch _arch)
    : ArmProcess64(params, objFile, _arch)
{
    SyscallTable table;

    table.descs = syscallDescs64;
    table.size = sizeof(syscallDescs64) / sizeof(SyscallDesc);
    table.base = 0;
    syscallTables.push_back(table);
}

SyscallDesc*
ArmFreebsdProcessBits::getFreebsdDesc(int callnum)
{

    for (unsigned i = 0; i < syscallTables.size(); i++) {
        SyscallDesc *desc = syscallTables[i].getDesc(callnum);
        if (desc)
            return desc;
    }
    return NULL;
}

SyscallDesc *
ArmFreebsdProcessBits::SyscallTable::getDesc(int callnum) const
{

    int offset = callnum - base;
    if (offset < 0 || offset >= size)
        return NULL;
    return &descs[offset];
}

SyscallDesc*
ArmFreebsdProcess32::getDesc(int callnum)
{

    return getFreebsdDesc(callnum);
}

SyscallDesc*
ArmFreebsdProcess64::getDesc(int callnum)
{

    return getFreebsdDesc(callnum);
}

void
ArmFreebsdProcess32::initState()
{
    ArmProcess32::initState();
    // The 32 bit equivalent of the comm page would be set up here.
}

void
ArmFreebsdProcess64::initState()
{
    ArmProcess64::initState();
    // The 64 bit equivalent of the comm page would be set up here.
}
