#! /usr/bin/env python

from tools.my_experiment import MyExperiment
import ms_parser_attributes
import sys
sys.path.insert(1, '../merge-strategies')
import merge_strategies_attributes
import efficient_ms_attributes

# Set the following variables for the experiment
REPO_NAME = 'downward/merge-strategies'
REVISIONS = ['de811b8f363e']

CONFIGS = {
    'b50k-cggl-partialsingle-inithsizernd-transabort2m': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false),merge_strategy=merge_precomputed(merge_tree=linear(variable_order=cg_goal_level)),max_states=50000,threshold_before_merge=1,partial_mas_method=single,factor_scoring_functions=[fsf_inith,fsf_size,fsf_random]num_transitions_to_abort=2000000))'],
    'b50k-dfp-partialsingle-inithsizernd-transabort2m': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false),merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)])),max_states=50000,threshold_before_merge=1,partial_mas_method=single,factor_scoring_functions=[fsf_inith,fsf_size,fsf_random]num_transitions_to_abort=2000000))'],
    'b50k-miasm-dfp-partialsingle-inithsizernd-transabort2m': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false),merge_strategy=merge_precomputed(merge_tree=miasm(abstraction=miasm_merge_and_shrink,fallback_merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)]))),max_states=50000,threshold_before_merge=1,partial_mas_method=single,factor_scoring_functions=[fsf_inith,fsf_size,fsf_random]num_transitions_to_abort=2000000))'],
    'b50k-rl-partialsingle-inithsizernd-transabort2m': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false),merge_strategy=merge_precomputed(merge_tree=linear(variable_order=reverse_level)),max_states=50000,threshold_before_merge=1,partial_mas_method=single,factor_scoring_functions=[fsf_inith,fsf_size,fsf_random]num_transitions_to_abort=2000000))'],
    'b50k-sccdfp-partialsingle-inithsizernd-transabort2m': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false),merge_strategy=merge_sccs(order_of_sccs=topological,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)])),max_states=50000,threshold_before_merge=1,partial_mas_method=single,factor_scoring_functions=[fsf_inith,fsf_size,fsf_random]num_transitions_to_abort=2000000))'],
    'b50k-sbmiasm-partialsingle-inithsizernd-transabort2m': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false),merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)])),max_states=50000,threshold_before_merge=1,partial_mas_method=single,factor_scoring_functions=[fsf_inith,fsf_size,fsf_random]num_transitions_to_abort=2000000))'],

    'b50k-cggl-partialsingle-inithsizernd-transabort5m': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false),merge_strategy=merge_precomputed(merge_tree=linear(variable_order=cg_goal_level)),max_states=50000,threshold_before_merge=1,partial_mas_method=single,factor_scoring_functions=[fsf_inith,fsf_size,fsf_random]num_transitions_to_abort=5000000))'],
    'b50k-dfp-partialsingle-inithsizernd-transabort5m': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false),merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)])),max_states=50000,threshold_before_merge=1,partial_mas_method=single,factor_scoring_functions=[fsf_inith,fsf_size,fsf_random]num_transitions_to_abort=5000000))'],
    'b50k-miasm-dfp-partialsingle-inithsizernd-transabort5m': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false),merge_strategy=merge_precomputed(merge_tree=miasm(abstraction=miasm_merge_and_shrink,fallback_merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)]))),max_states=50000,threshold_before_merge=1,partial_mas_method=single,factor_scoring_functions=[fsf_inith,fsf_size,fsf_random]num_transitions_to_abort=5000000))'],
    'b50k-rl-partialsingle-inithsizernd-transabort5m': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false),merge_strategy=merge_precomputed(merge_tree=linear(variable_order=reverse_level)),max_states=50000,threshold_before_merge=1,partial_mas_method=single,factor_scoring_functions=[fsf_inith,fsf_size,fsf_random]num_transitions_to_abort=5000000))'],
    'b50k-sccdfp-partialsingle-inithsizernd-transabort5m': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false),merge_strategy=merge_sccs(order_of_sccs=topological,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)])),max_states=50000,threshold_before_merge=1,partial_mas_method=single,factor_scoring_functions=[fsf_inith,fsf_size,fsf_random]num_transitions_to_abort=5000000))'],
    'b50k-sbmiasm-partialsingle-inithsizernd-transabort5m': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false),merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)])),max_states=50000,threshold_before_merge=1,partial_mas_method=single,factor_scoring_functions=[fsf_inith,fsf_size,fsf_random]num_transitions_to_abort=5000000))'],

    'b50k-cggl-partialsingle-inithsizernd-transabort10m': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false),merge_strategy=merge_precomputed(merge_tree=linear(variable_order=cg_goal_level)),max_states=50000,threshold_before_merge=1,partial_mas_method=single,factor_scoring_functions=[fsf_inith,fsf_size,fsf_random]num_transitions_to_abort=10000000))'],
    'b50k-dfp-partialsingle-inithsizernd-transabort10m': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false),merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)])),max_states=50000,threshold_before_merge=1,partial_mas_method=single,factor_scoring_functions=[fsf_inith,fsf_size,fsf_random]num_transitions_to_abort=10000000))'],
    'b50k-miasm-dfp-partialsingle-inithsizernd-transabort10m': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false),merge_strategy=merge_precomputed(merge_tree=miasm(abstraction=miasm_merge_and_shrink,fallback_merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)]))),max_states=50000,threshold_before_merge=1,partial_mas_method=single,factor_scoring_functions=[fsf_inith,fsf_size,fsf_random]num_transitions_to_abort=10000000))'],
    'b50k-rl-partialsingle-inithsizernd-transabort10m': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false),merge_strategy=merge_precomputed(merge_tree=linear(variable_order=reverse_level)),max_states=50000,threshold_before_merge=1,partial_mas_method=single,factor_scoring_functions=[fsf_inith,fsf_size,fsf_random]num_transitions_to_abort=10000000))'],
    'b50k-sccdfp-partialsingle-inithsizernd-transabort10m': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false),merge_strategy=merge_sccs(order_of_sccs=topological,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)])),max_states=50000,threshold_before_merge=1,partial_mas_method=single,factor_scoring_functions=[fsf_inith,fsf_size,fsf_random]num_transitions_to_abort=10000000))'],
    'b50k-sbmiasm-partialsingle-inithsizernd-transabort10m': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false),merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)])),max_states=50000,threshold_before_merge=1,partial_mas_method=single,factor_scoring_functions=[fsf_inith,fsf_size,fsf_random]num_transitions_to_abort=10000000))'],
}

# Create the experiment. Add parsers, fetchers or reports...
exp = MyExperiment(
    repo_name=REPO_NAME,
    configs=CONFIGS,
    revisions=REVISIONS,
    test_suite=['depot:p01.pddl', 'gripper:prob01.pddl', 'gripper:prob02.pddl', 'mystery:prob07.pddl']
)
exp.add_search_parser('../ms-parser.py', ms_parser_attributes.get())
exp.add_search_parser('../merge-strategies/merge-strategies-parser.py', merge_strategies_attributes.get())
exp.add_search_parser('efficient-ms-parser.py', efficient_ms_attributes.get())

exp.add_absolute_report()

exp.run_steps()

