#! /usr/bin/env python

from lab.reports import arithmetic_mean, geometric_mean, percentile_50, percentile_75, percentile_90, percentile_95, Attribute

from tools.my_experiment import MyExperiment
from tools.my_reports import FlexibleAttribute

import ms_parser_attributes
import old_mas_attributes
import sys
sys.path.insert(1, '../merge-strategies')
import merge_strategies_attributes
import miasm_attributes
import symmetries_attributes


import math
import os.path

# Set the following variables for the experiment
REPO_NAME = 'downward/old-merge-and-shrink'
REVISIONS = [
    'ec86b375b8fa',
]

CONFIGS = {}

# Create the experiment. Add parsers, fetchers or reports...
exp = MyExperiment(
    repo_name=REPO_NAME,
    configs=CONFIGS,
    revisions=REVISIONS,
    #test_suite=['depot:pfile1', 'depot:pfile2', 'gripper:prob01.pddl', 'gripper:prob02.pddl']
)
# for attributes
exp.add_search_parser('old-mas-parser.py', old_mas_attributes.get())
exp.add_search_parser('../ms-parser.py', ms_parser_attributes.get())
exp.add_search_parser('../merge-strategies/merge-strategies-parser.py', merge_strategies_attributes.get())
exp.add_search_parser('../merge-strategies/miasm-parser.py', miasm_attributes.get())

def remove_revision(run):
    algorithm = run['algorithm']
    for rev in REVISIONS:
        algorithm = algorithm.replace('%s-' % rev, '')
    run['algorithm'] = algorithm
    return run

exp.add_fetcher(os.path.expanduser('~/experiments/old-merge-and-shrink/2018-05-06-nlr-b50k-eval/'),filter=[remove_revision])
exp.add_fetcher(os.path.expanduser('~/experiments/old-merge-and-shrink/2018-05-06-sota-b50k-eval/'),filter=[remove_revision],merge=True)


###### HTML tables ###################################################

# exp.add_absolute_report(
    # attributes=['coverage'],
    # publish=False,
# )

exp.add_comparison_report(
    algorithm_pairs=[
        ('nlr-b50k-cggl', 'b50k-cggl'),
        ('nlr-b50k-dfp', 'b50k-dfp-rl-nto-pba'),
        # ('nlr-b50k-gcgl', 'b50k-gcgl'),
        # ('nlr-b50k-l', 'b50k-l'),
        ('nlr-b50k-miasm', 'b50k-miasm-dfp-rl-nto-pba'),
        ('nlr-b50k-rl', 'b50k-rl'),
        ('nlr-b50k-symmb60cggl', 'b50k-symmb60cggl'),
        ('nlr-b50k-symmb60dfp', 'b50k-symmb60dfp-rl-nto-pba'),
        # ('nlr-b50k-symmb60gcgl', 'b50k-symmb60gcgl'),
        # ('nlr-b50k-symmb60l', 'b50k-symmb60l'),
        ('nlr-b50k-symmb60miasm', 'b50k-symmb60miasm-dfp-rl-nto-pba'),
        ('nlr-b50k-symmb60rl', 'b50k-symmb60rl'),
    ],
    publish=False,
)


####### Paper tables #################################################

attributes = [
    'coverage',
    'search_time',
    'total_time',
    Attribute('ms_abstraction_constructed', absolute=True, min_wins=False),
    Attribute('ms_construction_time', absolute=False, min_wins=True, functions=[arithmetic_mean]),
    Attribute('ms_atomic_construction_time', absolute=False, min_wins=True, functions=[arithmetic_mean]),
    Attribute('ms_final_size', absolute=False, min_wins=True),
    Attribute('ms_out_of_memory', absolute=True, min_wins=True),
    Attribute('ms_out_of_time', absolute=True, min_wins=True),
    Attribute('ms_max_int_abs_size', absolute=False, min_wins=True, functions=[arithmetic_mean]),
]

exp.add_comparison_report(algorithm_pairs=[
    ('nlr-b50k-cggl', 'b50k-cggl'),
],format='tex',publish=False,name='cggl',attributes=attributes)

exp.add_comparison_report(algorithm_pairs=[
    ('nlr-b50k-dfp', 'b50k-dfp-rl-nto-pba'),
],format='tex',publish=False,name='dfp',attributes=attributes)

# exp.add_comparison_report(algorithm_pairs=[
    # ('nlr-b50k-gcgl', 'b50k-gcgl'),
# ],format='tex',publish=False,name='gcgl',attributes=attributes)

# exp.add_comparison_report(algorithm_pairs=[
    # ('nlr-b50k-l', 'b50k-l'),
# ],format='tex',publish=False,name='l',attributes=attributes)

exp.add_comparison_report(algorithm_pairs=[
    ('nlr-b50k-miasm', 'b50k-miasm-dfp-rl-nto-pba'),
],format='tex',publish=False,name='miasm',attributes=attributes)

exp.add_comparison_report(algorithm_pairs=[
    ('nlr-b50k-rl', 'b50k-rl'),
],format='tex',publish=False,name='rl',attributes=attributes)


flexible_attributes = [
    FlexibleAttribute('expansions_until_last_jump', 'Exp', float('inf'), absolute=False, min_wins=True, functions=[percentile_50, percentile_75, percentile_90, percentile_95]),
]

exp.add_flexible_aggregation_report(
    algorithm_rows=[
        [
            [
                'nlr-b50k-cggl', 'b50k-cggl',
            ],
        ],
        [
            [
                'nlr-b50k-dfp', 'b50k-dfp-rl-nto-pba',
            ],
        ],
        # [
            # [
                # 'nlr-b50k-gcgl', 'b50k-gcgl',
            # ],
        # ],
        # [
            # [
                # 'nlr-b50k-l', 'b50k-l',
            # ],
        # ],
        [
            [
                'nlr-b50k-miasm', 'b50k-miasm-dfp-rl-nto-pba',
            ],
        ],
        [
            [
                'nlr-b50k-rl', 'b50k-rl',
            ],
        ],
    ],
    flexible_attributes=flexible_attributes,
    single_aggregation=False,
    name='pairwise',
)

exp.add_scatter_plot_report(
    filter_algorithm=[
        'nlr-b50k-cggl', 'b50k-cggl',
    ],
    attributes=['expansions_until_last_jump'],
    name='b50k-cggl-expansions-nlr-vs-sota',
    format='png',
)

exp.add_scatter_plot_report(
    filter_algorithm=[
        'nlr-b50k-dfp', 'b50k-dfp-rl-nto-pba',
    ],
    attributes=['expansions_until_last_jump'],
    name='b50k-cggl-expansions-nlr-vs-sota',
    format='png',
)

exp.add_scatter_plot_report(
    filter_algorithm=[
        'nlr-b50k-miasm', 'b50k-miasm-dfp-rl-nto-pba',
    ],
    attributes=['expansions_until_last_jump'],
    name='b50k-cggl-expansions-nlr-vs-sota',
    format='png',
)

exp.add_scatter_plot_report(
    filter_algorithm=[
        'nlr-b50k-rl', 'b50k-rl',
    ],
    attributes=['expansions_until_last_jump'],
    name='b50k-cggl-expansions-nlr-vs-sota',
    format='png',
)

exp.run_steps()
