#! /usr/bin/env python

from lab.parser import Parser
import re

parser = Parser()

parser.add_pattern('ms_avg_imperfect_shrinking', 'Average imperfect shrinking: (.+)', required=False, type=float)
parser.add_pattern('ms_not_exact_iteration', 'not perfect anymore in iteration (\d+)', required=False, type=int)
parser.add_pattern('ms_max_int_abs_size', 'Maximum intermediate abstraction size: (\d+)', required=False, type=int)

def course_imperfect_shrinking(content, props):
    course = re.findall(r'Course of miss qualified states shrinking: \[(.*)\]', content)
    props['ms_course_imperfect_shrinking'] = course

parser.add_function(course_imperfect_shrinking)

def check_linear_order(content, props):
    linear_order = None
    for line in content.splitlines():
        if line == 'Linear merge order':
            linear_order = True
            break
        if line == 'Non-linear merge order':
            linear_order = False
            break
    props['ms_linear_order'] = linear_order

parser.add_function(check_linear_order)

def parse_merge_order(content, props):
    merge_order = re.findall(r'Merge order: \[(.*)\]', content)
    props['ms_merge_order'] = merge_order

parser.add_function(parse_merge_order)

parser.parse()
