#! /usr/bin/env python

from tools.my_experiment import MyExperiment
import ms_parser_attributes
import old_mas_attributes

# Set the following variables for the experiment
REPO_NAME = 'downward/old-merge-and-shrink'
REVISIONS = ['ec86b375b8fa']

CONFIGS = {
    'nlr-b50k-cggl': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=cg_goal_level),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_system_order=random))'],
    'nlr-b50k-dfp': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_dfp,shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_system_order=random))'],
    'nlr-b50k-gcgl': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=goal_cg_level),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_system_order=random))'],
    'nlr-b50k-l': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=level),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_system_order=random))'],
    'nlr-b50k-miasm': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_miasm,sum_computation_bound=1000000,shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_system_order=random))'],
    'nlr-b50k-rl': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=reverse_level),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_system_order=random))'],

    'nlr-b50k-symmb60cggl': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries_linear(variable_order=cg_goal_level,build_stabilized_pdg=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,stop_after_no_symmetries=false,symmetries_for_merging=largest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_system_order=random))'],
    'nlr-b50k-symmb60dfp': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries(build_stabilized_pdg=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,stop_after_no_symmetries=false,symmetries_for_merging=largest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_system_order=random))'],
    'nlr-b50k-symmb60gcgl': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries_linear(variable_order=goal_cg_level,build_stabilized_pdg=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,stop_after_no_symmetries=false,symmetries_for_merging=largest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_system_order=random))'],
    'nlr-b50k-symmb60l': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries_linear(variable_order=level,build_stabilized_pdg=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,stop_after_no_symmetries=false,symmetries_for_merging=largest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_system_order=random))'],
    'nlr-b50k-symmb60miasm': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries_miasm(build_stabilized_pdg=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,stop_after_no_symmetries=false,symmetries_for_merging=largest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_system_order=random))'],
    'nlr-b50k-symmb60rl': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries_linear(variable_order=reverse_level,build_stabilized_pdg=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,stop_after_no_symmetries=false,symmetries_for_merging=largest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_system_order=random))'],
}

# Create the experiment. Add parsers, fetchers or reports...
exp = MyExperiment(
    repo_name=REPO_NAME,
    configs=CONFIGS,
    revisions=REVISIONS,
    test_suite=['depot:p01.pddl', 'depot:p02.pddl', 'gripper:prob01.pddl', 'gripper:prob02.pddl', 'mystery:prob07.pddl']
)
exp.add_search_parser('../ms-parser.py', ms_parser_attributes.get())
exp.add_search_parser('old-mas-parser.py', old_mas_attributes.get())

exp.add_absolute_report()

exp.run_steps()
