#ifndef SETOP_H
#define SETOP_H

#include <set>
#include <algorithm>

namespace set_operation {

    template <class T>
    void get_union(const std::set<T>& first, const std::set<T>& second,
            std::set<T>& result) {
        std::set_union(first.begin(), first.end(), second.begin(), second.end(),
                       inserter(result, result.begin()));
    }

    template <class T>
    bool disjoint(const std::set<T>& first, const std::set<T>& second) {
        for (typename std::set<T>::iterator i = first.begin();
                i != first.end(); i++) {
            if (second.find(*i) != second.end()) return false;
        }
        return true;
    }
}
#endif
