#ifndef MAS_NEW_LR_UTIL_SET_PACKING_H
#define MAS_NEW_LR_UTIL_SET_PACKING_H

#include <set>
#include <map>

namespace mas_new_lr {
typedef std::pair<std::set<int>, double> weighted_set_t;

namespace set_packing {
    double greedy_packing(const std::map<std::set<int>, double>& w,
            std::set<std::set<int> >& subfamily);
    /**
     * Compare the weight of two weighted sets
     * @param first: the first weighted set
     * @param second: the second weighted set
     * @return 
     */
    bool compare_weighted_set(weighted_set_t first,
            weighted_set_t second);
}
}


#endif
