#include "set_packing.h"

#include <iostream>
#include <vector>

#include <algorithm>

#include <cassert>
#include <cmath>

#include "../../globals.h"
#include "../../task_utils/causal_graph.h"

#include "../../utils/logging.h"

#include "setop.h"

using namespace std;
using namespace set_operation;

namespace mas_new_lr {
double set_packing::greedy_packing(const map<set<int>, double>& w,
        set<set<int> >& subfamily) {

    double total_weight = 0;

    vector<weighted_set_t> remaining(w.begin(), w.end());
    sort(remaining.begin(), remaining.end(), compare_weighted_set);

    //    set<set<int> > subfamily;

    while (!remaining.empty()) {
        set<int> chosen_one = remaining.begin()->first;
        cerr << chosen_one << remaining.begin()->second << endl;
        total_weight += remaining.begin()->second;

        vector<weighted_set_t> new_remaining;
        for (vector<weighted_set_t>::iterator i = remaining.begin();
                i != remaining.end(); i++) {
            if (disjoint(i->first, chosen_one)) {
                new_remaining.push_back(*i);
            }
        }

        remaining = new_remaining;
        subfamily.insert(chosen_one);
    }

    return total_weight;
}

bool set_packing::compare_weighted_set(weighted_set_t first,
        weighted_set_t second) {
    if (first.second > second.second
            || (abs(first.second - second.second) < 1e-10
            && first.first.size() < second.first.size())) {
        return true;
    }
    return false;
}
}
