#include "lattice_varset.h"

#include <cstdio>
#include <cmath>

#include <iostream>
#include <vector>

#include <map>

#include "../utils/logging.h"

using namespace std;
using namespace utils;

namespace mas_new_lr {
LatticeVarset::LatticeVarset() {
    varset.clear();
    ratio = -1;
    total = -1;
    reach = -1;
    diff = -1;
}

bool LatticeVarset::operator<(const LatticeVarset& other) const {
    if (diff < other.diff) return true;
    if (abs(diff - other.diff) < 1e-7
            && reach > other.reach) return true;
    return false;
}

void LatticeVarset::enumerate_k_subsets(const int k,
        set<set<int> >& k_subsets) const {
    enumerate_k_subsets(varset, k, k_subsets);
}

void LatticeVarset::enumerate_k_subsets(const set<int> S, const int k,
        set<set<int> >& k_subsets) {
    const int n = S.size();
    vector<int> var(S.begin(), S.end());

    vector<int> v(k);
    vector<bool> chosen(n, false);

    int index = 0;
    v[index] = -1;

    while (index >= 0) {
        if (index >= k) {
            set<int> s;
            for (int i = 0; i < static_cast<int>(v.size()); i++) s.insert(var[v[i]]);
            k_subsets.insert(s);
            index--;
            if (index >= 0) chosen[v[index]] = false;
        } else {
            v[index]++;
            if (v[index] >= n) {
                index--;
                if (index >= 0) chosen[v[index]] = false;
            } else if (!chosen[v[index]]) {
                chosen[v[index]] = true;
                index++;
                if (index < k) v[index] = v[index - 1];
            }
        }
    }
}
}
