#ifndef MAS_NEW_LR_MERGE_TREE_H
#define MAS_NEW_LR_MERGE_TREE_H

#include <fstream>
#include <vector>
#include <set>
#include <map>

#include <../ext/tree.hh>
#include <../ext/tree_util.hh>

namespace mas_new_lr {
enum ClusterExternalMergeStrategyType {
    CLUSTER_EXTERNAL_LINEAR_LARGE_CG_GOAL_LEVEL,
    CLUSTER_EXTERNAL_LINEAR_SMALL_CG_GOAL_LEVEL,
    CLUSTER_EXTERNAL_LINEAR_CG_GOAL_REVERSE_LEVEL
};

enum ClusterInternalMergeStrategyType {
    CLUSTER_INTERNAL_LINEAR_LEVEL,
    CLUSTER_INTERNAL_LINEAR_REVERSE_LEVEL
};

typedef std::set<int> node_t;

class MergeTree {
public:
    static tree<node_t> merge_tree_clusters(const std::set<std::set<int> >& clusters,
            const ClusterExternalMergeStrategyType external,
            const ClusterInternalMergeStrategyType internal);

    static void find_pred_cluster(std::map<int, std::set<int> >& v2c,
            std::vector<int>& rv, std::set<int>& predecessors, std::set<int>& chosen_cluster);

    static void find_goal_cluster(std::map<int, std::set<int> >& v2c,
            const std::set<int> goal_var, std::vector<int>& rv, std::set<int>& predecessors,
            std::set<int>& chosen_cluster);


    static void update_cluster_pred(std::vector<int>& remaining_variables,
            std::set<int>& chosen_cluster, std::set<int>& predecessors);

    static tree<node_t> merge_subtrees(tree<node_t>& left,
            tree<node_t>& right);

    static tree<node_t> merge_tree_cluster_internal(const std::set<int>& cluster,
            const ClusterInternalMergeStrategyType internal);

    static tree<node_t> readin_merge_tree_recursive();

    static tree<node_t> readin_branching_recursive(std::ifstream& fin_mt_rec);

};
}



#endif
