#ifndef MAS_NEW_LR_MERGE_MIASM_STRATEGY_H
#define MAS_NEW_LR_MERGE_MIASM_STRATEGY_H

#include "merge_dfp.h"

#include <../ext/tree.hh>
#include <../ext/tree_util.hh>

namespace mas_new_lr {
class MergeMiasm : public MergeDFP {
    /*
     * In the "old" merge-and-shrink main loop, a new composite abstraction
     * was always stored at the lower index of the two merged abstractions.
     * In the "new" merge-and-shrink main loop, new composite abstractions
     * are always appended at the vector of all current abstractions.
     * This vector maps old to new indices (afted after every merge).
     */
    //std::vector<int> old_to_new_indices;
    void dump_strategy_specific_options() const;
public:
    MergeMiasm();
    ~MergeMiasm() {}

    tree<std::set<int> > merge_tree;
    bool merge_tree_set;

    virtual std::pair<int, int> get_next(const std::vector<Abstraction *> &all_abstractions);
    virtual std::string name() const;
};
}

#endif
