#include "merge_miasm.h"

#include "abstraction.h"
#include "merge_tree.h"

#include "util/set_packing.h"

#include "../globals.h"
#include "../plugin.h"

#include <cassert>

using namespace std;

namespace mas_new_lr {
MergeMiasm::MergeMiasm()
    : MergeDFP(),
      merge_tree_set(false) {
//    old_to_new_indices.reserve(g_variable_domain.size());
//    for (int var = 0; var < g_variable_domain.size(); ++var) {
//        old_to_new_indices.push_back(var);
//    }
}

pair<int, int> MergeMiasm::get_next(
        const std::vector<Abstraction *> &all_abstractions) {
    /* initialization */
    if (remaining_merges == -1) {
        remaining_merges = all_abstractions.size() - 1;
    }

    if (merge_tree_set) {
        pair<int, int> next_indices;

        for (tree<node_t>::leaf_iterator i_node = merge_tree.begin_leaf();
                i_node != merge_tree.end_leaf(); i_node++) {
            for (tree<node_t>::leaf_iterator j_node = i_node;
                    j_node != merge_tree.end_leaf(); j_node++) {
                if (merge_tree.parent(i_node) == merge_tree.parent(j_node)
                        && i_node != j_node) {
                    int first_index = *(i_node->begin());
                    int second_index = *(j_node->begin());
                    //cout << "old: " << first_old << " " << second_old << endl;
                    //int first_new = old_to_new_indices[first_old];
                    //int second_new = old_to_new_indices[second_old];
                    //cout << "new: " << first_new << " " << second_new << endl;
                    const vector<int> first_varset = all_abstractions[first_index]->get_varset();
                    const vector<int> second_varset = all_abstractions[second_index]->get_varset();
                    if (first_varset[0] < second_varset[0]) {
                        //next_indices.first = first_new;
                        //next_indices.second = second_new;
                        //old_to_new_indices[first_old] = all_abstractions.size();
                        //cout << "updating " << first_old << " to " << all_abstractions.size() << endl;
                        //cout << "Merge " << *i_node
                        //        << "(" << next_indices.first << ")"
                        //        << " and " << *j_node
                        //        << "(" << next_indices.second << ")"
                        //        << endl;
                        next_indices.first = first_index;
                        next_indices.second = second_index;
                    } else {
                        //next_indices.first = second_new;
                        //next_indices.second = first_new;
                        //old_to_new_indices[second_old] = all_abstractions.size();
                        //cout << "updating " << second_old << " to " << all_abstractions.size() << endl;
                        //cout << "Merge " << *j_node
                        //        << "(" << next_indices.first << ")"
                        //        << " and " << *i_node
                        //        << "(" << next_indices.second << ")"
                        //        << endl;
                        next_indices.first = second_index;
                        next_indices.second = first_index;
                    }

                    remaining_merges--;

                    assert(merge_tree.parent(i_node)->empty());
                    merge_tree.parent(i_node)->insert(all_abstractions.size());
                    merge_tree.erase(i_node);
                    merge_tree.erase(j_node);
                    return next_indices;

                }
            }
        }

        next_indices.first = -1;
        next_indices.second = -1;
        assert(1 == 0);
        return next_indices;
    } else {
        return MergeDFP::get_next(all_abstractions);
    }
}

void MergeMiasm::dump_strategy_specific_options() const {
    cout << "Merge MIASM strategy" << endl;
}

string MergeMiasm::name() const {
    return "miasm";
}

static MergeStrategy *_parse(OptionParser &parser) {
    if (parser.help_mode())
        return 0;
    if (!parser.dry_run())
        return new MergeMiasm();
    else
        return 0;
}

static Plugin<MergeStrategy> _plugin("nlr_merge_miasm", _parse);
}
