#ifndef MAS_NEW_LR_MAS_NEW_LR_HEURISTIC_H
#define MAS_NEW_LR_MAS_NEW_LR_HEURISTIC_H

#include "../heuristic.h"

#include "../operator_cost.h"
#include "../option_parser.h"

#include <queue>

namespace mas_new_lr {
class Abstraction;
class Labels;
class LatticeVarset;
class MergeStrategy;
class ShrinkStrategy;

class MergeAndShrinkHeuristic : public Heuristic {
    MergeStrategy *const merge_strategy;
    ShrinkStrategy *const shrink_strategy;
    const bool use_expensive_statistics;
    const OperatorCost cost_type;
    Labels *labels;
    int starting_peak_memory;

    Abstraction *final_abstraction;
    Abstraction *build_abstraction();

    void report_peak_memory_delta(bool final = false) const;

    // GAOJIANS CODE //
    /* the sum of total number of states in spaces of ANY subsets explored */
    int sum_total_enqueued;
    int sum_computation;
    /* the bound on the sum of total number of states in spaces of
     * ANY subsets explored */
    int sum_total_enqueued_bound;
    int sum_computation_bound;
    int kickstart_sum_computation_bound;
    int arbitary_sum_computation_bound;

    int reach_bound;

    std::map<std::set<int>, double> ratio_table;
    std::map<std::set<int>, double> diff_table;

    std::map<std::set<int>, double> weight;

    std::set<std::set<int> > enqueued;
    /* priority queue that makes the exploration order of subsets;
     * the priority is determined by operator< in class LatticeVarset */
    std::priority_queue<LatticeVarset> pq;

    bool search_promising_clusters();
    void update_tables(const std::set<int> varset, const double ratio,
            const double diff);

    bool kickstart();

    void enqueue(std::priority_queue<LatticeVarset>& pq, LatticeVarset& lv);

    bool make_lattice_varset(const std::set<int>& var_set, LatticeVarset& lv);


    bool compute_diff_for(LatticeVarset& lv);
    bool subset_check(const std::set<int> & var_set,
            const std::set<std::set<int> >& enqueued,
            std::vector<LatticeVarset>& promising_subsets);
    //    void insert_ratio_table(std::set<int> s);

    //    bool add_promising_subset(priority_queue<VarSetRatio>& pq,
    //            VarSetRatio& pushed,
    //            int& total_size, const int total_size_bound,
    //            const int size_bound);
    /**
     *
     * @param k
     * @return
     */
    bool enumerate_subsets(const int k);

    bool reach_count(const std::vector<int>& v,
            int& reachable_count);

    int total_count(const std::vector<int>& v);
    // END GAOJIANS CODE //

    void dump_options() const;
    void warn_on_unusual_options() const;
protected:
    virtual void initialize();
    virtual int compute_heuristic(const GlobalState &state);
public:
    MergeAndShrinkHeuristic(const Options &opts);
    ~MergeAndShrinkHeuristic();
};
}

#endif
