#ifndef MAS_NEW_LR_LABELS_H
#define MAS_NEW_LR_LABELS_H

#include "../operator_cost.h"

#include <vector>

#include "../option_parser.h"

/*
 The Labels class is basically a container class for the set of all
 labels used by merge-and-shrink abstractions.
 */
namespace mas_new_lr {
class Abstraction;
class Label;
class LabelReducer;
class Labels {
    const bool unit_cost;
    const LabelReducer *label_reducer;

    std::vector<Label *> labels;
public:
    Labels(bool unit_cost, const Options &options, OperatorCost cost_type);
    ~Labels();
    void reduce(std::pair<int, int> next_merge,
                const std::vector<Abstraction *> &all_abstractions);
    // TODO: consider removing get_label_by_index and forwarding all required
    // methods of Label and giving access to them by label number.
    const Label *get_label_by_index(int index) const;
    bool is_label_reduced(int label_no) const;
    void dump() const;
    void dump_options() const;

    int get_size() const {
        return labels.size();
    }
    bool is_unit_cost() const {
        return unit_cost;
    }
};
}

#endif
