#include "labels.h"

#include "label.h"
#include "label_reducer.h"

#include "../operator_cost.h"

#include "../tasks/root_task.h"
#include "../task_proxy.h"

#include "../utils/collections.h"

#include <algorithm>
#include <cassert>

using namespace std;
using namespace utils;

namespace mas_new_lr {
Labels::Labels(bool unit_cost_, const Options &options, OperatorCost cost_type)
    : unit_cost(unit_cost_) {
    label_reducer = new LabelReducer(options);
    if (tasks::g_root_task->get_num_operators())
        labels.reserve(tasks::g_root_task->get_num_operators() * 2 - 1);
    TaskProxy task_proxy(*tasks::g_root_task);
    for (size_t i = 0; i < task_proxy.get_operators().size(); ++i) {
        OperatorProxy op = task_proxy.get_operators()[i];
        labels.push_back(
            new OperatorLabel(i, get_adjusted_action_cost(op, cost_type), op.get_preconditions(), op.get_effects()));
    }
}

Labels::~Labels() {
    delete label_reducer;
}

void Labels::reduce(pair<int, int> next_merge,
                    const std::vector<Abstraction *> &all_abstractions) {
    label_reducer->reduce_labels(next_merge, all_abstractions, labels);
}

const Label *Labels::get_label_by_index(int index) const {
    assert(in_bounds(index, labels));
    return labels[index];
}

bool Labels::is_label_reduced(int label_no) const {
    return get_label_by_index(label_no)->is_reduced();
}

void Labels::dump() const {
    cout << "no of labels: " << labels.size() << endl;
    for (size_t i = 0; i < labels.size(); ++i) {
        const Label *label = labels[i];
        label->dump();
    }
}

void Labels::dump_options() const {
    label_reducer->dump_options();
}
}
