#ifndef LEGACY_CAUSAL_GRAPH_H
#define LEGACY_CAUSAL_GRAPH_H

#include <vector>

typedef std::vector<std::vector<int>> IntRelation;

class AbstractTask;
class TaskProxy;

/*
  HACK! Copied from causal_graph to emulate the "legacy causal graph" which
  does not have eff-eff arcs.
*/
namespace legacy_causal_graph {
class LegacyCausalGraph {
    IntRelation pre_to_eff;
    IntRelation eff_to_pre;

    IntRelation successors;
    IntRelation predecessors;

    void dump(const TaskProxy &task_proxy) const;
public:
    /* Use the factory function get_causal_graph to create causal graphs
       to avoid creating more than one causal graph per AbstractTask. */
    explicit LegacyCausalGraph(const TaskProxy &task_proxy);
    ~LegacyCausalGraph() = default;

    /*
      All below methods querying neighbors (of some sort or other) of
      var guarantee that:
      - the return vertex list is sorted
      - var itself is not in the returned list

      "Successors" and "predecessors" are w.r.t. the common definition
      of causal graphs which have pre->eff arcs.

      Note that axioms are treated as operators in the causal graph,
      i.e., their condition variables are treated as precondition
      variables and the derived variable is treated as an effect
      variable.

      For effect conditions, we only add pre->eff arcs for the respective
      conditional effect.
    */

    const std::vector<int> &get_pre_to_eff(int var) const {
        return pre_to_eff[var];
    }

    const std::vector<int> &get_eff_to_pre(int var) const {
        return eff_to_pre[var];
    }

    const std::vector<int> &get_successors(int var) const {
        return successors[var];
    }

    const std::vector<int> &get_predecessors(int var) const {
        return predecessors[var];
    }
};

/* Create or retrieve a causal graph from cache. If causal graphs are created
   with this function, we build at most one causal graph per AbstractTask. */
extern const LegacyCausalGraph &get_causal_graph(const AbstractTask *task);
}

#endif
