
# Check for packages and if necessary install: 
pkgs <- c("lme4","multcomp","tramME","survival","lattice", "latticeExtra")
inst <- pkgs %in% installed.packages()
# Install CRAN packages (if not already installed)
if (any(!inst)) 
  install.packages(pkgs[!inst])
# Load packages into session
out <- sapply(pkgs, require, character.only = TRUE)     








## ===== From tramME-JSS manuscript
mpredict <- function(obj, newdata,
                     scale = c("distribution", "density", "survivor"),
                     ndraws = 500, antithetic = FALSE, return_draws = FALSE,
                     ncpus = 1L, ...) {
  scale <- match.arg(scale)
  if (antithetic) ndraws <- floor(ndraws / 2)
  re <- simulate(obj, type = "ranef", newdata = newdata, nsim = ndraws, ...)
  if (antithetic) re <- c(re, lapply(re, `-`))
  ndraws <- length(re)
  FUN <- function(r) {
    predict(obj, newdata = newdata, type = scale, ranef = r, ...)
  }
  if (ncpus > 1) pr <- parallel::mclapply(re, FUN, mc.cores = ncpus)
  else pr <- lapply(re, FUN)
  if (return_draws) return(pr)
  rns <- rownames(pr[[1]])
  cns <- colnames(pr[[1]])
  pr <- unlist(pr)
  d <- length(pr) / (nrow(newdata) * ndraws)
  pr <- array(pr, dim = c(d, nrow(newdata), ndraws))
  mp <- apply(pr, c(1, 2), mean)
  mcv <- apply(pr, c(1, 2), var) / ndraws
  if (antithetic) mcv <- mcv + apply(pr, c(1, 2), function(x) {
    cov(head(x, ndraws/2), tail(x, ndraws/2)) / (2*ndraws)
  })
  rownames(mp) <- rownames(mcv) <- rns
  colnames(mp) <- colnames(mcv) <- cns
  attr(mp, "mc.se") <- sqrt(mcv)
  mp
}
## ==========

# In this script, the data-analysis is slightly changed
# in order to revise the Silphid-Manuscript.

# in this version elevation will be included in the analysis
# to test all (biotic/abiotic) factors we measured, that 
# could affect silphinae diversity


load("carrion.Rda")

Elevation_kat <- as.factor(carrion$Elevation_kat)
de <- as.double(carrion$Elevation)


nd <- with(carrion, expand.grid(Season = unique(Season), 
                                de = unique(de)[1],
                                Day_since_Exposure = unique(Day_since_Exposure),
                                Block = unique(Block)[1],
                                ID_carcass = unique(ID_carcass)[1],
                                T_air_mean_C = 10,
                                Carcass_Mass_logkg = 1,
                                Abundance_of_logindividuals = 1))
nd


ps <- list(superpose.line = list(lty = 1, col = 1:4, lwd = 2))
ps





models <- expression({
  
  cm1 <- ColrME(cfm1, data = carrion, bounds = c(0, Inf), log_first = TRUE)
  cm2 <- ColrME(cfm2, data = carrion, bounds = c(0, Inf), log_first = TRUE)
  
  m01 <- Colr(mfm1, data = carrion, bounds = c(0, Inf), log_first = TRUE)
  m02 <- Colr(mfm2, data = carrion, bounds = c(0, Inf), log_first = TRUE)
  
  d <- mpredict(cm1, newdata = nd, q = qs)
  ndd <- expand.grid(q = qs, id = 1:nrow(nd))
  ndd <- cbind(ndd, nd[ndd$id,])
  ndd$prb <- c(d)
  
  print(xyplot(prb ~ q | Season, 
               data = ndd, type = "S", groups = Day_since_Exposure, 
               xlab = xlab, ylab = "Model-based CDF",
               auto.key = list(columns = 4),
               par.settings = ps))
  
})


### Species number
carrion$SP <- with(carrion, Surv(time = Species_number, 
                                 time2 = carrion$Species_number + 1,
                                 type = "interval2"))

cfm1 <- SP ~ Season * (Day_since_Exposure +  T_air_mean_C + Carcass_Mass_logkg + Abundance_of_logindividuals + de) +
  (1 | Block / ID_carcass) 
cfm2 <- SP ~ Season * (Day_since_Exposure +  T_air_mean_C + Carcass_Species + Abundance_of_logindividuals + de) +
  (1 | Block / ID_carcass) 
mfm1 <- SP ~ Season * (Day_since_Exposure +  T_air_mean_C + Carcass_Mass_logkg + Abundance_of_logindividuals + de) + Block 
mfm2 <- SP ~ Season * (Day_since_Exposure +  T_air_mean_C + Carcass_Species + Abundance_of_logindividuals + de) + Block 

xlab <- "Species number"

ecdfplot(~ Species_number | Season, data = carrion, 
         xlab = xlab,
         groups = Day_since_Exposure, auto.key = list(columns = 4),
         par.settings = ps)

qs <- as.double(0:max(carrion$Species_number))
eval(models)


logLik(cm1)
logLik(cm2)

summary(cm1)
summary(cm2)


SPcm1 <- summary(cm1)
coSPcm1 <- SPcm1$coef
dfSPcm1 <- data.frame(coSPcm1)
# write tableergebnisstabelle
write.csv2(dfSPcm1, file = "Species_Richness_carmass.csv")

SPcm2 <- summary(cm2)
coSPcm2 <- SPcm2$coef
dfSPcm2 <- data.frame(coSPcm2)
write.csv2(dfSPcm2, file = "Species_Richness_carspec.csv")

### Abundance of individuals
carrion$AI <- with(carrion, Surv(time = Abundance_of_individuals, 
                                 time2 = Abundance_of_individuals +1, 
                                 type = "interval2"))
cfm1 <- AI ~ Season * (Day_since_Exposure +  T_air_mean_C + Carcass_Mass_logkg+ de) + 
  (1 | Block / ID_carcass) 
cfm2 <- AI ~ Season * (Day_since_Exposure +  T_air_mean_C + Carcass_Species+ de) + 
  (1 | Block / ID_carcass) 
mfm1 <- AI ~ Season * (Day_since_Exposure +  T_air_mean_C + Carcass_Mass_logkg+ de) + Block
mfm2 <- AI ~ Season * (Day_since_Exposure +  T_air_mean_C + Carcass_Species+ de) + Block
xlab <- "Abundance of individuals"

ecdfplot(~ Abundance_of_individuals | Season, data = carrion, 
         xlab = xlab,
         groups = Day_since_Exposure, auto.key = list(columns = 4),
         par.settings = ps)
qs <- as.double(0:max(carrion$Abundance_of_individuals))
eval(models)

logLik(cm1)
logLik(cm2)

summary(cm1)
summary(cm2)

AIcm1 <- summary(cm1)
coAIcm1 <- AIcm1$coef
dfAIcm1 <- data.frame(coAIcm1)
write.csv2(dfAIcm1, file = "Abundance_Individuals_carmass.csv")

AIcm2 <- summary(cm2)
coAIcm2 <- AIcm2$coef
dfAIcm2 <- data.frame(coAIcm2)
write.csv2(dfAIcm2, file = "Abundance_Individuals_carspec.csv")

### Oiceoptoma_thoracicum
carrion$OT <- with(carrion, Surv(time = Oiceoptoma_thoracicum, 
                                 time2 = Oiceoptoma_thoracicum + 1, 
                                 type = "interval2"))

cfm1[[2]] <- cfm2[[2]] <- mfm1[[2]] <- mfm2[[2]] <- as.name("OT")
xlab <- "Abundance Oiceoptoma thoracicum"

ecdfplot(~ Oiceoptoma_thoracicum | Season, data = carrion, 
         xlab = xlab,
         groups = Day_since_Exposure, auto.key = list(columns = 4),
         par.settings = ps)

qs <- as.double(0:max(carrion$Oiceoptoma_thoracicum, na.rm = TRUE))
eval(models)


logLik(cm1)
logLik(cm2)

summary(cm1)
summary(cm2)

OTcm1 <- summary(cm1)
coOTcm1 <- OTcm1$coef
dfOTcm1 <- data.frame(coOTcm1)
write.csv2(dfOTcm1, file = "OT_carmass.csv")

OTcm2 <- summary(cm2)
coOTcm2 <- OTcm2$coef
dfOTcm2 <- data.frame(coOTcm2)
write.csv2(dfOTcm2, file = "OT_carspec.csv")


### Necrodes littoralis:
carrion$NL <- with(carrion, Surv(time = Necrodes_littoralis, 
                                 time2 = Necrodes_littoralis + 1, 
                                 type = "interval2"))

cfm1[[2]] <- cfm2[[2]] <- mfm1[[2]] <- mfm2[[2]] <- as.name("NL")
xlab <- "Abundance Necrodes littoralis"

ecdfplot(~ Necrodes_littoralis | Season, data = carrion, 
         xlab = xlab,
         groups = Day_since_Exposure, auto.key = list(columns = 4),
         par.settings = ps)
qs <- as.double(0:max(carrion$Necrodes_littoralis, na.rm = TRUE))
eval(models)


logLik(cm1)
logLik(cm2)

summary(cm1)
summary(cm2)

NLcm1 <- summary(cm1)
coNLcm1 <- NLcm1$coef
dfNLcm1 <- data.frame(coNLcm1)
write.csv2(dfNLcm1, file = "NL_carmass.csv")

NLcm2 <- summary(cm2)
coNLcm2 <- NLcm2$coef
dfNLcm2 <- data.frame(coNLcm2)
write.csv2(dfNLcm2, file = "NL_carspec.csv")


### Thanatophilus sinuatus:
carrion$TS <- with(carrion, Surv(time = Thanatophilus_sinuatus, 
                                 time2 = Thanatophilus_sinuatus + 1, 
                                 type = "interval2"))

cfm1[[2]] <- cfm2[[2]] <- mfm1[[2]] <- mfm2[[2]] <- as.name("TS")
xlab <- "Abundance Thanatophilus sinuatus"

ecdfplot(~ Thanatophilus_sinuatus | Season, data = carrion, 
         xlab = xlab,
         groups = Day_since_Exposure, auto.key = list(columns = 4),
         par.settings = ps)
qs <- as.double(0:max(carrion$Thanatophilus_sinuatus, na.rm = TRUE))
eval(models)


logLik(cm1)
logLik(cm2)

summary(cm1)
summary(cm2)

TScm1 <- summary(cm1)
coTScm1 <- TScm1$coef
dfTScm1 <- data.frame(coTScm1)
write.csv2(dfTScm1, file = "TS_carmass.csv")

TScm2 <- summary(cm2)
coTScm2 <- TScm2$coef
dfTScm2 <- data.frame(coTScm2)
write.csv2(dfTScm2, file = "TS_carspec.csv")


### Thanatophilus rugosus:
carrion$TR <- with(carrion, Surv(time = Thanatophilus_rugosus, 
                                 time2 = Thanatophilus_rugosus + 1, 
                                 type = "interval2"))

cfm1[[2]] <- cfm2[[2]] <- mfm1[[2]] <- mfm2[[2]] <- as.name("TR")
xlab <- "Abundance Thanatophilus rugosus"

ecdfplot(~ Thanatophilus_rugosus | Season, data = carrion, 
         xlab = xlab,
         groups = Day_since_Exposure, auto.key = list(columns = 4),
         par.settings = ps)

qs <- as.double(0:max(carrion$Thanatophilus_rugosus, na.rm = TRUE))
eval(models)


logLik(cm1)
logLik(cm2)

summary(cm1)
summary(cm2)

TRcm1 <- summary(cm1)
coTRcm1 <- TRcm1$coef
dfTRcm1 <- data.frame(coTRcm1)
write.csv2(dfTRcm1, file = "TR_carmass.csv")

TRcm2 <- summary(cm2)
coTRcm2 <- TRcm2$coef
dfTRcm2 <- data.frame(coTRcm2)
write.csv2(dfTRcm2, file = "TR_carspec.csv")


### Nicrophorus vespilloides:
carrion$NV <- with(carrion, Surv(time = Nicrophorus_vespilloides, 
                                 time2 = Nicrophorus_vespilloides + 1, 
                                 type = "interval2"))

cfm1[[2]] <- cfm2[[2]] <- mfm1[[2]] <- mfm2[[2]] <- as.name("NV")
xlab <- "Abundance Nicrophorus vespilloides"

ecdfplot(~ Nicrophorus_vespilloides | Season, data = carrion, 
         xlab = xlab,
         groups = Day_since_Exposure, auto.key = list(columns = 4),
         par.settings = ps)

qs <- as.double(0:max(carrion$Nicrophorus_vespilloides, na.rm = TRUE))
eval(models)


logLik(cm1)
logLik(cm2)

summary(cm1)
summary(cm2)

NVcm1 <- summary(cm1)
coNVcm1 <- NVcm1$coef
dfNVcm1 <- data.frame(coNVcm1)
write.csv2(dfNVcm1, file = "NV_carmass.csv")

NVcm2 <- summary(cm2)
coNVcm2 <- NVcm2$coef
dfNVcm2 <- data.frame(coNVcm2)
write.csv2(dfNVcm2, file = "NV_carspec.csv")