
# Check for packages and if necessary install: 
pkgs <- c("lme4","multcomp","tramME","survival","lattice", "latticeExtra")
inst <- pkgs %in% installed.packages()
# Install CRAN packages (if not already installed)
if (any(!inst)) 
    install.packages(pkgs[!inst])
# Load packages into session
out <- sapply(pkgs, require, character.only = TRUE)     

## ===== From tramME-JSS manuscript
mpredict <- function(obj, newdata,
  scale = c("distribution", "density", "survivor"),
  ndraws = 500, antithetic = FALSE, return_draws = FALSE,
  ncpus = 1L, ...) {
  scale <- match.arg(scale)
  if (antithetic) ndraws <- floor(ndraws / 2)
  re <- simulate(obj, type = "ranef", newdata = newdata, nsim = ndraws, ...)
  if (antithetic) re <- c(re, lapply(re, `-`))
  ndraws <- length(re)
  FUN <- function(r) {
    predict(obj, newdata = newdata, type = scale, ranef = r, ...)
  }
  if (ncpus > 1) pr <- parallel::mclapply(re, FUN, mc.cores = ncpus)
  else pr <- lapply(re, FUN)
  if (return_draws) return(pr)
  rns <- rownames(pr[[1]])
  cns <- colnames(pr[[1]])
  pr <- unlist(pr)
  d <- length(pr) / (nrow(newdata) * ndraws)
  pr <- array(pr, dim = c(d, nrow(newdata), ndraws))
  mp <- apply(pr, c(1, 2), mean)
  mcv <- apply(pr, c(1, 2), var) / ndraws
  if (antithetic) mcv <- mcv + apply(pr, c(1, 2), function(x) {
    cov(head(x, ndraws/2), tail(x, ndraws/2)) / (2*ndraws)
  })
  rownames(mp) <- rownames(mcv) <- rns
  colnames(mp) <- colnames(mcv) <- cns
  attr(mp, "mc.se") <- sqrt(mcv)
  mp
}
## ==========


load("../data/carrion.Rda")

nd <- with(carrion, expand.grid(Season = unique(Season), 
                                Day_since_Exposure = unique(Day_since_Exposure),
                                Block = unique(Block)[1],
                                ID_carcass = unique(ID_carcass)[1],
                                T_air_mean_C = 10,
                                Carcass_Mass_logkg = 1,
                                Abundance_of_logindividuals = 1))

ps <- list(superpose.line = list(lty = 1, col = 1:4, lwd = 2))


models <- expression({

  cm1 <- ColrME(cfm1, data = carrion, bounds = c(0, Inf), log_first = TRUE)
  cm2 <- ColrME(cfm2, data = carrion, bounds = c(0, Inf), log_first = TRUE)

  m01 <- Colr(mfm1, data = carrion, bounds = c(0, Inf), log_first = TRUE)
  m02 <- Colr(mfm2, data = carrion, bounds = c(0, Inf), log_first = TRUE)

#  mm1 <- mtram(m01, formula = ~ (1 | ID_carcass), data = carrion, Hessian = TRUE)
#  mm2 <- mtram(m02, formula = ~ (1 | ID_carcass), data = carrion, Hessian = TRUE)

  d <- mpredict(cm1, newdata = nd, q = qs)
  ndd <- expand.grid(q = qs, id = 1:nrow(nd))
  ndd <- cbind(ndd, nd[ndd$id,])
  ndd$prb <- c(d)

  print(xyplot(prb ~ q | Season, 
         data = ndd, type = "S", groups = Day_since_Exposure, 
         xlab = xlab, ylab = "Model-based CDF",
         auto.key = list(columns = 4),
         par.settings = ps))

#  m01 <- as.mlt(m01)
#  cf <- coef(mm1)
#  coef(m01) <- cf[names(coef(m01))] / sqrt(1 + cf["gamma1"]^2)
#  ndd$prb2 <- c(predict(m01, newdata = nd, q = qs, type = "distribution"))
#
#  print(xyplot(prb2 ~ q | Season, 
#         data = ndd, type = "S", groups = Day_since_Exposure, 
#         xlab = xlab,
#         auto.key = list(columns = 4),
#         par.settings = ps))
})


### Species number
carrion$SP <- with(carrion, Surv(time = Species_number, 
                                 time2 = carrion$Species_number + 1,
                                 type = "interval2"))

cfm1 <- SP ~ Season * (Day_since_Exposure +  T_air_mean_C + Carcass_Mass_logkg + Abundance_of_logindividuals) +
             (1 | Block / ID_carcass) 
cfm2 <- SP ~ Season * (Day_since_Exposure +  T_air_mean_C + Carcass_Species + Abundance_of_logindividuals) +
             (1 | Block / ID_carcass) 
mfm1 <- SP ~ Season * (Day_since_Exposure +  T_air_mean_C + Carcass_Mass_logkg + Abundance_of_logindividuals) + Block
mfm2 <- SP ~ Season * (Day_since_Exposure +  T_air_mean_C + Carcass_Species + Abundance_of_logindividuals) + Block

xlab <- "Species number"

ecdfplot(~ Species_number | Season, data = carrion, 
         xlab = xlab,
         groups = Day_since_Exposure, auto.key = list(columns = 4),
         par.settings = ps)

qs <- as.double(0:max(carrion$Species_number))
eval(models)


  logLik(cm1)
  logLik(cm2)
#  logLik(mm1)
#  logLik(mm2)

  summary(cm1)
  summary(cm2)

#try(  cftest(mm1))
#try(  cftest(mm2))

### Abundance of individuals
carrion$AI <- with(carrion, Surv(time = Abundance_of_individuals, 
                                 time2 = Abundance_of_individuals +1, 
                                 type = "interval2"))
cfm1 <- AI ~ Season * (Day_since_Exposure +  T_air_mean_C + Carcass_Mass_logkg) + 
             (1 | Block / ID_carcass) 
cfm2 <- AI ~ Season * (Day_since_Exposure +  T_air_mean_C + Carcass_Species) + 
             (1 | Block / ID_carcass) 
mfm1 <- AI ~ Season * (Day_since_Exposure +  T_air_mean_C + Carcass_Mass_logkg) + Block
mfm2 <- AI ~ Season * (Day_since_Exposure +  T_air_mean_C + Carcass_Species) + Block
xlab <- "Abundance of individuals"

ecdfplot(~ Abundance_of_individuals | Season, data = carrion, 
         xlab = xlab,
         groups = Day_since_Exposure, auto.key = list(columns = 4),
         par.settings = ps)
qs <- as.double(0:max(carrion$Abundance_of_individuals))
eval(models)

  logLik(cm1)
  logLik(cm2)
#  logLik(mm1)
#  logLik(mm2)

  summary(cm1)
  summary(cm2)

#try(  cftest(mm1))
#try(  cftest(mm2))

### Oiceoptoma_thoracicum
carrion$OT <- with(carrion, Surv(time = Oiceoptoma_thoracicum, 
                                 time2 = Oiceoptoma_thoracicum + 1, 
                                 type = "interval2"))

cfm1[[2]] <- cfm2[[2]] <- mfm1[[2]] <- mfm2[[2]] <- as.name("OT")
xlab <- "Abundance Oiceoptoma thoracicum"

ecdfplot(~ Oiceoptoma_thoracicum | Season, data = carrion, 
         xlab = xlab,
         groups = Day_since_Exposure, auto.key = list(columns = 4),
         par.settings = ps)

qs <- as.double(0:max(carrion$Oiceoptoma_thoracicum, na.rm = TRUE))
eval(models)


  logLik(cm1)
  logLik(cm2)
#  logLik(mm1)
#  logLik(mm2)

  summary(cm1)
  summary(cm2)

#try(  cftest(mm1))
#try(  cftest(mm2))


### Necrodes littoralis:
carrion$NL <- with(carrion, Surv(time = Necrodes_littoralis, 
                                 time2 = Necrodes_littoralis + 1, 
                                 type = "interval2"))

cfm1[[2]] <- cfm2[[2]] <- mfm1[[2]] <- mfm2[[2]] <- as.name("NL")
xlab <- "Abundance Necrodes littoralis"

ecdfplot(~ Necrodes_littoralis | Season, data = carrion, 
         xlab = xlab,
         groups = Day_since_Exposure, auto.key = list(columns = 4),
         par.settings = ps)
qs <- as.double(0:max(carrion$Necrodes_littoralis, na.rm = TRUE))
eval(models)


  logLik(cm1)
  logLik(cm2)
#  logLik(mm1)
#  logLik(mm2)

  summary(cm1)
  summary(cm2)

#try(  cftest(mm1))
#try(  cftest(mm2))


### Thanatophilus sinuatus:
carrion$TS <- with(carrion, Surv(time = Thanatophilus_sinuatus, 
                                 time2 = Thanatophilus_sinuatus + 1, 
                                 type = "interval2"))

cfm1[[2]] <- cfm2[[2]] <- mfm1[[2]] <- mfm2[[2]] <- as.name("TS")
xlab <- "Abundance Thanatophilus sinuatus"

ecdfplot(~ Thanatophilus_sinuatus | Season, data = carrion, 
         xlab = xlab,
         groups = Day_since_Exposure, auto.key = list(columns = 4),
         par.settings = ps)
qs <- as.double(0:max(carrion$Thanatophilus_sinuatus, na.rm = TRUE))
eval(models)


  logLik(cm1)
  logLik(cm2)
#  logLik(mm1)
#  logLik(mm2)

  summary(cm1)
  summary(cm2)

#try(  cftest(mm1))
#try(  cftest(mm2))


### Thanatophilus rugosus:
carrion$TR <- with(carrion, Surv(time = Thanatophilus_rugosus, 
                                 time2 = Thanatophilus_rugosus + 1, 
                                 type = "interval2"))

cfm1[[2]] <- cfm2[[2]] <- mfm1[[2]] <- mfm2[[2]] <- as.name("TR")
xlab <- "Abundance Thanatophilus rugosus"

ecdfplot(~ Thanatophilus_rugosus | Season, data = carrion, 
         xlab = xlab,
         groups = Day_since_Exposure, auto.key = list(columns = 4),
         par.settings = ps)

qs <- as.double(0:max(carrion$Thanatophilus_rugosus, na.rm = TRUE))
eval(models)


  logLik(cm1)
  logLik(cm2)
#  logLik(mm1)
#  logLik(mm2)

  summary(cm1)
  summary(cm2)

#try(  cftest(mm1))
#try(  cftest(mm2))


### Nicrophorus vespilloides:
carrion$NV <- with(carrion, Surv(time = Nicrophorus_vespilloides, 
                                 time2 = Nicrophorus_vespilloides + 1, 
                                 type = "interval2"))

cfm1[[2]] <- cfm2[[2]] <- mfm1[[2]] <- mfm2[[2]] <- as.name("NV")
xlab <- "Abundance Nicrophorus vespilloides"

ecdfplot(~ Nicrophorus_vespilloides | Season, data = carrion, 
         xlab = xlab,
         groups = Day_since_Exposure, auto.key = list(columns = 4),
         par.settings = ps)


qs <- as.double(0:max(carrion$Nicrophorus_vespilloides, na.rm = TRUE))
eval(models)


  logLik(cm1)
  logLik(cm2)
#  logLik(mm1)
#  logLik(mm2)

  summary(cm1)
  summary(cm2)

#try(  cftest(mm1))
#try(  cftest(mm2))

