---
comments: true
description: Discover how to manage and collaborate with team members using Ultralytics HUB Teams. Learn to create, edit, and share resources efficiently.
keywords: Ultralytics HUB, Teams, collaboration, team management, AI projects, resource sharing, Pro Plan, data sharing, project management
---

# Ultralytics HUB Teams

We're excited to introduce you to the new Teams feature within [Ultralytics HUB](https://ultralytics.com/hub) for our [Pro](./pro.md) users!

Here, you'll learn how to manage team members, share resources seamlessly, and collaborate efficiently on various projects.

!!! note "Note"

    As this is a new feature, we're still in the process of developing and refining it to ensure it meets your needs.

## Create Team

!!! note "Note"

    You need to [upgrade](./pro.md#upgrade) to the [Pro Plan](./pro.md) in order to create a team.

    ![Ultralytics HUB screenshot of the Settings page Teams tab with an arrow pointing to the Upgrade button](https://raw.githubusercontent.com/ultralytics/assets/main/docs/hub/teams/hub_create_team_1.jpg)

Navigate to the [Teams](https://hub.ultralytics.com/settings?tab=teams) page by clicking on the **Teams** tab in the [Settings](https://hub.ultralytics.com/settings) page and click on the **Create Team** button.

![Ultralytics HUB screenshot of the Teams page with an arrow pointing to the Create Team button](https://raw.githubusercontent.com/ultralytics/assets/main/docs/hub/teams/hub_create_team_2.jpg)

This action will trigger the **Create Team** dialog.

Type the name of your team in the _Team name_ field or keep the default name and finalize the team creation with a single click.

You have the additional option to enrich your team with a description and a unique image, enhancing its recognizability on the [Teams](https://hub.ultralytics.com/settings?tab=teams) page.

When you're happy with your team configuration, click **Create**.

![Ultralytics HUB screenshot of the Create Team dialog with an arrow pointing to the Create button](https://raw.githubusercontent.com/ultralytics/assets/main/docs/hub/teams/hub_create_team_3.jpg)

After your team is created, you will be able to access it from the [Teams](https://hub.ultralytics.com/settings?tab=teams) page.

![Ultralytics HUB screenshot of the Teams page with an arrow pointing to one of the teams](https://raw.githubusercontent.com/ultralytics/assets/main/docs/hub/teams/hub_create_team_4.jpg)

## Edit Team

Navigate to the [Teams](https://hub.ultralytics.com/settings?tab=teams) page, open the team actions dropdown of team you want to edit and click on the **Edit** option. This action will trigger the **Update Team** dialog.

![Ultralytics HUB screenshot of the Teams page with an arrow pointing to the Edit option of one of the teams](https://raw.githubusercontent.com/ultralytics/assets/main/docs/hub/teams/hub_edit_team_1.jpg)

Apply the desired modifications to your team and then confirm the changes by clicking **Save**.

![Ultralytics HUB screenshot of the Update Team dialog with an arrow pointing to the Save button](https://raw.githubusercontent.com/ultralytics/assets/main/docs/hub/teams/hub_edit_team_2.jpg)

## Delete Team

Navigate to the [Teams](https://hub.ultralytics.com/settings?tab=teams) page, open the team actions dropdown of team you want to delete and click on the **Delete** option.

![Ultralytics HUB screenshot of the Teams page with an arrow pointing to the Delete option of one of the teams](https://raw.githubusercontent.com/ultralytics/assets/main/docs/hub/teams/hub_delete_team_1.jpg)

!!! Warning "Warning"

    When deleting a team, the team can't be restored.

## Invite Member

Navigate to the Team page of the team to which you want to add a new member and click on the **Invite Member** button. This action will trigger the **Invite Member** dialog.

![Ultralytics HUB screenshot of the Team page with an arrow pointing to the Invite Member button](https://raw.githubusercontent.com/ultralytics/assets/main/docs/hub/teams/hub_invite_member_1.jpg)

Type the email and select the role of the new member and click **Invite**.

![Ultralytics HUB screenshot of the Invite Member dialog with an arrow pointing to the Invite button](https://raw.githubusercontent.com/ultralytics/assets/main/docs/hub/teams/hub_invite_member_2.jpg)

![Ultralytics HUB screenshot of the Team page with a new member invited](https://raw.githubusercontent.com/ultralytics/assets/main/docs/hub/teams/hub_invite_member_3.jpg)

??? tip "Tip"

    You can cancel the invite before the new member accepts it.

    ![Ultralytics HUB screenshot of the Team page with an arrow pointing to the Cancel Invite option of one of the members](https://raw.githubusercontent.com/ultralytics/assets/main/docs/hub/teams/hub_invite_member_4.jpg)

The **Pending** status disappears after the new member accepts the invite.

![Ultralytics HUB screenshot of the Team page with two members](https://raw.githubusercontent.com/ultralytics/assets/main/docs/hub/teams/hub_invite_member_5.jpg)

??? tip "Tip"

    You can update a member's role at any time.

    The **Admin** role allows inviting and removing members, as well as removing shared datasets or projects.

    ![Ultralytics HUB screenshot of the Team page with an arrow pointing to the Change Role option of one of the members](https://raw.githubusercontent.com/ultralytics/assets/main/docs/hub/teams/hub_invite_member_6.jpg)

### Seats

The [Pro Plan](./pro.md) offers one free seat _(yours)_.

When a new unique member joins one of your teams, the number of seats increases, and you will be charged **$20 per month** for each seat, or **$200 per year** if you choose the annual plan.

Each unique member counts as one seat, regardless of how many teams they are in. For example, if John Doe is a member of 5 of your teams, he is using one seat.

When you remove a unique member from the last team they are a member of, the number of seats decreases. The charge is prorated and can be applied to adding other unique members, paying for the [Pro Plan](./pro.md), or topping up your [account balance](./pro.md#account-balance).

You can see the number of seats on the [Teams](https://hub.ultralytics.com/settings?tab=teams) page.

![Ultralytics HUB screenshot of the Teams page with an arrow pointing to the number of seats](https://raw.githubusercontent.com/ultralytics/assets/main/docs/hub/teams/hub_invite_member_7.jpg)

## Remove Member

Navigate to the Team page of the team from which you want to remove a member, open the member actions dropdown, and click on the **Remove** option.

![Ultralytics HUB screenshot of the Team page with an arrow pointing to the Remove option of one of the members](https://raw.githubusercontent.com/ultralytics/assets/main/docs/hub/teams/hub_remove_member_1.jpg)

## Join Team

When you are invited to a team, you receive an in-app notification.

You can view your notifications by clicking on the **View** button on the **Notifications** card on the [Home](https://hub.ultralytics.com/home) page.

![Ultralytics HUB screenshot of the Home page with an arrow pointing to the View button on the Notifications card](https://raw.githubusercontent.com/ultralytics/assets/main/docs/hub/teams/hub_join_team_1.jpg)

Alternatively, you can view your notifications by accessing the [Notifications](https://hub.ultralytics.com/notifications) page directly.

![Ultralytics HUB screenshot of the Notifications page with an arrow pointing to one of the notifications](https://raw.githubusercontent.com/ultralytics/assets/main/docs/hub/teams/hub_join_team_2.jpg)

You can decide whether to join the team on the Team page of the team to which you were invited.

If you want to join the team, click on the **Join Team** button.

![Ultralytics HUB screenshot of the Team page with an arrow pointing to the Join Team button](https://raw.githubusercontent.com/ultralytics/assets/main/docs/hub/teams/hub_join_team_3.jpg)

If you don't want to join the team, click on the **Reject Invitation** button.

![Ultralytics HUB screenshot of the Team page with an arrow pointing to the Reject Invitation button](https://raw.githubusercontent.com/ultralytics/assets/main/docs/hub/teams/hub_join_team_4.jpg)

??? tip "Tip"

    You can join the team directly from the [Teams](https://hub.ultralytics.com/settings?tab=teams) page.

    ![Ultralytics HUB screenshot of the Teams page with an arrow pointing to the Join Team button of one of the teams](https://raw.githubusercontent.com/ultralytics/assets/main/docs/hub/teams/hub_join_team_5.jpg)

## Leave Team

Navigate to the Team page of the team you want to leave and click on the **Leave Team** button.

![Ultralytics HUB screenshot of the Team page with an arrow pointing to the Leave Team button](https://raw.githubusercontent.com/ultralytics/assets/main/docs/hub/teams/hub_leave_team_1.jpg)

## Share Dataset

Navigate to the Team page of the team you want to share your dataset with and click on the **Add Dataset** button.

![Ultralytics HUB screenshot of the Team page with an arrow pointing to the Add Dataset button](https://raw.githubusercontent.com/ultralytics/assets/main/docs/hub/teams/hub_share_dataset_1.jpg)

Select the dataset you want to share with your team and click on the **Add** button.

![Ultralytics HUB screenshot of the Add Dataset to Team dialog with an arrow pointing to the Add button](https://raw.githubusercontent.com/ultralytics/assets/main/docs/hub/teams/hub_share_dataset_2.jpg)

That's it! Your team now has access to your dataset.

![Ultralytics HUB screenshot of the Team page with a dataset shared](https://raw.githubusercontent.com/ultralytics/assets/main/docs/hub/teams/hub_share_dataset_3.jpg)

??? tip "Tip"

    As a team owner or team admin, you can remove a shared dataset.

    ![Ultralytics HUB screenshot of the Team page with an arrow pointing to the Remove option of one of the datasets shared](https://raw.githubusercontent.com/ultralytics/assets/main/docs/hub/teams/hub_share_dataset_4.jpg)

## Share Project

Navigate to the Team page of the team you want to share your project with and click on the **Add Project** button.

![Ultralytics HUB screenshot of the Team page with an arrow pointing to the Add Project button](https://raw.githubusercontent.com/ultralytics/assets/main/docs/hub/teams/hub_share_project_1.jpg)

Select the project you want to share with your team and click on the **Add** button.

![Ultralytics HUB screenshot of the Add Project to Team dialog with an arrow pointing to the Add button](https://raw.githubusercontent.com/ultralytics/assets/main/docs/hub/teams/hub_share_project_2.jpg)

That's it! Your team now has access to your project.

![Ultralytics HUB screenshot of the Team page with a project shared](https://raw.githubusercontent.com/ultralytics/assets/main/docs/hub/teams/hub_share_project_3.jpg)

??? tip "Tip"

    As a team owner or team admin, you can remove a shared project.

    ![Ultralytics HUB screenshot of the Team page with an arrow pointing to the Remove option of one of the projects shared](https://raw.githubusercontent.com/ultralytics/assets/main/docs/hub/teams/hub_share_project_4.jpg)

!!! note "Note"

    When you share a project with your team, all models inside the project are shared as well.

    ![Ultralytics HUB screenshot of the Team page with a model shared](https://raw.githubusercontent.com/ultralytics/assets/main/docs/hub/teams/hub_share_project_5.jpg)
