---
comments: true
description: Get started with Ultralytics HUB! Learn to upload datasets, train YOLO models, and manage projects easily with our user-friendly platform.
keywords: Ultralytics HUB, Quickstart, YOLO models, dataset upload, project management, train models, machine learning
---

# Ultralytics HUB Quickstart

[Ultralytics HUB](https://ultralytics.com/hub) is designed to be user-friendly and intuitive, allowing users to quickly upload their datasets and train new YOLO models. It also offers a range of pre-trained models to choose from, making it extremely easy for users to get started. Once a model is trained, it can be effortlessly previewed in the [Ultralytics HUB App](app/index.md) before being deployed for real-time classification, object detection, and instance segmentation tasks.

<p align="center">
  <iframe loading="lazy" width="720" height="405" src="https://www.youtube.com/embed/lveF9iCMIzc?si=_Q4WB5kMB5qNe7q6"
    title="YouTube video player" frameborder="0"
    allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
    allowfullscreen>
  </iframe>
  <br>
  <strong>Watch:</strong> Train Your Custom YOLO Models In A Few Clicks with Ultralytics HUB
</p>

## Get Started

[Ultralytics HUB](https://ultralytics.com/hub) offers a variety easy of signup options. You can register and log in using your Google, Apple, or GitHub accounts, or simply with your email address.

![Ultralytics HUB screenshot of the Signup page](https://raw.githubusercontent.com/ultralytics/assets/main/docs/hub/quickstart/hub_get_started_1.jpg)

During the signup, you will be asked to complete your profile.

![Ultralytics HUB screenshot of the Signup page profile form](https://raw.githubusercontent.com/ultralytics/assets/main/docs/hub/quickstart/hub_get_started_2.jpg)

??? tip "Tip"

    You can update your profile from the [Account](https://hub.ultralytics.com/settings?tab=account) tab on the [Settings](https://hub.ultralytics.com/settings) page.

    ![Ultralytics HUB screenshot of the Settings page Account tab with an arrow pointing to the Profile card](https://raw.githubusercontent.com/ultralytics/assets/main/docs/hub/quickstart/hub_get_started_3.jpg)

## Home

After signing in, you will be directed to the [Home](https://hub.ultralytics.com/home) page of [Ultralytics HUB](https://ultralytics.com/hub), which provides a comprehensive overview, quick links, and updates.

The sidebar conveniently offers links to important modules of the platform, such as [Datasets](https://hub.ultralytics.com/datasets), [Projects](https://hub.ultralytics.com/projects), and [Models](https://hub.ultralytics.com/models).

![Ultralytics HUB screenshot of the Home page](https://raw.githubusercontent.com/ultralytics/assets/main/docs/hub/quickstart/hub_home.jpg)

### Recent

You can easily search globally or directly access your last updated [Datasets](https://hub.ultralytics.com/datasets), [Projects](https://hub.ultralytics.com/projects), or [Models](https://hub.ultralytics.com/models) using the Recent card on the [Home](https://hub.ultralytics.com/home) page.

![Ultralytics HUB screenshot of the Home page with an arrow pointing to the Recent card](https://raw.githubusercontent.com/ultralytics/assets/main/docs/hub/quickstart/hub_recent.jpg)

### Upload Dataset

You can upload a dataset directly from the [Home](https://hub.ultralytics.com/home) page.

![Ultralytics HUB screenshot of the Home page with an arrow pointing to the Upload Dataset card](https://raw.githubusercontent.com/ultralytics/assets/main/docs/hub/datasets/hub_upload_dataset_1.jpg)

Read more about [datasets](https://docs.ultralytics.com/hub/datasets).

### Create Project

You can create a project directly from the [Home](https://hub.ultralytics.com/home) page.

![Ultralytics HUB screenshot of the Home page with an arrow pointing to the Create Project card](https://raw.githubusercontent.com/ultralytics/assets/main/docs/hub/projects/hub_create_project_1.jpg)

Read more about [projects](https://docs.ultralytics.com/hub/projects).

### Train Model

You can train a model directly from the [Home](https://hub.ultralytics.com/home) page.

![Ultralytics HUB screenshot of the Home page with an arrow pointing to the Train Model card](https://raw.githubusercontent.com/ultralytics/assets/main/docs/hub/models/hub_train_model_1.jpg)

Read more about [models](https://docs.ultralytics.com/hub/models).

## Feedback

We value your feedback! Feel free to leave a review at any time.

![Ultralytics HUB screenshot of the Home page with an arrow pointing to the Feedback button](https://raw.githubusercontent.com/ultralytics/assets/main/docs/hub/quickstart/hub_feedback_1.jpg)

![Ultralytics HUB screenshot of the Feedback dialog](https://raw.githubusercontent.com/ultralytics/assets/main/docs/hub/quickstart/hub_feedback_2.jpg)

??? info "Info"

    Only our team will see your feedback, and we will use it to improve our platform.

## Need Help?

If you encounter any issues or have questions, we're here to assist you.

You can report a bug, request a feature, or ask a question on <a href="https://github.com/ultralytics/hub/issues/new/choose">GitHub</a>.

!!! note "Note"

    When reporting a bug, please include your Environment Details from the [Support](https://hub.ultralytics.com/support) page.

    ![Ultralytics HUB screenshot of the Support page with an arrow pointing to Support button in the sidebar and one to the Copy Environment Details button](https://raw.githubusercontent.com/ultralytics/assets/main/docs/hub/quickstart/hub_support.jpg)

??? tip "Tip"

    You can join our <a href="https://ultralytics.com/discord">Discord</a> community for questions and discussions!
