---
comments: true
description: Discover the enhanced features of Ultralytics HUB Pro Plan including 200GB storage, cloud training, and more. Learn how to upgrade and manage your account balance.
keywords: Ultralytics HUB, Pro Plan, upgrade guide, cloud training, storage, inference API, team collaboration, account balance
---

# Ultralytics HUB Pro

[Ultralytics HUB](https://ultralytics.com/hub) offers the Pro Plan as a monthly or annual subscription.

The Pro Plan provides early access to upcoming features and includes enhanced benefits:

- 200GB of storage, compared to the standard 20GB.
- Access to our [Cloud Training](./cloud-training.md).
- Increased rate limits for our [Inference API](./inference-api.md).
- Collaboration features for [teams](./teams.md).

## Upgrade

You can upgrade to the Pro Plan from the [Billing & License](https://hub.ultralytics.com/settings?tab=billing) tab on the [Settings](https://hub.ultralytics.com/settings) page by clicking on the **Upgrade** button.

![Ultralytics HUB screenshot of the Settings page Billing & License tab with an arrow pointing to the Upgrade button](https://raw.githubusercontent.com/ultralytics/assets/main/docs/hub/pro/hub_pro_upgrade_1.jpg)

Next, select the Pro Plan.

![Ultralytics HUB screenshot of the Upgrade dialog with an arrow pointing to the Select Plan button](https://raw.githubusercontent.com/ultralytics/assets/main/docs/hub/pro/hub_pro_upgrade_2.jpg)

!!! tip "Tip"

    You can save 20% if you choose the annual Pro Plan.

    ![Ultralytics HUB screenshot of the Upgrade dialog with an arrow pointing to the Save 20% toggle and one to the Select Plan button](https://raw.githubusercontent.com/ultralytics/assets/main/docs/hub/pro/hub_pro_upgrade_3.jpg)

Fill in your details during the checkout.

![Ultralytics HUB screenshot of the Checkout with an arrow pointing to the checkbox for saving the payment information for future purchases](https://raw.githubusercontent.com/ultralytics/assets/main/docs/hub/pro/hub_pro_upgrade_4.jpg)

!!! tip "Tip"

    We recommend ticking the checkbox to save your payment information for future purchases, facilitating easier top-ups to your account balance.

That's it!

![Ultralytics HUB screenshot of the Payment Successful dialog](https://raw.githubusercontent.com/ultralytics/assets/main/docs/hub/pro/hub_pro_upgrade_5.jpg)

## Account Balance

The account balance is used to pay for [Ultralytics Cloud Training](./cloud-training.md) resources.

In order to top up your account balance, simply click on the **Top-Up** button.

![Ultralytics HUB screenshot of the Settings page Billing & License tab with an arrow pointing to the Top-Up button](https://raw.githubusercontent.com/ultralytics/assets/main/docs/hub/pro/hub_pro_account_balance_1.jpg)

Next, set the amount you want to top-up.

![Ultralytics HUB screenshot of the Checkout with an arrow pointing to the Change amount button](https://raw.githubusercontent.com/ultralytics/assets/main/docs/hub/pro/hub_pro_account_balance_2.jpg)

That's it!

![Ultralytics HUB screenshot of the Payment Successful dialog](https://raw.githubusercontent.com/ultralytics/assets/main/docs/hub/pro/hub_pro_account_balance_3.jpg)
