% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quarto_utils.R
\name{gvz_render_multiple}
\alias{gvz_render_multiple}
\title{Render multiple files}
\usage{
gvz_render_multiple(data, template, output_dir, merge = FALSE)
}
\arguments{
\item{data}{A tibble
Each row will generate a new document, the data in the columns
is passed as variables to be used in the template.}

\item{template}{A quarto template}

\item{output_dir}{The directory to render the files to}

\item{merge}{If a string, merges the multiple document in document
with the corresponding name. Default is false.}
}
\value{
Generate pdf files
}
\description{
Render multiple files
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Read a file containing the data used in the template
readr::read_csv("data_file.csv") |>
  gvz_render_multiple("template.qmd", "./")
\dontshow{\}) # examplesIf}
}
