import re
import functools
import shutil
import os
import subprocess
import glob
import sys
import collections
import string
import networkx as nx
import matplotlib.pyplot as plt
from collections import Counter
import ast
from networkx.drawing.nx_agraph import to_agraph

####################################################################################################################################

# Paths to where ./BigraphER, rpl-udp, PRISM, and the experiment folders are


outPathBigraph = "./BigraphER/"
outPathCooja = "./contiki-ng/examples/rpl-udp/S_1/"
outPathPRISM = "./prism-4.7-osx64/bin/"
outPathExperiment = "./TheExperiment/"

####################################################################################################################################

#1.  Copy .tra and .lab to PRISM folders and .dot to the expermint folder

shutil.copyfile(outPathBigraph + "AutoBigraphER_1.tra", outPathPRISM + "AutoBigraphER_1.tra")
shutil.copyfile(outPathBigraph + "AutoBigraphER_1.lab", outPathPRISM + "AutoBigraphER_1.lab")

shutil.copyfile(outPathBigraph + "AutoBigraphER_1.lab", outPathExperiment + "AutoBigraphER_1.lab")
shutil.copyfile(outPathBigraph + "AutoBigraphER_1.dot", outPathExperiment + "AutoBigraphER_1.dot")

#2. Run PRISM to get deadlocks states

os.chdir(outPathPRISM)
os.system("./prism AutoBigraphER_1.tra -importtrans -pf 'filter(print, filter(argmax, Pmax=? [ \"deadlock\" ]))' -dtmc > statesNumbers_1.txt")

# Go back to the experiment folder
os.chdir(outPathExperiment)

#3. Copy from PRISM folder to the expirement folder

shutil.copyfile( outPathPRISM +"statesNumbers_1.txt" , outPathExperiment +"statesNumbers_1.txt")

############################################§############################################§###################################


# Extract DAGs built by BigraphER:

def bigraphDAGs():
  statesNumbers = []
  deadlocks=[]
  bigRPLRoute=[]

  ## Create a text file to save extracted DAGs:
  with open('DAGFromCoojaAndBigraphER_1.txt', 'a') as dcb:  
      dcb.write(" \n\n ************** Topology_1 # DAGs:  ****************** \n\n" )

  # Read from the txt file that has deadlocks states " From PRISM, step #2 above to extract deadlocks State Numbers:
  with open('statesNumbers_1.txt', 'rt') as sn:#
      lines = sn.readlines()
      n_lines = len(lines)
      for i, line in enumerate(lines):
        if ":(" in line:
          statesNumbers.append(lines[i])

  for element in statesNumbers:
      value = re.search(r'\((.*)\)', element).group(1)
      deadlocks.append(value)
    
    
   
  # Search for lines that contain predicates (in deadlocks states) in the .dot file.
  
  bigRouteLine=""
  
  with open( 'AutoBigraphER_1.dot', 'rt') as bdf:#
      bigOutput = bdf.readlines()
  word="parentOf"
  for stateNumber in deadlocks:
      for line in bigOutput:
         if stateNumber in line and word in line:
            bigRouteLine+=line
 
  # Extract the DAGs as (child, parent) format so a DAG paths
  bigRoute=""
 
  bigRoute=re.findall(r"parentOf.*?rank", bigRouteLine)
  s=[]
  bigRPLRoute = [s.replace('parentOf', '').replace('\\"', '').replace(', rank', '') for s in bigRoute]

  # Find out how many DAGs are found:
  x = len(bigRPLRoute)

  # Create a text file to save DAGs extracted from both Bigraphs and Cooja:
  with open('DAGFromCoojaAndBigraphER_1.txt', 'a') as dcb:
        dcb.write(" Ther is\are " + str (x) + " DAG(s) from BigraphER: \n"   )
  
  
  # Save each Bigraph RPL DAG separately: 
  for i, BigraphDAG in enumerate(bigRPLRoute):
    globals()[string.ascii_lowercase[i]] = BigraphDAG
    
    # Save DAGs to a txt file ( For Bigraphs DAGs )
    with open('DAGFromBigraphER_1.txt', 'a') as db:
     db.write(BigraphDAG + "\n")  

    # Save DAGs to the txt file ( For both Bigraphs and Cooja DAGs )
    with open('DAGFromCoojaAndBigraphER_1.txt', 'a') as dcb:
        dcb.write(BigraphDAG + "\n"  )  
        
  
  
  return(bigRPLRoute)


#######################################################################################§############################################§#########

# Extract DAGs built by Cooja:

def coojaDAGs():
  # Read all testlogs generated by repeated Cooja runs:

  files = glob.glob(outPathCooja + '*.testlog') 
  #path = '/Users/mal/Documents/ExpermintNo2/S_32/*.testlog'  
  #files = glob.glob(path)
  coojaRPLRoute=[]
  coojaRouteParent=""
  coojaRouteChild=""
  
  for name in files:  
    with open(name) as f:
     coojaRPLRoute=[]
     coojaRouteParent=""
     coojaRouteChild=""
     lines = f.read().splitlines()
     routeList = ""
     
     text = "Default route found"
     for line in lines:
       if text in line:
            routeList+=line
          
     
     coojaRPLRouteParent=re.findall(r"[\:](\d+)[\\ID]", routeList) 
     coojaRPLRouteChild=re.findall(r"[\:](\d+)[\[D]", routeList) 

   
     # Create the DAGs as (child, parent) format so a DAG paths
     coojaRPLRoute = [( coojaRPLRouteChild[i], coojaRPLRouteParent[i]) for i in range(0, len(coojaRPLRouteParent))]

     coojaRPLRoute = list(dict.fromkeys(coojaRPLRoute)) #delete duplicates


     
     
      


     with open('DAGsFromRepeatedRunCooja.txt', 'a') as dc: 
      dc.write(str(coojaRPLRoute) + "\n")



  with open('DAGsFromRepeatedRunCooja.txt', 'r') as dc:
        c = collections.Counter(dc.readlines())
  with open('DAGFromCoojaAndBigraphER_1.txt', 'a') as dcb: 
          dcb.write("\n\n DAGs from Cooja : \n")
  counter = 0
  for path, count in sorted(c.items(), key=lambda x: x[0]):     
    counter+=count
    with open('DAGFromCoojaAndBigraphER_1.txt', 'a') as dcb: 
      dcb.write( str(path) + "Repeated  :  " + str(count) + " Times \n\n" + "Total simulations = " + str(counter)   )
  
  # Delete repeated simulations (unordered)
  dup = set()
  unique = []
  t=0

  for x, y in sorted(c.items(), key=lambda x: x[0]):
      
      sort = tuple(sorted(x))
      
      if sort not in dup:
         
         unique.append(x)
         dup.add(sort)

     
          
  return(unique) 


#######################################################################################§############################################§#########


bigraphDAGs()
coojaDAGs()


#######################################################################################§############################################§#########

# Read Edges List from Topology documentation File
def edgesList():
  pattern='\((\d+, \d)\)'

  with open('TopologiesDocument_1.txt', 'r') as input_data:
        for ind, val in enumerate(input_data):
          if 'Edges' in val:
             data=re.findall(pattern,val)
             originalTopology=[tuple(map(lambda x:int(x),item.split(','))) for item in data]
  return(originalTopology)

#######################################################################################§############################################§#########


# Properties Generator:

def propertyGen():
  HoriginalTopology = nx.DiGraph(edgesList())
  shortestOrihinalNetwork=[]
  length = nx.single_source_shortest_path_length(HoriginalTopology, 1)
  

##############################################################
  # find connected node in random topology: 

  t= max(nx.weakly_connected_components(HoriginalTopology))

     
  #1.All nodes eventually join the RPL DAG:  A [ F joined𝑖 ] where 1 ≤ 𝑖 ≤ num_nodes

  properity1=""
  
  for i in t:
      if i != 1:
        properity1+="A [F \"joined_{}\"]\n".format(i)


  #2. Nodes join with the optimal rank:  A [F rank𝑖,𝑟] where 1 ≤ 𝑖 ≤ num_nodes, 𝑟 = 𝑠𝑝 (𝑖) 

  properity2=""
  for node in length :
     properity2+="A [F \"rank_{}_{}\"]\n".format(node,length[node])

  

  #3.  RPL DAG is cycle-free:  ¬E [ F multijoin𝑖 ] where 1 ≤ 𝑖 ≤ num_nodes (shoud not happen)

  properity3=""     
  #for i in length:
      #properity3+="E [! (F \"multijoin_{}\")]\n".format(i)

  
  num=HoriginalTopology.number_of_nodes()
  
  properity3=""
  for node in length:
    for i in range(0,num):
         if i!=length[node]:
           properity3+="E [ F \"rank_{}_{}\" & ! (F \"rank_{}_{}\")]\n".format(node,length[node],node,i)
   
  
#######################################################################################§############################################§#########

  
  # Write properties into .lab file to be checked by PRISM
  
  with open('propertiesFile_1.lab', 'w') as propertiesFile, open('AutoBigraphER_1.lab', 'r') as labelFile :
   labels = labelFile.read()
   propertiesFile.write(properity1 + "\n" + properity2 + "\n" + properity3 + "\n")
   propertiesFile.write("\n" + labels + "\n")

#######################################################################################§############################################§#########

propertyGen()


# Run PRISM to check the model against the proprties:



#1.  Copy the properties file to PRISM folders
shutil.copyfile("propertiesFile_1.lab", outPathPRISM + "propertiesFile_1.lab") 


#2. Run PRISM
os.chdir(outPathPRISM)
os.system("./prism -javastack 1g -importtrans AutoBigraphER_1.tra propertiesFile_1.lab >>  CheckingResults_1.txt")

#3. Move the model checking result to the expirement folder
shutil.copyfile(outPathPRISM + "CheckingResults_1.txt" , outPathExperiment + "CheckingResults_1.txt")
  

print("DAGs constructed by both Bigraphs model and Cooja are extracted, and the model is checked with PRISM. Check related files for results!")
