# SURFER v3.0

Author : Victor Couplet
Contributors : Marina Martínez Montero, Michel Crucifix

SURFER is a reduced complexity model with a process-based carbon cycle that can reliably estimate CO2 concentrations, global mean temperatures, sea-level rise, and many ocean acidification metrics on timescales from decades to millions of years. SURFER v3.0 is an extension of SURFER v2.0 that incorporates sediments and weathering feedbacks in the carbon cycle component.

For a full explanation of the model (v3.0) please check : url_preprint

For infromation on the previous model version (v2.0) please check : https://gmd.copernicus.org/articles/15/8059/2022/

## Jupyter Notebook 

We present the SURFER v3.0 code and examples to reproduce all figures in the paper using a **jupyter notebbok** (file `SURFER_v3.ipynb`). For information on jupyter notebooks, see https://jupyter.org/. The code is in Python 3.0. The following packages are used and may need to be installed (as well as their dependencies) : `numpy`, `scipy`, `math`, `numba`, `xarray`, `os`, `matplotlib`, `cmcrameri`, `timeit`.

## Data

The repository contains data from other sources (folder `data`). The data is used to force the model (emission scenarios data) or to compare SURFER v3.0's output with SURFER v2 and other models.

### Data from SURFER v2.0

The folder `SURFERv2_data` contains SURFER v2.0 outputs used to compare with SURFER v3.0.

### Data for emission scenarios

The file `carbon_budget.csv` contains  CO2 historical emissions and carbon budget data from [1], available at https://doi.org/10.18160/GCP-2022.  First column : years (AD). Next columns are (in PgC/yr) : fossil emissions excluding cement carbonation sink, land-use change emssions, atmospheric growth, ocean sink, land sink, cement carbonation sink, budget imbalance.

Files `co2_fossil.csv`, `co2_landuse.csv`, `ch4_fossil.csv` and `co2_landuse.csv` contain historical+SSP+extensions emissions used in SURFER v3.0 for the years 1750 to 2300 (included). One value per year. Each files contains 7 rows and 2300-1750+1 = 551 columns. The first row is for the time (yrs AD) and the next rows are for emissions from the following SSP scenarios (in that order) : SSP1-2.6 , SSP2-4.5, SSP4-6.0, SSP3-7.0, SSP5-8.5, SSP5-3.4. Units for emissions are PgC (for both co2 and ch4). For scenario construction see appendix of paper. CO2 fossil emissions from 1750 to 1989 (included) and CO2 land-use emissions from 1850 to 1989 (included) are from [1]. CH4 emissions from 1830 to 1989 (included) are from [2] (data available at https://zenodo.org/records/10839859). CO2 and CH4 emissions from 1990 to 2100 are based on the SSP database hosted by the IIASA Energy Program at https://tntcat.iiasa.ac.at/SspDb.

### Data based on other datasets

The files `GLODAP_averaged_data.csv` and `GLODAP_computed_data.csv` contain data computed based on the GLODAPv2.2016b global 1°  ×  1° mapped climatologies [3], which are available at https://www.ncei.noaa.gov/access/metadata/landing-page/bin/iso?id=gov.noaa.nodc:0286118.

The files `CO2_Kohler.csv` and `CH4_Kohler.csv` contain past CO2 and CH4 atmospheric concentrations based on data from [4], available in the scientific database PANGAEA (https://doi.org/10.1594/PANGAEA.871273). The original data was smoothed using a Savitzky-Golay filter. 

The processing of these datasets to obtain the data used in the `SURFER_v3.ipynb` notebook is available in a second jupyter notebook `data_processing.ipynb`.

### Data from other models

The files `nbp_traj` and `fgco2_traj` contain CMIP6 model data used to produce IPCC AR6 WG1 Figure 5.30. The 'raw' CMIP6 data can be accessed through the Earth System Grid Federation (ESGF) nodes (e.g. https://esgf-index1.ceda.ac.uk/projects/cmip6-ceda/). The code to produce this figure and the associated analysis is freely available online in a jupyter notebook : [https://github.com/IPCC-WG1/Chapter-5_Fig30/blob/main/longterm_carboncycle_withssp126.ipynb] . The files `nbp_traj` and `fgco2_traj` specifically contain the DataArrays `nbp_trajectories_2exp` and `fgco2_trajectories_2exp` created in that notebook. 

The files `cmip6_hist_data.csv`, `cmip6_ssp126_data.csv`, and `cmip6_ssp370_data.csv` contain CMIP6 data used for IPCC AR6 WG1 figures 4.2 (a), 4.7, 4.8,  and for Box TS.5 Figure 1 . The 'raw' CMIP6 data can be accessed through the Earth System Grid Federation (ESGF) nodes (e.g. https://esgf-index1.ceda.ac.uk/projects/cmip6-ceda/). Here, because the author was too lazy to download and proccess CMIP6 data, the data was directly retrieved from the pdf of the IPPC AR6 WG1 report using some black magic involving Inkscape and its Exportxy extension. 

The folder `LTMIP_data` contains files with data from the LTMIP experiments [5]. The data was retrieved directly from the pdf of [5] using Inkscape, and as such, may contain small errors which are not important for our use case (plotting). Now, the original data from the LTMIP experiments is freely available online :  https://terra.seos.uvic.ca/LTMIP/ . 

The file `IPCC_ohc_slr.csv` contains data used to produce IPCC AR6 WG1 Cross-Chapter Box 9.1 Figure 1. The code to produce this figure and the associated analysis is freely available online in a jupyter notebook : [https://github.com/BrodiePearson/IPCC_AR6_Chapter9_Figures/blob/main/Plotting_code_and_data/Cross_Chapter_Box9_1/Plot_Figure/plot_AR6_CCBox9.1_FGD.ipynb] . For the ocean heat content and associated thermal expansion below 700m , we added the contributions of the ocean between 700m and 2000m and the ocean > 2000m.

The files `uvic_2.8.csv`, `uvic_2.9.csv`, `uvic_2.8_SLR.csv`, and `uvic_2.9_SLR.csv` contain outputs from the UVic model of intermediate complexity (versions 2.8 and 2.9). The data is from reference [6] and is freely  available as supplementary material at https://www.nature.com/articles/nclimate2923.

### Data not in the repository

In the paper, SURFER's output is contrasted to results from other models such as LOSCAR and cGENIE. For these models, the data is not provided in this repository.

For the LOSCAR model, the data is from reference [7], and available through personnal correspondence with the author.

For the cGENIE model, the data is from reference [8], and available through personnal corrsepondence with the author.

## Figures

The `figures` folder is initially empty. It is the default repository where the figures produced in the notebook `SURFER_v3.ipynb` will be saved. The user can choose to specify another repository. 

## Licenses

The code of SURFER v3.0 is licensed under a MIT license. See `license_SURFERv3.txt`.

SURFER v2.0, upon which SURFER v3.0 is built, is licensed under a MIT license. See `license_SURFERv2.txt`. 

The scientific colormap `batlouw` from Fabio Crameri is used for Figure 15 of the paper (https://www.fabiocrameri.ch/colourmaps/). It is lincensed under a MIT license. See `license_Crameri.txt`.

## References

[1] Friedlingstein, Pierre, Michael O’Sullivan, Matthew W. Jones, Robbie M. Andrew, Luke Gregor, Judith Hauck, Corinne Le Quéré, et al. 2022. “Global Carbon Budget 2022.” Earth System Science Data 14 (11): 4811–4900. https://doi.org/10.5194/essd-14-4811-2022.

[2] Jones, Matthew W., Glen P. Peters, Thomas Gasser, Robbie M. Andrew, Clemens Schwingshackl, Johannes Gütschow, Richard A. Houghton, Pierre Friedlingstein, Julia Pongratz, and Corinne Le Quéré. 2023. “National Contributions to Climate Change Due to Historical Emissions of Carbon Dioxide, Methane, and Nitrous Oxide since 1850.” Scientific Data 10 (1): 155. https://doi.org/10.1038/s41597-023-02041-1.

[3] Lauvset, Siv K, Robert M Key, Are Olsen, Steven van Heuven, Anton Velo, Xiaohua Lin, Carsten Schirnick, et al. 2016. “A New Global Interior Ocean Mapped Climatology: The 1◦ × 1◦ GLODAP Version 2.”

[4] Köhler, Peter, Christoph Nehrbass-Ahles, Jochen Schmitt, Thomas F. Stocker, and Hubertus Fischer. 2017. “A 156 Kyr Smoothed History of the Atmospheric Greenhouse Gases CO2, CH4, and N2O and Their Radiative Forcing.” Earth System Science Data 9 (1): 363–87. https://doi.org/10.5194/essd-9-363-2017.

[5] Archer, David, Michael Eby, Victor Brovkin, Andy Ridgwell, Long Cao, Uwe Mikolajewicz, Ken Caldeira, et al. 2009. “Atmospheric Lifetime of Fossil Fuel Carbon Dioxide.” Annual Review of Earth and Planetary Sciences 37 (1): 117–34. https://doi.org/10.1146/annurev.earth.031208.100206.

[6] Clark, Peter U., Jeremy D. Shakun, Shaun A. Marcott, Alan C. Mix, Michael Eby, Scott Kulp, Anders Levermann, et al. 2016. “Consequences of Twenty-First-Century Policy for Multi-Millennial Climate and Sea-Level Change.” Nature Climate Change 6 (4): 360–69. https://doi.org/10.1038/nclimate2923.

[7] Zeebe, R E. 2012. “LOSCAR: Long-Term Ocean-Atmosphere-Sediment CArbon Cycle Reservoir Model v2.0.4.” Geosci. Model Dev.

[8] Lord, N. S., A. Ridgwell, M. C. Thorne, and D. J. Lunt. 2016. “An Impulse Response Function for the ‘Long Tail’ of Excess Atmospheric CO 2 in an Earth System Model.” Global Biogeochemical Cycles 30 (1): 2–17. https://doi.org/10.1002/2014GB005074.

