# survey-html-form

Current version: 2.0.0. [See version history](https://github.com/jspsych/jsPsych/blob/main/packages/plugin-survey-html-form/CHANGELOG.md).

The survey-html-form plugin displays a set of `<inputs>` from a HTML string. The type of input can be freely chosen, for a list of possible input types see the [MDN page on inputs](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input). The participant provides answers to the input fields.

## Parameters

In addition to the [parameters available in all plugins](../overview/plugins.md#parameters-available-in-all-plugins), this plugin accepts the following parameters. Parameters with a default value of *undefined* must be specified. Other parameters can be left unspecified if the default value is acceptable.

Parameter | Type | Default Value | Description
----------|------|---------------|------------
html | string | *undefined* | HTML formatted string containing all the input elements to display. Every element has to have its own distinctive name attribute. The `<form>` tag must not be included and is generated by the plugin. This string can contain other HTML elements besides the input fields.
preamble | string | empty string | HTML formatted string to display at the top of the page above all the questions.
button_label | string |  'Continue' | The text that appears on the button to finish the trial.
dataAsArray | boolean |  false | Retrieve the data as an array e.g. [{name: "INPUT_NAME", value: "INPUT_VALUE"}, ...] instead of an object e.g. {INPUT_NAME: INPUT_VALUE, ...}. This might be useful if you omit naming your inputs.
autofocus | string | empty string | The HTML element ID of a form field to autofocus on. The focused element is the element that will receive keyboard events. For elements like `<input type="text">` or `<textbox>`, autofocus means that the cursor will appear in the text input area when the trial loads.
autocomplete | boolean | false | This determines whether or not all of the input elements on the page should allow autocomplete. Setting this to true will enable autocomplete or auto-fill for the form.

## Data Generated

In addition to the [default data collected by all plugins](../overview/plugins.md#data-collected-by-all-plugins), this plugin collects the following data for each trial.

Name | Type | Value
-----|------|------
response | object | An object containing the response for each input. The object will have a separate key (variable) for the response to each input, with each variable being named after its corresponding input element. Each response is a string containing whatever the participant answered for this particular input. This will be encoded as a JSON string when data is saved using the `.json()` or `.csv()` functions. |
rt | numeric | The response time in milliseconds for the participant to make a response. |

## Simulation Mode

This plugin does not yet support [simulation mode](../overview/simulation.md).

## Install

Using the CDN-hosted JavaScript file:

```js
<script src="https://unpkg.com/@jspsych/plugin-survey-html-form@2.0.0"></script>
```

Using the JavaScript file downloaded from a GitHub release dist archive:

```js
<script src="jspsych/plugin-survey-html-form.js"></script>
```

Using NPM:

```
npm install @jspsych/plugin-survey-html-form
```
```js
import surveyHtmlForm from '@jspsych/plugin-survey-html-form';
```

## Examples

???+ example "Fill in the blanks"
    === "Code"

        ```javascript
        var trial = {
          type: jsPsychSurveyHtmlForm,
          preamble: '<p>How are you feeling <b>right now?</b></p>',
          html: '<p> I am feeling <input name="first" type="text" />, <input name="second" type="text" />, and <input name="third" type="text" />.</p>'
        };
        ```

    === "Demo"
        <div style="text-align:center;">
          <iframe src="../../demos/jspsych-survey-html-form-demo1.html" width="90%;" height="500px;" frameBorder="0"></iframe>
        </div>

    <a target="_blank" rel="noopener noreferrer" href="../../demos/jspsych-survey-html-form-demo1.html">Open demo in new tab</a>

???+ example "Using the autofocus parameter"
    === "Code"
        ```javascript
        var trial = {
          type: jsPsychSurveyHtmlForm,
          preamble: '<p>What is your favorite bird?</p>',
          html: '<p>My favorite bird is <input type="text" id="test-resp-box" name="response" size="10" /></p>',
          autofocus: 'test-resp-box'
        };
        ```
        In this example, the browser will focus on the element with the ID `test-resp-box` when the trial loads. For `<input type="text">` elements, this means that the cursor will appear inside the text box.

    === "Demo"
        <div style="text-align:center;">
          <iframe src="../../demos/jspsych-survey-html-form-demo2.html" width="90%;" height="500px;" frameBorder="0"></iframe>
        </div>

    <a target="_blank" rel="noopener noreferrer" href="../../demos/jspsych-survey-html-form-demo2.html">Open demo in new tab</a>
