# jsPsych Code of Conduct

## Community
jsPsych aims to provide a productive, helpful, and agile community that:
* Welcomes new users and ideas
* Seeks to improve the jsPsych library for all users
* Works toward best scientific practices
* Ensures that jsPsych remains as accessible as possible

We hope that this community will encourage collaboration between users/groups with different needs, interests, and skills.

jsPsych was created with the goal of making web-based behavioral experiments as easy as possible for those who do not have a background in web development or any other kind of computer programming. Thus, novice users are an essential part of this community. The involvement of beginner programmers is not only welcome, but critical for the continued success of the project. 

Similarly, a core aim of the jsPsych project is to make web-based behavioral experiments accessible to anyone who wishes to utilize them. We can better achieve this goal with diverse voices guiding the project, and we value participation from those who bring different perspectives to our community. We actively encourage participation from those who come from historically underrepresented groups in software development and STEM.

### Core principles
* **Be friendly and patient**: Remember that you might not be communicating in someone else's primary spoken or programming language, and that we don’t all have the same background knowledge and experience. 
* **Be helpful**: Offer constructive feedback on others’ ideas and code.
* **Be collaborative**: Collaboration improves the efficiency and quality of our work. We aim to understand the needs of other users, and to work transparently with others to coordinate our efforts. 
* **Be considerate and respectful**: There is no excuse for disrespectful behavior. When making comments in public spaces, we should consider the potential impact on the whole community. For instance, jokes/teasing may seem harmless among users who are familiar with one another, but this can be intimidating and off-putting for other community members.
* **Ask for help and seek feedback**: We’re all learning, and no one is expected to be perfect. Asking questions and seeking feedback early on can help us work efficiently and avoid bigger problems in the future. 
* **Take responsibility for your actions**: We all make mistakes; when we do, we take responsibility for them. If someone has been harmed or offended, we listen carefully and respectfully, and work to improve our behavior.
* **Value decisiveness, clarity, and consensus**: We hope that jsPsych contributors can resolve disagreements constructively, using clear rationale for their perspective, and with humility. When they cannot, the project leader can offer clarity and direction.

### Scope
The community’s core principles apply to all private and public spaces where the jsPsych project is officially managed, promoted, or discussed. Examples include all of the jsPsych-related GitHub repos (issues, commit messages, pull requests, etc.), the jsPsych Google Group, and anyone acting as a representative of the project, whether in person or online, including via social media and email. We expect this Code of Conduct to be honoured by everyone in the jsPsych community. 

## Leadership
We encourage all participants in the jsPsych community to feel empowered to lead, to take action, and to experiment when they feel that innovation could improve the project. There is no need to wait for delegation or permission - leadership can be exercised by anyone simply by taking action.

Although we strive to make jsPsych as open and collaborative as possible, it’s important to have a project leader in order to ensure that jsPsych remains (1) as accessible as possible for all users, (2) stable and reliable, (3) easy to maintain, (4) internally consistent, etc.

Such leadership occasionally requires decisions that are in the best interest of the project but may not be understood by or beneficial to everyone. These decisions are important because they keep the project on track, and enable it to move forward faster than if we required complete consensus. Any major decisions taken by the project leader should be mindful of the challenges they may present for others. We expect the project leader to communicate major decisions/changes early on, and to provide their reasoning.

### Contributions
We invite anyone to contribute to any aspect of the project. You can find more information about contributing here: https://www.jspsych.org/latest/developers/contributing/

Because changes to the jsPsych library can have a huge potential for impact on all users, any proposed changes to the library have to be considered very carefully. For this reason, it is always a good idea to check with the project leader about whether your proposed contribution would likely be merged into the jsPsych library. Keep in mind that, even if your work isn’t suitable for merging into the jsPsych library, you can still use it in your own projects and share it publicly with others, e.g. via a separate GitHub repository.

Contributors are acknowledged in the contributors.md file in the jsPsych GitHub repo, and in the notes for each release. If you feel that your contribution has been overlooked, please contact Josh de Leeuw (josh.deleeuw@gmail.com). We also encourage opening a pull request to modify the contributors.md file.

### Conflicts of Interest
We expect jsPsych users and developers to be aware when they are conflicted due to employment or other projects they are involved in, and to abstain or delegate decisions that may be seen to be self-interested. We expect that everyone who participates in the jsPsych community does so with the goal of improving the library for all of its users.

## Reporting Code of Conduct Issues
In the event that a Code of Conduct issue cannot be resolved among users, please feel free to report your concerns to Josh de Leeuw (josh.deleeuw@gmail.com). If Josh de Leeuw is involved in the issue, you can report it to Becky Gilbert instead (beckyannegilbert@gmail.com). In your report, please include as much information as possible about what occurred, including any relevant links/attachments.

All reports will be reviewed by a multi-person team and will result in a response that is deemed necessary and appropriate to the circumstances. Where additional perspectives are needed, the team may seek insight from others with relevant expertise or experience. The confidentiality of the person reporting the incident will be kept at all times. Involved parties are never part of the review team. Anyone asked to stop unacceptable behavior is expected to comply immediately. If an individual engages in unacceptable behavior, the review team may take any action they deem appropriate, including a permanent ban from the community.

This code is not exhaustive or complete. It serves to capture our common understanding of a welcoming, productive, and collaborative environment. We expect the code to be followed in spirit as much as in the letter.

## References
This document was based on, or inspired by, the following Codes of Conduct:
* Ubuntu https://ubuntu.com/community/code-of-conduct
* Microsoft https://opensource.microsoft.com/codeofconduct/
* Contributor Covenant https://www.contributor-covenant.org/version/1/4/code-of-conduct