% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_plots.R
\name{plotTreeTestBeta}
\alias{plotTreeTestBeta}
\title{Plot tree coefficients from multivariate testing}
\usage{
plotTreeTestBeta(
  tree,
  low = "blue",
  mid = "white",
  high = "red",
  xmax.scale = 1.5
)
}
\arguments{
\item{tree}{phylo object storing tree}

\item{low}{low color on gradient}

\item{mid}{mid color on gradient}

\item{high}{high color on gradient}

\item{xmax.scale}{expand the x-axis by this factor so leaf labels fit in the plot}
}
\description{
Plot tree coefficients from multivariate testing at each node.  Only applicable top fixed effect tests
}
\examples{
library(variancePartition)

# Load cell counts, clustering and metadata
# from Kang, et al. (2018) https://doi.org/10.1038/nbt.4042
data(IFNCellCounts)

# Apply crumblr transformation
cobj <- crumblr(df_cellCounts)

# Use dream workflow to analyze each cell separately
fit <- dream(cobj, ~ StimStatus + ind, info)
fit <- eBayes(fit)

# Perform multivariate test across the hierarchy
res <- treeTest(fit, cobj, hcl, coef = "StimStatusstim")

# Plot hierarchy, no tests are significant 
plotTreeTestBeta(res)
}
