% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_plots.R
\name{plotTreeTest}
\alias{plotTreeTest}
\title{Plot tree with results from multivariate testing}
\usage{
plotTreeTest(
  tree,
  low = "grey90",
  mid = "red",
  high = "darkred",
  xmax.scale = 1.5
)
}
\arguments{
\item{tree}{phylo object storing tree}

\item{low}{low color on gradient}

\item{mid}{mid color on gradient}

\item{high}{high color on gradient}

\item{xmax.scale}{expand the x-axis by this factor so leaf labels fit in the plot}
}
\description{
Plot tree with results from multivariate testing
}
\examples{
library(variancePartition)

# Load cell counts, clustering and metadata
# from Kang, et al. (2018) https://doi.org/10.1038/nbt.4042
data(IFNCellCounts)

# Apply crumblr transformation
cobj <- crumblr(df_cellCounts)

# Use dream workflow to analyze each cell separately
fit <- dream(cobj, ~ StimStatus + ind, info)
fit <- eBayes(fit)

# Perform multivariate test across the hierarchy
res <- treeTest(fit, cobj, hcl, coef = "StimStatusstim")

# Plot hierarchy and testing results
plotTreeTest(res)

# Extract results for first 3 nodes
res[1:3, ]
}
