% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree.R
\name{diffTree}
\alias{diffTree}
\title{Compare difference in estimates between two trees}
\usage{
diffTree(tree1, tree2)
}
\arguments{
\item{tree1}{object of type \code{treedata} from \code{treeTest()}}

\item{tree2}{object of type \code{treedata} from \code{treeTest()}}
}
\description{
Compare difference in cofficient estimates between two trees.  For node \code{i}, the test evaluates \code{tree1[i] - tree2[i] = 0}.
}
\details{
When a fixed effect test is performed at each node using \code{treeTest()} with \code{method = "FE.empirical"} or \code{method = "FE"}, a coefficient estimate and standard error are estimated for each node based on the children.  This function performs a two-sample z-test to test if a given coefficient from \code{tree1} is significantly different from the corresponding coefficient in \code{tree2}.
}
\examples{
library(variancePartition)

# Load cell counts, clustering and metadata
# from Kang, et al. (2018) https://doi.org/10.1038/nbt.4042
data(IFNCellCounts)

# Simulate a factor with 2 levels called DiseaseRand
set.seed(123)
info$DiseaseRand = sample(LETTERS[seq(2)], nrow(info), replace=TRUE)
info$DiseaseRand = factor(info$DiseaseRand, LETTERS[seq(2)])

# Apply crumblr transformation
cobj <- crumblr(df_cellCounts)

# Use dream workflow to analyze each cell separately
fit <- dream(cobj, ~ StimStatus + ind, info)
fit <- eBayes(fit)

# Perform multivariate test across the hierarchy
res1 <- treeTest(fit, cobj, hcl, coef = "StimStatusstim")

# Perform same test, but on DiseaseRand
fit2 <- dream(cobj, ~ DiseaseRand, info)
fit2 <- eBayes(fit2)
res2 <- treeTest(fit2, cobj, hcl, coef = "DiseaseRandB")

# Compare the coefficient estimates at each node
# Test if res1 - res2 is significantly different from zero
resDiff = diffTree(res1, res2)

resDiff

plotTreeTest(resDiff)

plotTreeTestBeta(resDiff)
}
