#!/bin/bash
## ======================================================================
##           SCRIPT TO SUBMIT JOBS ON COMPUTE CANADA CLUSTER
## ======================================================================
#SBATCH --account=def-jsheng
#SBATCH --job-name=NWA12_R072
#SBATCH --ntasks=144
#SBATCH --mem=0
#SBATCH --time 23:55:00
#SBATCH --output=NWA12_R072_201309_201402.log
#SBATCH --error=NWA12_R072_201309_201402.err
#SBATCH --mail-type=ALL
#SBATCH --mail-user=kyoko.ohashi@dal.ca

NCPUS=${SLURM_NTASKS}
echo "CPU requested: ${NCPUS}"
module load netcdf-fortran-mpi/4.5.2

ulimit -s unlimited #102400 # unlimited
ulimit -c 0         # no core file

# run the model
mpirun ./romsM ./external/coupling_nwa12.in
