# ROMS 3.9

This repository is based on the [official ROMS Version 3.9](https://www.myroms.org/projects/src/ticket/878) (trunk revision `r1054`) downloaded on 20 March, 2021 following instructions below.

## Branches

List the branches of this repository:

    git branch

### `main`

This is the is the original source code and serves as a connection to the official [ROMS SVN Repository](https://www.myroms.org/projects/src/browser). **Use this branch only to update the code with upstream changes.**

### `dalroms` (default)

This branch is based on trunk revision `r1054` (ROMS Version 3.9) and includes model developments for the the NWA BCP project. These modifications include:

* Calculation of wind stress using the [Large and Pond (1981)](https://doi.org/10.1175/1520-0485(1981)011<0324:OOMFMI>2.0.CO;2) scheme
* Calculation of net longwave radiation using specific specific humidity
* Nudging in sponge layer along open boundaries
* Riverine freshwater input scheme of [Ji et al. (2012)](https://doi.org/10.1080/07055900.2011.580165)
* Spectral nudging ([Thompson et al., 2006](https://doi.org/10.1016/j.ocemod.2005.11.003))
* Semi-prognostic method ([Greatbatch et al., 2004](https://doi.org/10.1016/j.csr.2004.07.009))
* Continental freshwater runoff
* Coupling with the [Los Alamos Sea Ice Model, CICE](https://github.com/CICE-Consortium/CICE-svn-trunk) ([Hunke et al., 2015](https://github.com/CICE-Consortium/CICE-svn-trunk/blob/main/cicedoc/cicedoc.pdf)) based on [MetROMS](https://github.com/metno/metroms) ([Kristensen et al., 2017](https://zenodo.org/record/1046114))

# How to use this repository?

Follow [these instructions](instructions.md) to download and use the code.

# Download ROMS Version 3.9

1. Create an account on [https://www.myroms.org/](https://www.myroms.org/index.php?page=RomsCode).
1. Open a terminal
1. Download the latest version of ROMS using [`git-svn`](https://git-scm.com/docs/git-svn) and clone the source code to the directory `ROMS`

        git svn clone --trunk=/trunk --username <username> https://www.myroms.org/svn/src ROMS

1. Enter your password

Note that the download can take a while as `git` is rebuilding the history of `svn` revisions as commits.  

If the cloning stalls or crashes, kill the process with `CTRL+C`, change into the directory, and fetch the rest:

    cd ROMS
    git svn fetch


You will have to enter your password again.

*It seems like the cloning stops every 100 revisions, so you may have to repeat the `fetch` command multiple times.*

## References
* [ROMS documentation](https://www.myroms.org/wiki/Subversion)
* [`git` documentation](https://git-scm.com/docs/git-svn)
