# ROMS Applications

Input and auxiliary files for different ROMS configurations. Each application
has its own subdirectory with the following structure:

```bash
applications/<name>/
    ├── build_cice.sh  # master shell script to compile CICE
    ├── build_roms.sh  # shell script to compile ROMS
    ├── clean_ice      # clean-up script for CICE (called by build_cice.sh)
    ├── comp_ice       # compile script for CICE (called by build_cice.sh)
    ├── include/
    |    └── nwa12.h   # header file with CPP flags for ROMS
    └── load_modules   # helper script to load the appropriate modules
    ├── NWA12_R0000/   # template directory for model runs
    └── prep_job.sh    # shell script to prepare model simulation
```

# Usage

Create a [fork](https://guides.github.com/activities/forking/) by clicking the **Fork** button in the top-right corner of the header. This should create a copy of this repository in your profile. You can access this copy by navigating through you profile or at

`https://github.com/<username>/applications`,

where `<username>` is your GitHub user name.

## Clone Your Fork

To download your fork, go to your terminal and change into your /home directory and clone your fork of the `applications` repository:

```bash
cd ~/
git clone git@github.com:<username>/applications
```

If you have set up a SSH key to your GitHub account, the download should start automatically.