#!/bin/bash

runID=$1

# check if folder with runID already exists in ~/scratch/
if [ ! -d "${HOME}/scratch/${runID}/" ]; then

    # copy template directory
    cp -r NWA12_R000/ ${HOME}/scratch/${runID}/

    # copy ROMS executable
    cp roms[MG] ${HOME}/scratch/${runID}/

    # create directory for output and restart files
    mkdir -p ${HOME}/scratch/${runID}/output/ocean
    mkdir -p ${HOME}/scratch/${runID}/output/ice
    mkdir -p ${HOME}/scratch/${runID}/restart

    # change into run directory to change paths in namelists
    cd ${HOME}/scratch/${runID}/

    # modify ROMS namelist
    sed -i "s/USERNAME/${USER}/" external/roms_nwa12.in
    sed -i "s/NWA12_R000/${runID}/" external/roms_nwa12.in

    # modify CICE namelist
    sed -i "s/USERNAME/${USER}/" external/ice_in
    sed -i "s/NWA12_R000/${runID}/" external/ice_in

    # modify coupler namelist
    sed -i "s/USERNAME/${USER}/" external/coupling_nwa12.in

    # modify job script
    sed -i "s/NWA12_R000/${runID}/" submit_job.sh

    echo "The directory for the model run is"
    echo ${HOME}/scratch/${runID}

else
    echo "A directory with the runID ${runID} already exists."
    exit
fi