/*
** svn $Id$
*******************************************************************************
** Copyright (c) 2002-2020 The ROMS/TOMS Group                               **
**   Licensed under a MIT/X style license                                    **
**   See License_ROMS.txt                                                    **
*******************************************************************************
**
** Options for prognositc run
** Copied from nwa12.h and added notes 2021/9/28
**
** Application flag:   NWA12
** Input script:       roms_nwa12.in
*/

/* Options associated with momentum equations */
#define UV_ADV         /* activate advection terms */
#define UV_COR         /* activate Coriolis term */
#define UV_VIS2        /* harmonic horizontal mixing */
/* #define UV_SMAGORINSKY /* turn ON Smagorinsky-like viscosity */
#define UV_LOGDRAG     /* activate logarithmic bottom friction */
#define SPLINES_VVISC  /* splines reconstruction of vertical viscosity */

/* Option to limit bottom stress */

/* Options associated with tracers equations */
#define TS_DIF2        /* turn ON harmonic horizontal mixing */
/* #define TS_SMAGORINSKY /* turn ON Smagorinsky-like diffusion */
#define NONLIN_EOS     /* use nonlinear equation of state */
#define SALINITY       /* have salinity */
#define SOLAR_SOURCE   /* solar radiation source term */
#define SPLINES_VDIFF  /* splines reconstruction of vertical diffusion */

/* Option to suppress further surface cooling */
/* #define LIMIT_STFLX_COOLING /* suppress SST cooling below freezing point */

/* Option for MPDATA 3D Advection */

/* Options for pressure gradient algorithm */
#define DJ_GRADPS /* splines density Jacobian (Shchepetkin, 2000) */
#define ATM_PRESS /* impose atmospheric pressure onto sea surface */
/* Added PRESS_COMPENSATE 2022/04/25, undefined 2023/09/07 */
#undef PRESS_COMPENSATE

/* Options for atmospheric boundary layer surface fluxes */
#define BULK_FLUXES       /* bulk fluxes computation */
#define COOL_SKIN         /* cool skin correction */
#define LONGWAVE_OUT      /* compute outgoing longwave radiation */
#define EMINUSP           /* compute E-P */
#define SPECIFIC_HUMIDITY /* use specific humidity */
/* #define CLOUDS >>> possibly not needed because LONGWAVE_OUT is defined */
#define SHORTWAVE_IN
#ifdef SHORTWAVE_IN
#  define ALBEDO_LY09
#endif

/* Added WIND_MINUS_CURRENT 2022/09/07 */
#define WIND_MINUS_CURRENT

/* Options for wave roughness formulation in bulk fluxes */

/* Options for shortwave radiation */

/* Options for model configuration */
#define SOLVE3D        /* solving 3D primitive equations */
#define MASKING        /* land/sea masking */
#define AVERAGES       /* write out time-averaged data */
#define DIAGNOSTICS_UV /* write out momentum diagnostics */
#define DIAGNOSTICS_TS /* write out tracer diagnostics */

/* Options for Lagrangian drifters */

/* Options for analytical fields configuration */
#define ANA_BTFLUX /* bottom temperature flux */
#define ANA_BSFLUX /* bottom salinity flux */

/* Options for horizontal mixing of momentum */
#define MIX_GEO_UV /* mixing along geopotential (constant Z) surfaces */

/* Options for horizontal mixing of tracers */
#define MIX_GEO_TS /* mixing along geopotential (constant depth) surfaces */

/* Options for vertical mixing of momentum and tracers */
#define MY25_MIXING /* Mellor/Yamada Level-2.5 closure */

/* Options for the Mellor/Yamada level 2.5 closure */
#if defined GLS_MIXING || defined MY25_MIXING
#  define KANTHA_CLAYSON /* Kantha and Clayson stability function */
#  define N2S2_HORAVG    /* horizontal smoothing of buoyancy/shear */
#  define RI_SPLINES     /* splines reconstruction for vertical sheer */
#endif

/* Options for lateral boundary conditions */
#define RADIATION_2D /* tangential phase speed in radiation conditions */
/* Nudging toward reanalysis data in nudging ("sponge") layers */
/* Set the following in *.in to T to activate nudging: LnudgeTREA for tracers,
   LnudgeM2REA for 2D momentum, LnudgeM3REA for 3D momentum */
#define NUDGE_BDRY

/* Options for tidal forcing at open boundaries */
#define SSH_TIDES  /* impose tidal elevation */
#define UV_TIDES   /* impose tidal currents */
#define RAMP_TIDES /* ramping (over one day) tidal forcing */
#define ADD_FSOBC  /* add tidal elevation to processed open boundary conditions data */
#define ADD_M2OBC  /* add tidal currents to processed open boundary conditions data */

/* Added code to keep track of nudging effect 2022/01/12 */
#define DIAG_NUDG

/* Options for Fennel et. al (2006) biological model */
#define BIO_FENNEL
#ifdef BIO_FENNEL
# define BIO_2P2Z
# define DETN2C
# define TEMP_RATES
# define OXYGEN
# define RW14_OXYGEN_SC
# define CARBON
# ifdef CARBON
#  define RW14_CO2_SC
#  define TALK_NONCONSERV
#  define PCO2AIR_MAUNALOA
# endif
# define PO4
# define BIO_SEDIMENT
# define DENITRIFICATION
# undef RIVER_DON
# define DIAGNOSTICS_BIO
# define ANA_SPFLUX
# define ANA_BPFLUX
/* Added ice/temperature relationship from GLORYS to limit surface PAR 2021/7/06 */
# undef PARICE
#endif

/* Options for two-way coupling to other models */
#define CICE_COUPLING

#ifdef CICE_COUPLING
#  define MCT_LIB
#  define CICE_OCEAN
#  define SNOWFALL
#  define CICE_OBC
#endif

/* Options for nearshore stresses and shallow water configurations */
#define WET_DRY /* activate wetting and drying */

/* Options for MPI communications */

/* Options for NetCDF input and output */
#define PERFECT_RESTART

/* Commented out next 3 lines 2023/09/07 */
/* #ifdef PERFECT_RESTART */
/* #  define OUT_DOUBLE */
/* #endif */

/* Options to reduce model drift */
#undef SEMIPROG  /* semi-prognostic method */
#undef SPCNDG    /* spectral nudging */

/* River runoff (Ji et al., 2011) */
/* Set LuvSrc and LtracerSrc in *.in to T */
/* Undefined 2023/09/07 */
#undef RIVER_JI

/* Continental runoff */
/* Added RUNOFF_SSH 2023/09/07 */
#define RUNOFF
#define RUNOFF_SSH

/* Added options used in prognostic physical runs 2023/09/07 */
#define CURVGRID
#define MIN_SALINITY
#define HDF5
