#!/bin/bash
## ======================================================================
##           SCRIPT TO SUBMIT JOBS ON COMPUTE CANADA CLUSTER
## ======================================================================
#SBATCH --account=
#SBATCH --job-name=NWA12_R000
#SBATCH --ntasks=144
#SBATCH --mem=0
#SBATCH --time 3-00:00:00
#SBATCH --output=NWA12_R000.log
#SBATCH --error=NWA12_R000.err
#SBATCH --mail-type=ALL
#SBATCH --mail-user=

NCPUS=${SLURM_NTASKS}
echo "CPU requested: ${NCPUS}"
module load netcdf-fortran-mpi/4.5.2

ulimit -s unlimited #102400 # unlimited
ulimit -c 0         # no core file

# run the model
mpirun ./romsM ./external/coupling_nwa12.in
