# DALROMS_NWA12

This directory contains the model codes.

The information in `applications/README.md`, `models/ROMS/README.md`, and 
`model/ROMS/instructions.md` applies to running the coupled model on clusters 
maintained by Compute Canada (now the Digital Research Alliance of Canada).

References to the GitHub repository in `applications/README.md` and 
`models/ROMS/README.md` should be ignored.

## applications

This directory contains CPP header files and build scripts. The subdirectory 
`NWA12/include/` contains the CPP header files:
1. `nwa12_016.h`: Control run
2. `nwa12_r075.h`: Prognostic run
3. `nwa12_r072.h`: No Tides run
4. `nwa12_r076.h`: No Ice run

The procedure for compiling the models on a Digital Alliance cluster is:
`source build_cice.sh computecanada`
`./build_roms.sh -j X` where X is the number of processors

`prep_job.sh` can be used to set up the job (create output directory, modify
runtime parameter names, etc.).

## models

This directory contains the codes of the ocean circulation model 
[ROMS](https://www.myroms.org/) and the sea ice model 
[CICE](https://github.com/CICE-Consortium/CICE-svn-trunk/tree/cice-5.1).

## software

This directory contains the codes of the coupler software 
[MCT](https://github.com/MCSclimate/MCT/tree/MCT_2.10.0).
