// ----------------------------------------------------------------------------
// Copyright (C) 2013 Louise A. Dennis, Michael Fisher
//
// This file is part of the Engineering Autonomous Space Software (EASS) Library.
// 
// The EASS Library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 3 of the License, or (at your option) any later version.
// 
// The EASS Library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with the EASS Library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
// 
// To contact the authors:
// http://www.csc.liv.ac.uk/~lad
//
//----------------------------------------------------------------------------

package ail.syntax.ast;

import gov.nasa.jpf.vm.MJIEnv;

import ail.syntax.GLogicalFormula;

/**
 * Represents a logical formula  (a single atom, negation of an atom or a conjunct)
 * that can appear in plan guards and so refers explicitly to beliefs and goals rather
 * than logical predicates.
 * 
 */
public interface Abstract_GLogicalFormula {
	/**
	 * Convert to a concrete representation.
	 * @return
	 */
	public GLogicalFormula toMCAPL();
	
	/**
	 * Replicates expression in the JVM.
	 * @param env
	 * @return
	 */
	public int newJPFObject(MJIEnv env);
	
	/**
	 * Is this trivially true?
	 * @return
	 */
	public boolean isTrivial();
}
