#include "utilities.h"

extern thread_local std::mt19937 rNG;

Utilities::Utilities() {

}

// ------------------------------------------------------------------------------------------------//

float Utilities::RandomFloat(float lowerValue, float higherValue) {
    return lowerValue + static_cast <float> (rNG()) / (static_cast <float> (rNG.max() / (higherValue - lowerValue)));
}

// ------------------------------------------------------------------------------------------------//

bool Utilities::FloatsAlmostEqual(float A, float B, float maxRelDiff) {
    // Calculate the difference.
    float diff = fabs(A - B);
    A = fabs(A);
    B = fabs(B);
    // Find the largest
    float largest = (B > A) ? B : A;

    if (diff <= largest * maxRelDiff) {
        return true;
    }
    return false;
}

// ------------------------------------------------------------------------------------------------//

float Utilities::CalculateDailyBoldMortalityRate(float monthlyMortalityRate) {
    float dailyMortalityRate = 1.0 - pow(1.0 - monthlyMortalityRate, 1.0 / 30.0);
    return dailyMortalityRate;
}

// ------------------------------------------------------------------------------------------------//

float Utilities::MeanVectorInt(std::vector<int> vector){
    if (vector.empty()) {
        return 0;
    }

    float sum_value = 0.0;
    int n = vector.size();
    for (int i=0; i < n; i++){
        sum_value += vector[i];
    }
    return (sum_value / static_cast<float>(n));
}

// ------------------------------------------------------------------------------------------------//

float Utilities::MeanVectorFloat(std::vector<float> vector){
    if (vector.empty()) {
        return 0;
    }

    float sum_value = 0.0;
    int n = vector.size();
    for (int i=0; i < n; i++){
        sum_value += vector[i];
    }
    return (sum_value / static_cast<float>(n));
}

// ------------------------------------------------------------------------------------------------//

