#include "testutilities.h"
#include "utilities.h"
#include <iostream>

extern thread_local std::mt19937 rNG;

void TestUtilities::testFloatsAlmostEqual()
{
    QVERIFY(Utilities::FloatsAlmostEqual(3.0, 3.0));
    QVERIFY(Utilities::FloatsAlmostEqual(5.0, 5.0));
    QVERIFY(Utilities::FloatsAlmostEqual(-5.0, -5.0));
}

void TestUtilities::testRandomFloat()
{
    rNG.seed(5489); //default seed

    std::vector<std::tuple<float, float>> testCombinations = {
        {-0.5, 1}, {0,1}, {5,10}, {-20, -10}, {0.55, 5000}
    };
    for (auto t:testCombinations) {
        for (int i = 0; i < 5000; i++) {
            float randomNumber = Utilities::RandomFloat(std::get<0>(t), std::get<1>(t));

            QVERIFY(randomNumber > std::get<0>(t));
            QVERIFY(randomNumber < std::get<1>(t));
        }
    }
}

void TestUtilities::testMeanVector()
{
    std::vector<int> vector1{ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
    float trueMean = 5.5;
    float testMean = Utilities::MeanVectorInt(vector1);
    std::cout << "trueMean " << trueMean << ", testMean " <<  testMean << std::endl;
    QVERIFY(Utilities::FloatsAlmostEqual(trueMean, testMean));
}
