#include "testgridcell.h"
#include "gridcell.h"
#include "grid.h"
#include <iostream>

float TestGridCell::prepareDistance(int gridsize, int x, int y, int core_x, int core_y)
{
    // 1. build small test grid
    Grid* testGrid = new Grid(gridsize);

    // 2. retrieve cell from grid
    GridCell* cell = testGrid->GetCell(x, y);

    // 3. calculate distance from core cell
    float distance = cell->DistanceToCoreCell(core_x, core_y, gridsize);
    return distance;
}

void TestGridCell::testDistanceToCoreCell() {
    float distance1 = prepareDistance(17, 1, 1, 8, 8);
    QCOMPARE(distance1, static_cast<float>(9.899495));

    float distance2 = prepareDistance(17, 1, 1, 15, 1);
    QCOMPARE(distance2, static_cast<float>(3.0));

    float distance3 = prepareDistance(17, 1, 1, 15, 15);
    QCOMPARE(distance3, static_cast<float>(4.2426));

    float distance4 = prepareDistance(17, 1, 1, 3, 14);
    QCOMPARE(distance4, static_cast<float>(4.472135955));

    float distance5 = prepareDistance(17, 1, 1, 8, 16);
    QCOMPARE(distance5, static_cast<float>(7.28010988928));

    float distance6 = prepareDistance(10, 4, 9, 4, 2);
    QCOMPARE(distance6, static_cast<float>(3));

    float distance7 = prepareDistance(10, 4, 2, 4, 9);
    QCOMPARE(distance7, static_cast<float>(3));

    float distance8 = prepareDistance(10, 3, 7, 4, 2);
    QCOMPARE(distance8, static_cast<float>(5.09901951359));

    float distance9 = prepareDistance(10, 5, 7, 4, 2);
    QCOMPARE(distance9, static_cast<float>(5.09901951359));

    float distance10 = prepareDistance(10, 2, 8, 4, 2);
    QCOMPARE(distance10, static_cast<float>(4.472135955));

    float distance11 = prepareDistance(10, 5, 8, 4, 2);
    QCOMPARE(distance11, static_cast<float>(4.12310562562));

    float distance12 = prepareDistance(10, 7, 9, 4, 2);
    QCOMPARE(distance12, static_cast<float>(4.24264068712));
}
