#include "testgrid.h"
#include "grid.h"
#include <iostream>

void TestGrid::prepareTestCellsInRadius(std::vector<std::tuple<int, int>> result, int gridsize, int x,int y, int radius, int skip)
{
   // 1. build small test grid
   Grid* testGrid = new Grid(gridsize);

   // 3. call function
   std::vector<GridCell*> cells;
   cells = testGrid->GetGridCellsInRadius(x, y, radius, skip);

   // 4. sort vector
   std::sort(cells.begin(), cells.end(), [=] (GridCell* cell_i, GridCell* cell_j) {
       if (cell_i->x == cell_j->x) {
           return cell_i->y < cell_j->y;
       }
       return cell_i->x < cell_j->x;
   });

   // 5. verify vector with results (list of tupels given to function)
   QVERIFY(cells.size() == result.size());

   for (int i = 0; i < cells.size(); i++) {
       //std::cout << "cell " << i << ": " <<  cells[i]->x << ", " << cells[i]->y << std::endl;
       QVERIFY(cells[i]->x == get<0>(result[i]) && cells[i]->y == get<1>(result[i]));
   }
}

void TestGrid::testGetGridCellsInRadius()
{
   // 1. construct solution for test case
   std::vector<std::tuple<int, int>> result1{ {0, 1}, {1, 0}, {1, 2}, {2, 1}};
   // 2.  call helper function
   prepareTestCellsInRadius(result1, 17, 1, 1, 1, 0);

   std::vector<std::tuple<int, int>> result2{ {7, 8}, {8, 7}, {8, 9}, {9, 8}};
   prepareTestCellsInRadius(result2, 17, 8, 8, 1, 0);

   std::vector<std::tuple<int, int>> result3{ {3, 8},
                                              {4, 5}, {4, 6}, {4, 7}, {4, 8}, {4, 9}, {4, 10}, {4, 11},
                                              {5, 4}, {5, 5}, {5, 6}, {5, 7}, {5, 8}, {5, 9}, {5, 10}, {5, 11}, {5, 12},
                                              {6, 4}, {6, 5}, {6, 6}, {6, 7}, {6, 8}, {6, 9}, {6, 10}, {6, 11}, {6, 12},
                                              {7, 4}, {7, 5}, {7, 6}, {7, 7}, {7, 8}, {7, 9}, {7, 10}, {7, 11}, {7, 12},
                                              {8, 3}, {8, 4}, {8, 5}, {8, 6}, {8, 7}, {8, 9}, {8, 10}, {8, 11}, {8, 12}, {8, 13},
                                              {9, 4}, {9, 5}, {9, 6}, {9, 7}, {9, 8}, {9, 9}, {9, 10}, {9, 11}, {9, 12},
                                              {10, 4}, {10, 5}, {10, 6}, {10, 7}, {10, 8}, {10, 9}, {10, 10}, {10, 11}, {10, 12},
                                              {11, 4}, {11, 5}, {11, 6}, {11, 7}, {11, 8}, {11, 9}, {11, 10}, {11, 11}, {11, 12},
                                              {12, 5}, {12, 6}, {12, 7}, {12, 8}, {12, 9}, {12, 10}, {12, 11},
                                              {13, 8}
                                            };
   prepareTestCellsInRadius(result3, 17, 8, 8, 5, 0);

   std::vector<std::tuple<int, int>> result4{ {3, 8},
                                              {4, 5}, {4, 6}, {4, 7}, {4, 8}, {4, 9}, {4, 10}, {4, 11},
                                              {5, 4}, {5, 5}, {5, 6}, {5, 7}, {5, 8}, {5, 9}, {5, 10}, {5, 11}, {5, 12},
                                              {6, 4}, {6, 5}, {6, 6}, {6, 7}, {6, 8}, {6, 9}, {6, 10}, {6, 11}, {6, 12},
                                              {7, 4}, {7, 5}, {7, 6}, {7, 7}, {7, 9}, {7, 10}, {7, 11}, {7, 12},
                                              {8, 3}, {8, 4}, {8, 5}, {8, 6}, {8, 10}, {8, 11}, {8, 12}, {8, 13},
                                              {9, 4}, {9, 5}, {9, 6}, {9, 7}, {9, 9}, {9, 10}, {9, 11}, {9, 12},
                                              {10, 4}, {10, 5}, {10, 6}, {10, 7}, {10, 8}, {10, 9}, {10, 10}, {10, 11}, {10, 12},
                                              {11, 4}, {11, 5}, {11, 6}, {11, 7}, {11, 8}, {11, 9}, {11, 10}, {11, 11}, {11, 12},
                                              {12, 5}, {12, 6}, {12, 7}, {12, 8}, {12, 9}, {12, 10}, {12, 11},
                                              {13, 8}
                                            };
   prepareTestCellsInRadius(result4, 17, 8, 8, 5, 1);

   std::vector<std::tuple<int, int>> result5{ {3, 8},
                                              {4, 5}, {4, 6}, {4, 7}, {4, 9}, {4, 10}, {4, 11},
                                              {5, 4}, {5, 5}, {5, 11}, {5, 12},
                                              {6, 4}, {6, 12},
                                              {7, 4}, {7, 12},
                                              {8, 3}, {8, 13},
                                              {9, 4}, {9, 12},
                                              {10, 4}, {10, 12},
                                              {11, 4}, {11, 5}, {11, 11}, {11, 12},
                                              {12, 5}, {12, 6}, {12, 7}, {12, 9}, {12, 10}, {12, 11},
                                              {13, 8}
                                            };
   prepareTestCellsInRadius(result5, 17, 8, 8, 5, 4);

   std::vector<std::tuple<int, int>> result6{ {6, 16},
                                              {7, 0}, {7, 15}, {7, 16},
                                              {8, 0}, {8, 1}, {8, 14}, {8, 15},
                                              {9, 0}, {9, 15}, {9, 16},
                                              {10, 16}
                                            };
   prepareTestCellsInRadius(result6, 17, 8, 16, 2, 0);

   std::vector<std::tuple<int, int>> result7{ {0, 0}, {0, 15},
                                              {1, 16}, {14, 16},
                                              {15, 0}, {15, 15},
                                              {16, 1}, {16, 14}
                                            };
   prepareTestCellsInRadius(result7, 17, 16, 16, 2, 1);
}

void TestGrid::prepareTestNeighbours(std::vector<std::tuple<int, int>> result, int gridsize, int x, int y)
{
   // 1. build small test grid
   Grid* testGrid = new Grid(gridsize);

   // 2. call function
   std::vector<GridCell*> cells;
   cells = testGrid->GetNeighbours(x, y);

   // 3. sort vector
   std::sort(cells.begin(), cells.end(), [=] (GridCell* cell_i, GridCell* cell_j) {
       if (cell_i->x == cell_j->x) {
           return cell_i->y < cell_j->y;
       }
       return cell_i->x < cell_j->x;
   });

   // 4. verify vector with results (list of tupels given to function)
   QVERIFY(cells.size() == result.size());

   for (int i = 0; i < cells.size(); i++) {
       //std::cout << "cell " << i << ": " <<  cells[i]->x << ", " << cells[i]->y << std::endl;
       QVERIFY(cells[i]->x == get<0>(result[i]) && cells[i]->y == get<1>(result[i]));
   }
}

void TestGrid::testGetNeighbours()
{
   std::vector<std::tuple<int, int>> result1{ {0, 0}, {0, 15}, {0, 16}, {15, 0},
                                              {15, 15}, {15, 16}, {16, 0}, {16, 15}
                                           };
   prepareTestNeighbours(result1, 17, 16, 16);

   std::vector<std::tuple<int, int>> result2{ {7, 0}, {7, 15}, {7, 16}, {8, 0},
                                              {8, 15}, {9, 0}, {9, 15}, {9, 16}
                                           };
   prepareTestNeighbours(result2, 17, 8, 16);
}
