#ifndef STATISTICS_H
#define STATISTICS_H

#include <vector>

class Statistics
{
public:
    Statistics(int aSpeciesNumber);

    // member attributes:
    int speciesNumber;
    int ticks;
    int day;                     // counting days
    int actHabitatCover;

    // community indices:
    int speciesRichness;
    float shannonDiversity;
    float shannonEvenness;
    float trueDiversity;
    float behavioralDiversity;
    float behavioralEvenness;
    float gammaDiversity;
    float gammaEvenness;
    float meanHRDiameter;
    float meanBodymass;
    float meanOccupancy;

    // informative indices:
    int individuals;             // count all individuals per day
    int survival;                // count all surviving individuals per day
    int maxCountIndividuals;     // keeping track of the daily maximum [for plotting]
    int negativeBodymass;
    int individualsCounter;      // provides a unique ID for each new individual

    // landscape values:
    float sumFileValue;    // sum of all fileValues which actually are habitat (excluding matrix cells)

    // member method:
    //static Statistics* GetInstance();
    void Tick();
    void ClearAll();
    void Clear();
};

#endif // STATISTICS_H
