#ifndef SPECIES_H
#define SPECIES_H
#include <string>

class Species
{
public:
    Species();

    // Member attributes:
    int ID;
    std::string speciesName;
    std::string speciesOrder;
    float meanBodymass;
    float sdBodymass;
    float maxHomerange;
    float averageLifespan;
    float meanLitterSize;
    float sdLitterSize;
    float meanAFR;
    float sdAFR;
    float meanGestation;
    float sdGestation;
    float meanLactation;
    float sdLactation;

    int abundance; //store real time population size
    int totalOffspring;
    int successfulOffspring;
    float starvation; // proportion of starved ind. per day
    float predation; // proportion of dead ind. per day in the matrix
};

#endif // SPECIES_H
