#ifndef NEUTRALLANDSCAPE_H
#define NEUTRALLANDSCAPE_H
#include <valarray>
#include <vector>
#include <random>
#include "statistics.h"

class NeutralLandscape
{
public:
    NeutralLandscape(float H,float sigma,int steps);

    struct element{
        float value; //Wert des Feldes
        int xcoord;
        int ycoord; //Index im fraktalen Gitter
        void operator= (element*);
        bool operator< (const element) const;
    };

    int heigth;   //standard: 129*129Felder
    int width;
    int size;
    bool sortedCoords;
    float pHurst;
    float pSigma;
    std::valarray<float> liste_sorted;
    std::vector<element> liste;

    void  makeLandscape(float sigma, float Cmnull, Statistics* statistics);          //Funktion reskaliert das Fraktal und fügt Level ein
    static void sortVal(NeutralLandscape*);     //Funktion zum Sortieren der Liste (quicksort) nach Werten
    static void sortCoords(NeutralLandscape*);  //Funktion zum Sortieren der Liste (quicksort) nach Koordinaten
    long  getLength();
    int getVal(long x);
};

#endif // NEUTRALLANDSCAPE_H
