/************************************************************
 *  enthält Funktionen, die künstliche Landschaften erzeugen
 *  und behandeln
 *
 *  Autor: Katrin Körner        erstellt: 9.7.04
 *                              Bearbeitet: 23.11.06
 *************************************************************/
//---------------------------------------------------------------------------

#include "neutrallandscape.h"
#include <cmath>
#include <random>
#include <iostream>

using namespace std;

extern thread_local std::mt19937 rNG;

//Hilfsfunktionen:
float f3(float delta, int x0, int x1, int x2) { //for absorbing boundaries only
    std::normal_distribution<float> distribution(0,1);
    return (x0 + x1 + x2) / 3.0 + delta * distribution(rNG);
}

float f4(float delta, int x0, int x1, int x2, int x3) {
    std::normal_distribution<float> distribution(0,1);
    return (x0 + x1 + x2 + x3) / 4.0 + delta * distribution(rNG);
}

// ------------------------------------------------------------------------------------------------//

void NeutralLandscape::element::operator=(element* that){
  this->xcoord = that->xcoord;
  this->ycoord = that->ycoord;
  this->value  = that->value;
}

bool NeutralLandscape::element::operator< (element that)const{
  return   value<that.value;
}

// ------------------------------------------------------------------------------------------------//

// Constructor of fractal - use of midpoint displacement algorithm (Saupe 1988)
NeutralLandscape::NeutralLandscape(float H, float sigma, int steps) {
    size = steps;
    pHurst = H;
    pSigma = sigma;
    sortedCoords = true;
    heigth = width = static_cast<int>(pow(2, size) + 0.5) + 1;
    //generiere fraktale LS mit Hurst und std
    //MidPointFM2D aus Saupe(1988)
    //Übersetzung
    int maxlevel = size;  //7;
    int N = static_cast<int>(pow(2, size) + 0.5);
    std::valarray<float> X((N + 1) * (N + 1));

    bool addition = false;

    //set the initial random corners
    float delta = sigma;
    std::normal_distribution<float> distribution(0,1);

    X[0 * (N + 1) + 0] = delta * distribution(rNG);
    X[0 * (N + 1) + N] = delta * distribution(rNG);
    X[N * (N + 1) + 0] = delta * distribution(rNG);
    X[N * (N + 1) + N] = delta * distribution(rNG);

    int D = N;
    int d = N/2;
    for (int stage = 1; stage <= maxlevel; stage++) {
        //going from Type I to type II
        delta = delta * pow(0.5, 0.5 * H);
        //interpolate and offset points

        for (int x = d; x <= (N - d); x += D) {
            for (int y = d; y <= (N - d); y+= D) {
                X[x * (N + 1) + y] = f4(delta, X[(x + d) * (N + 1) + (y + d)],
                                               X[(x + d) * (N + 1) + (y - d)],
                                               X[(x - d) * (N + 1) + (y + d)],
                                               X[(x - d) * (N + 1) + (y - d)]);
            }
        }
        //displace other points also, if needed
        if (addition) {
            for (int x = 0; x <= N; x += D) {
                for (int y = 0; y <= N; y += D) {
                    X[x * (N + 1) + y] += delta * distribution(rNG);
                }
            }
        }

        //going from grid type II to type I
        delta = delta * pow(0.5, 0.5 * H);

        //interpolate and offset boundary grid points
        for (int x = d; x <= (N - d); x += D) {
            //torus shape of grid
            X[x * (N + 1) + 0] = f4(delta, X[(x + d) * (N + 1) + 0],
                                           X[(x - d) * (N + 1) + 0],
                                           X[x * (N + 1) + d],
                                           X[x * (N + 1) + N - d]);

            X[x * (N + 1) + N] = f4(delta, X[(x + d) * (N + 1) + N],
                                           X[(x - d) * (N + 1) + N],
                                           X[x * (N + 1) + N - d],
                                           X[x * (N + 1) + d]);

            X[0 * (N + 1) + x] = f4(delta, X[0 * (N + 1) + x + d],
                                           X[0 * (N + 1) + x - d],
                                           X[d * (N + 1) + x],
                                           X[(N - d) * (N + 1) + x]);

            X[N * (N + 1) + x] = f4(delta, X[N * (N + 1) + x + d],
                                           X[N * (N + 1) + x - d],
                                           X[(N - d) * (N + 1) + x],
                                           X[d * (N + 1) + x]);

             /*
               //grid having absorbing boundaries
               X[x][0] = f3(delta, X[x+d][0], X[x-d][0], X[x][d]);
               X[x][N] = f3(delta, X[x+d][N], X[x-d][N], X[x][N-d]);
               X[0][x] = f3(delta, X[0][x+d], X[0][x-d], X[d][x]);
               X[N][x] = f3(delta, X[N][x+d], X[N][x-d], X[N-d][x]);
            */

        }

        //interpolate and offset interior Points
        for (int x = d; x <= (N - d); x += D) {
            for (int y = D; y <= (N - d); y += D) {
                X[x * (N + 1) + y] = f4(delta, X[x * (N + 1) + y + d],
                                               X[x * (N + 1) + y - d],
                                               X[(x + d) * (N + 1) + y],
                                               X[(x - d) * (N + 1) + y]);
            }
        }

        for (int x=D; x<=(N-d);x+=D) {
            for (int y=d; y<=(N-d);y+=D) {
                X[x * (N + 1) + y] = f4(delta, X[x * (N + 1) + y + d],
                                               X[x * (N + 1) + y - d],
                                               X[(x + d) * (N + 1) + y],
                                               X[(x - d) * (N + 1) + y]);
            }
        }

        //displace other points if needed
        if (addition) {
            for (int x=0; x<=N; x+=D) {
                for (int y=0; y<=N; y+=D) {
                    X[x * (N + 1) + y] += delta * distribution(rNG);
                }
            }
            for (int x = d; x <= (N - d); x += D) {
                for (int y = d; y <= (N - d); y += D) {
                    X[x * (N + 1) + y] += delta * distribution(rNG);
                }
            }
        } //if addition

        D = D/2;
        d = d/2;

        //torus definition
        for (int i = 0; i <= N; i++){
            X[i * (N + 1) + 0] = X[i * (N + 1) + N];
            X[0 * (N + 1) + i] = X[N * (N + 1) + i];
        }
    }//next stage

    liste_sorted = X;
    liste.assign(heigth * width, element());

    for (int x = 0; x <= N; x++) {
        for (int y = 0; y <=N ; y++) {
            int index = x * width + y;
            liste[index].xcoord = x;
            liste[index].ycoord = y;
            liste[index].value = X[x * (N + 1) + y];
        }
    }
}

// ------------------------------------------------------------------------------------------------//

// Landscape erstellen
void NeutralLandscape::makeLandscape(float potSuit,float maxCap, Statistics* statistics) {

    sortVal(this);
    int threshold = (1 - potSuit) * getLength();

    for (int idx = 0; idx < threshold; idx++) {
        liste[idx].value = 0;
    }

    float maxValue = liste[getLength()-1].value;
    float minValue = liste[threshold].value;

    for (int idx = threshold; idx < getLength(); idx++) {
        liste[idx].value -= minValue;
        //liste[idx].value*=1/(maxValue-minValue)* maxCap;    //values 0 bis maxCap
        liste[idx].value *= 1/(maxValue - minValue) * (maxCap - 1);
        liste[idx].value += 1.0;                                //values 1 bis maxCap
        //statistics->sumFileValue += liste[idx].value;
    }

    sortCoords(this);
}

// ------------------------------------------------------------------------------------------------//

void NeutralLandscape::sortVal(NeutralLandscape* frac){
//Funktion zum Sortieren der Liste (quicksort) nach Werten
    //liste_sorted in liste kopieren:
    for (int i = 0; i < frac->getLength(); i++) {
        frac->liste[i].xcoord = i / frac->width;
        frac->liste[i].ycoord = i % frac->width;
        frac->liste[i].value = frac->liste_sorted[i];
    }
    sort(frac->liste.begin(), frac->liste.end());
    frac->sortedCoords = false;
}

// ------------------------------------------------------------------------------------------------//

void NeutralLandscape::sortCoords(NeutralLandscape* frac){
//Funktion zum Sortieren der Liste (quicksort) nach Koordinaten
   for (int i = 0; i < frac->getLength(); i++) {
       int idx = frac->liste[i].xcoord * frac->width + frac->liste[i].ycoord;
       frac->liste_sorted[idx] = frac->liste[i].value ;
   }
   frac->sortedCoords = true;
}

// ------------------------------------------------------------------------------------------------//

long NeutralLandscape::getLength() {
       return heigth * width;
}

// ------------------------------------------------------------------------------------------------//

int NeutralLandscape::getVal(long x) {
    return static_cast<int>(liste_sorted[x]);
}



