#ifndef GRIDCELL_H
#define GRIDCELL_H

#include <species.h>
#include <unordered_map>

enum HabitatType{
    Matrix = 0,
    Habitat = 1
};

enum CentralPlace{
    Empty = 0,
    Occupied = 1
};

class GridCell
{
public:
    GridCell();

    //member attributes:
    int fileValue;
    HabitatType habitatTyp;
    float riskLevel;
    float resourceAmount;
    float resourceCapacity;
    float growthRate;             // relative growth rate on mass basis [dM/M]
    float scaledResourceAmount;
    CentralPlace centralPlace;
    int speciesRichness;
    float shannonDiversity;
    float trueDiversity;
    int occupancy;
    std::unordered_map<Species*, int> occupantsSpecies;
    int x;
    int y;

    //member methods:
    float DistanceToCoreCell(int core_x, int core_y, int gridSize) const;
};

#endif // GRIDCELL_H
