#include "gridcell.h"
#include <cmath>
#include <iostream>

GridCell::GridCell()
{
    fileValue = 0;
    habitatTyp = Matrix;
    riskLevel = 0;
    resourceAmount = 0;
    resourceCapacity = 0;
    scaledResourceAmount = 0;
    growthRate = 0;
    centralPlace = Empty;
    occupancy = 0;
    x = 0;
    y = 0;
}

// ------------------------------------------------------------------------------------------------//

float GridCell::DistanceToCoreCell(int core_x, int core_y, int gridSize) const {

    int x1 = abs(core_x - x);
    int x2 = abs(core_x - (x - gridSize));
    int x3 = abs(core_x - (x + gridSize));
    int x = std::min(std::min(x1, x2), x3);

    int y1 = abs(core_y - y);
    int y2 = abs(core_y - (y - gridSize));
    int y3 = abs(core_y - (y + gridSize));
    int y = std::min(std::min(y1, y2), y3);

    float distance = sqrt(pow(x, 2) + pow(y, 2));

    return distance;
    //std::min(core_y - y, core_y - (y - gridSize));
}
