#ifndef GRID_H
#define GRID_H
#include "gridcell.h"
#include <vector>
#include <functional>
#include <random>

extern thread_local std::mt19937 rNG;

enum MatrixMortality{
    NoMortality,
    PerCell,
    PerFraction
};

class Grid
{
public:
   Grid(int aSize);
   ~Grid();

   // Member attribute:
   int size;
   bool matrixCosts;
   MatrixMortality matrixMortality;
   float maxRL; // storing maximum resource amount

   // Member methods:
   float CalculateDistanceBetweenCells(int cellA_x,int cellA_y, int cellB_x, int cellB_y);
   std::vector<GridCell*> ShuffleGridCells();
   std::vector<GridCell*> GetNeighbours(int x,int y);
   std::vector<GridCell*> GetNeighboursWith(int x,int y, std::function<bool (GridCell*)> func);
   std::vector<GridCell*> GetGridCellsInRadius(int core_x,int core_y, int radius, int skip);
   std::vector<GridCell*> GetGridCellsInRadiusWith(int core_x, int core_y, int radius, int skip, std::function<bool (GridCell*)> func);
   GridCell* GetCell(int x, int y);
   GridCell* GetCellWithBoundaryOverflow(int x, int y);
   GridCell* GetRandomCell();     // return random cell in grid
   GridCell* GetRandomCellWith(std::function<bool (const GridCell*)> func);
   GridCell* GetRandomCellInRadius(int core_x, int core_y, int radius, int skip);
   GridCell* GetRandomCellInRadiusWith(int core_x, int core_y, int radius, int skip, std::function<bool (const GridCell*)> func);

private:
   // Two-dimensional array
   GridCell** grid = {};

};

#endif // GRID_H
