# matrix-paper
Source code and data for the manuscript "Variations in Risk-Taking Behaviour Mediate Matrix Mortality's Impact on Biodiversity Under Fragmentation"

## Overview

This repository provides the source code for the implementation of a dynamic and spatially-explicit individual-based community model as well as the used input files to derive our results. The results and their visualization in R are also provided as csv-files and R-Scripts.

While simulating home range establishment (`FindHomerange`) and daily foraging movements within the home range (`CheckHomerange`) for all indivdiuals in the small mammal community, we estimate the effect of landscape fragmentation with four distinct fragmentation levels: Very high, high, intermediate and low. Different matrix costs can be simulated, either a direct mortality, with different levels of mortality risk, or deffered matrix costs, which increase the locomotion costs of an individual. Further, we created three behavioural scenarios to evaluate risk-taking behaviour while foraging as a potential mechanism that might mediate the impact of matrix costs in fragmentated landscapes.

## Requirements ##

- C++ compiler (e.g. clang from XCode)
- [Qt](https://www.qt.io/download-qt-installer), min. version 4

## Setup ## 

You can run these steps either in Qt Creator or via the command line as shown below.

1. **Clone the repository including submodules(!)**
```
git clone https://github.com/Rohwaeder/dynamic-homerange-model.git --recurse-submodules 
```

2. **Build qtcsv** (you only need to do this step once)
```
cd YOUR-DEVELOPMENT-FOLDER/dynamic-homerange-model/qtscv/
qmake-qt5 CONFIG+=release
make
```
(You should have a `build-qtcsv-Release` folder in your `dynamic-homerange-model` folder now)

Ensure libqtscv is in the shared library path, e.g. by adding the following to your `~/.bashrc`:

```
export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/YOUR-DEVELOPMENT-FOLDER/dynamic-homerange-model/build-qtcsv-Release/
```

3. **Build project**

For optimal performance include `CONFIG+=release` as shown below. For debugging exclude this option, which will default to `debug` configuration.
```
cd YOUR-DEVELOPMENT-FOLDER/dynamic-homerange-model/
qmake-qt5 CONFIG+=release
make
```

## Running simulations

To run your simulations the following options are required:

1. Options defining the simulation scenario:

- Landscape fragmentation is determined through the spatial autocorrelation (Hurst-factor) of cells in fractal landscapes. The Hurst-factor can be varied between 0 and 1, with 0.1 representing a high and 0.9 a low level of fragmentation. Additionally, a random distribution of habitat in the landscape can be achieved to represent very high levels of fragmentation.
```
  -f, --fragmentation <float between 0 and 1> Level of fragmentation as Hurst factor (0.1 = high, 0.5 = intermediate, 0.9 = low and 2 = random distribution [very high fragmentation]).
```
- Habitat amount can vary between 0% and 100% and needs to parsed as an integer value. The remaining landscape cells are defined as matrix.
```
  -c, --habitat <integer between 0 and 100>  Specify fraction of landscape that is covered with habitat cells.
```
- The behavioural scenario can be choosen from three different options determining the initial behavioral distribution in the community: only risk-seeking individuals (0), only risk-avoiding individuals (1) or individual level differences in risk-taking behaviour, which is heritable (2).
```
  -b, --boldness <float between 0 and 1>  Specify behavioural scenario for the community (0 = homogeneous risk-seeking, 1 = homogeneous risk-avoiding or 2 = heterogeneous risk-taking).
```
- The deferred matrix costs are passed as a boolean and can either be 0 to run simulations without deferred matrix costs or 1 to simulate deferred matrix costs, which are simulated by invoking additional locomoction costs for an individual visiting a matrix cell. 
```
  -g, --deferredCosts <bool>  Specify scenario of deferred matrix costs.
```
- The direct matrix costs are passed as a float, which specifies the mortality risk for an individual within each vistited matrix cell.  
```
  -e, --matrixMortality <float>  Specify the mortality probability per visited matrix cell.
```
- The patch length defines the dimensions of a single landscape cell in m. Each landscape has 129x129 cells, therefore the patch length also determines the absolut landscape size.
```
  -p, --patch length <integer>  Specify length and width of one landscape cell
```
- Provide the a float between 0 and 1 controlling the foraging preferences when choosing the next cell, either minimizing distances (0) or maximizing resources (1). For all simulations in the manuscript 0.5 is used. 
```
  -i, --searchFactor <float>  Specify the balance between maximizing food gain and minimizing distances while foraging.
```
- Simulations can be run either with or without a negative density dependence to controll population growth rate and intraspecific competition.
```
  -d, --densityControl <bool>  Specify negative density dependence.
```
- Provide the total runtime of a simulation in days. 
```
  -t, --simulationTime <integer>  Temporal scale of a simulation in days..
```
- Repetitions defines the number of replicate simulations, which are run with the same set of parameters (options above). Each replicate simulation creates a new fractal landscape with the same characteristics.
```
  -r, --repetitions <integer>  Number of repetitions of the same scenario in a different landscape.
```  

2. Declare inputand output files:

Each simulations needs a file containing the species in the community:
```
  -s, --species <file>  Take species input data from <file>.
```  

The species community file used for the simulations in our manuscript can be found [here](https://github.com/Rohwaeder/fragmentation-paper/tree/fragmentation-paper/data/input_data/). 

Finally, you need to declare where the simulation should save its results:
```
  -o, --filenameout <file>                     Declare <file> to save output data.
```                                               

To get an overview of all available options:
```
    -h, --help                                   Displays this help.
```                                               
