# dictionary describing the DeepMIP-Eocene-p1 models

model_dict = {
    "CESM1.2-CAM5": {
        "versn": "v1.0",
        "family": "CESM",
        "abbrv": "CESM",
        "institution": "Department of Earth and Environmental Science, University of Michigan, Ann Arbor, USA",
        "climYears": ["1800-1899", "2500-2599", "1900-1999", "1900-1999", "1900-1999"],
        "exps": ["deepmip-eocene-p1-PI", "deepmip-eocene-p1-x1", "deepmip-eocene-p1-x3", "deepmip-eocene-p1-x6", "deepmip-eocene-p1-x9"],
        "gmst": [13.2, 18.4, 25.0, 29.8, 35.5],
        "calendar": "365_day",
        "rotation": "H14",
        "CMIP generation": "CMIP5",
    },
    "COSMOS-landveg-r2413": {
        "versn": "v1.0",
        "family": "COSMOS",
        "abbrv": "COSMOS",
        "institution": "Alfred Wegener Institute, Helmholtz Centre for Polar and Marine Research, Bremerhaven, Germany",
        "exps": ["deepmip-eocene-p1-PI", "deepmip-eocene-p1-x1", "deepmip-eocene-p1-x3", "deepmip-eocene-p1-x4"],
        "climYears": ["1800-1899", "9400-9499", "9400-9499", "9400-9499"],
        "gmst": [13.9, 17.0, 25.2, 26.9],
        "calendar": "proleptic_gregorian",
        "rotation": "H14",
        "CMIP generation": "CMIP3",
    },
    "GFDL-CM2.1": {
        "versn": "v1.0",
        "family": "GFDL",
        "abbrv": "GFDL",
        "institution": "Department of Geological Sciences, Stockholm University, Stockholm, Sweden & Climate Change Research Centre, University of New South Wales Sydney, Sydney, Australia",
        "exps": ["deepmip-eocene-p1-PI", "deepmip-eocene-p1-x1", "deepmip-eocene-p1-x2", "deepmip-eocene-p1-x3", "deepmip-eocene-p1-x4", "deepmip-eocene-p1-x6"],
        "climYears": ["1800-1899", "5900-5999", "5900-5999", "5900-5999", "5900-5999", "5900-5999"],
        "gmst": [15.6, 19.2, 22.9, 25.4, 27.5, 30.2],
        "calendar": "365_day",
        "rotation": "H14",
        "CMIP generation": "CMIP3",
    },
    "HadCM3B-M2.1aN": {
        "versn": "v1.0",
        "family": "HadCM3",
        "abbrv": "HadCM3",
        "institution": "School of Geographical Sciences, University of Bristol, Bristol, UK",
        "exps": ["deepmip-eocene-p1-PI", "deepmip-eocene-p1-x1", "deepmip-eocene-p1-x2", "deepmip-eocene-p1-x3"],
        "climYears": ["1800-1899", "7250-7349", "7750-7849", "7750-7849"],
        "gmst": [13.9, 17.4, 21.2, 25.0],
        "calendar": "360_day",
        "rotation": "H14",
        "CMIP generation": "CMIP3",
    },
    "HadCM3BL-M2.1aN": {
        "versn": "v1.0",
        "family": "HadCM3",
        "abbrv": "HadCM3L",
        "institution": "School of Geographical Sciences, University of Bristol, Bristol, UK",
        "exps": ["deepmip-eocene-p1-PI", "deepmip-eocene-p1-x1", "deepmip-eocene-p1-x2", "deepmip-eocene-p1-x3"],
        "climYears": ["1800-1899", "7400-7499", "7400-7499", "7400-7499"],
        "gmst": [13.2, 16.9, 21.1, 26.0],
        "calendar": "360_day",
        "rotation": "H14",
        "CMIP generation": "CMIP3",
    },
    "INM-CM4-8": {
        "versn": "v1.0",
        "family": "INMCM",
        "abbrv": "INM",
        "institution": "Institute of Numerical Mathematics, Russian Academy of Sciences, Moscow, Russia",
        "exps": ["deepmip-eocene-p1-PI", "deepmip-eocene-p1-x6"],
        "climYears": ["1800-1899", "1051-1150"],
        "gmst": [13.2, 23.4],
        "calendar": "365_day",
        "rotation": "H14",
        "CMIP generation": "CMIP6",
    },
    "IPSLCM5A2": {
        "versn": "v1.0",
        "family": "IPSL",
        "abbrv": "IPSL",
        "institution": "Laboratoire des Sciences du Climat et de l’Environnement, LSCE/IPSL, CEA-CNRS-UVSQ, Université Paris-Saclay, Gif-sur-Yvette, France",
        "exps": ["deepmip-eocene-p1-PI", "deepmip-eocene-p1-x1.5", "deepmip-eocene-p1-x3"],
        "climYears": ["1800-1899", "3900-3999", "5400-5499"],
        "gmst": [13.2, 19.4, 25.0],
        "calendar": "360_day",
        "rotation": "H14",
        "CMIP generation": "CMIP5",
    },
    "MIROC4m": {
        "versn": "v1.0",
        "family": "MIROC",
        "abbrv": "MIROC",
        "institution": "Atmosphere and Ocean Research Institute, University of Tokyo, Kashiwa, Japan",
        "exps": ["deepmip-eocene-p1-PI", "deepmip-eocene-p1-x1", "deepmip-eocene-p1-x2", "deepmip-eocene-p1-x3"],
        "climYears": ["1800-1899", "4900-4999", "4900-4999", "4900-4999"],
        "gmst": [12.9, 16.6, 20.4, 23.5],
        "calendar": "proleptic_gregorian",
        "rotation": "H14",
        "CMIP generation": "CMIP3",
    },
    "NorESM1-F": {
        "versn": "v1.0",
        "family": "NorESM",
        "abbrv": "NorESM",
        "institution": "NORCE Norwegian Research Centre, Bjerknes Centre for Climate Research, Bergen, Norway",
        "exps": ["deepmip-eocene-p1-PI", "deepmip-eocene-p1-x2", "deepmip-eocene-p1-x4"],
        "climYears": ["1800-1899", "2000-2099", "2000-2099"],
        "gmst": [14.5, 21.2, 24.1],
        "calendar": "365_day",
        "rotation": "B16",
        "CMIP generation": "CMIP5-6",
    }
}
